/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.annotation;

import com.ibm.icu.util.StringTokenizer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.annotation.Annotation;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.annotation.AnnotationFileInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.annotation.AnnotationFileParser;

public class AnnotationMap {
    protected List list = new Vector();
    protected Hashtable hashtable = new Hashtable();
    protected boolean isCaseSensitive = true;

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void addAnnotation(Annotation annotation) {
        String spec = annotation.getSpec();
        if (spec != null) {
            this.list.add(annotation);
            StringTokenizer st = new StringTokenizer(spec, "[]|\t\n\r\f ");
            while (st.hasMoreTokens()) {
                String cmNodeSpec = st.nextToken();
                this.addAnnotationForCMNodeSpec(cmNodeSpec, annotation);
            }
        }
    }

    protected void addAnnotationForCMNodeSpec(String cmNodeSpec, Annotation annotation) {
        String key = this.isCaseSensitive ? cmNodeSpec : cmNodeSpec.toLowerCase();
        Vector<Annotation> list = (Vector<Annotation>)this.hashtable.get(key);
        if (list == null) {
            list = new Vector<Annotation>();
            this.hashtable.put(key, list);
        }
        list.add(annotation);
    }

    public String getProperty(String cmNodeSpec, String propertyName) {
        String result = null;
        String key = this.isCaseSensitive ? cmNodeSpec : cmNodeSpec.toLowerCase();
        List annotationList = (List)this.hashtable.get(key);
        if (annotationList != null) {
            Iterator i = annotationList.iterator();
            while (i.hasNext()) {
                Annotation annotation = (Annotation)i.next();
                result = annotation.getProperty(propertyName);
                if (result != null) break;
            }
        }
        return result;
    }

    public String getProperty(CMNode cmNode, String propertyName) {
        String result = null;
        String cmNodeSpec = (String)cmNode.getProperty("spec");
        if (cmNodeSpec == null) {
            cmNodeSpec = cmNode.getNodeName();
        }
        if (cmNodeSpec != null) {
            result = this.getProperty(cmNodeSpec, propertyName);
        }
        return result;
    }

    public List getAnnotations() {
        return this.list;
    }

    public void load(String uri, String bundleId) throws Exception {
        AnnotationFileParser parser = new AnnotationFileParser();
        AnnotationFileInfo fileInfo = new AnnotationFileInfo(uri, bundleId);
        parser.parse(this, fileInfo);
    }
}

