/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.jee.archive.AbstractArchiveAdapter;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.IArchiveSaveAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArchiveSaveAdapter
extends AbstractArchiveAdapter
implements IArchiveSaveAdapter {
    protected IArchiveResource manifest = null;
    protected IArchiveResource metaInf = null;

    @Override
    public void close() throws IOException {
    }

    @Override
    public void finish() throws IOException {
    }

    @Override
    public void save(IProgressMonitor monitor) throws ArchiveSaveFailureException {
        Exception caughtException = null;
        try {
            try {
                monitor.beginTask(CommonArchiveResourceHandler.AbstractArchiveSaveAdapter_Saving_resource_, 2010);
                List<IArchiveResource> files = this.getArchiveResourcesForSave();
                Path manifestPath = new Path("META-INF/MANIFEST.MF");
                if (this.getArchive().containsArchiveResource((IPath)manifestPath)) {
                    this.manifest = this.getArchive().getArchiveResource((IPath)manifestPath);
                }
                IPath metaInfPath = manifestPath.removeFirstSegments(1);
                if (this.getArchive().containsArchiveResource(metaInfPath)) {
                    this.metaInf = this.getArchive().getArchiveResource(metaInfPath);
                }
                monitor.worked(1000);
                SubProgressMonitor saveSubMonitor = new SubProgressMonitor(monitor, 1000);
                int SUB_SAVE_TICKS = 10;
                int SUB_TOTAL_TICKS = SUB_SAVE_TICKS * (files.size() + 2);
                try {
                    saveSubMonitor.beginTask(CommonArchiveResourceHandler.AbstractArchiveSaveAdapter_Saving_resource_, SUB_TOTAL_TICKS);
                    if (this.manifest != null) {
                        this.save(this.manifest);
                    }
                    saveSubMonitor.worked(SUB_SAVE_TICKS);
                    if (this.metaInf != null) {
                        this.save(this.metaInf);
                    }
                    saveSubMonitor.worked(SUB_SAVE_TICKS);
                    for (IArchiveResource file : files) {
                        if (this.shouldSave(file)) {
                            this.save(file);
                        }
                        saveSubMonitor.worked(SUB_SAVE_TICKS);
                    }
                }
                finally {
                    saveSubMonitor.done();
                }
            }
            catch (Exception e) {
                caughtException = e;
                try {
                    try {
                        this.finish();
                    }
                    catch (IOException e2) {
                        throw new ArchiveSaveFailureException(e2);
                    }
                }
                finally {
                    monitor.done();
                    if (caughtException != null) {
                        throw new ArchiveSaveFailureException(caughtException);
                    }
                }
            }
        }
        finally {
            try {
                try {
                    this.finish();
                }
                catch (IOException e) {
                    throw new ArchiveSaveFailureException(e);
                }
            }
            finally {
                monitor.done();
                if (caughtException != null) {
                    throw new ArchiveSaveFailureException(caughtException);
                }
            }
        }
    }

    protected List<IArchiveResource> getArchiveResourcesForSave() {
        List<IArchiveResource> files = this.getArchive().getArchiveResources();
        return files;
    }

    protected abstract void save(IArchiveResource var1) throws ArchiveSaveFailureException;

    protected boolean shouldSave(IArchiveResource file) {
        return file != this.manifest && file != this.metaInf;
    }
}

