/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.monitor.ExtensibilityElementTransformerRegistry;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ComputeEndpointCommand
extends AbstractDataModelOperation {
    private WebServicesParser webServicesParser;
    private String wsdlURI;
    private Boolean monitorService;
    private Integer monitoredPort;

    public void setMonitoredPort(Integer monitoredPort) {
        this.monitoredPort = monitoredPort;
    }

    public void setMonitorService(Boolean monitorService) {
        this.monitorService = monitorService;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public String getEndpoint() {
        Definition def;
        if (this.monitorService != null && this.monitorService.booleanValue() && this.monitoredPort != null && (def = this.webServicesParser.getWSDLDefinition(this.wsdlURI)) != null) {
            Iterator it = def.getServices().values().iterator();
            while (it.hasNext()) {
                Service service = (Service)it.next();
                Iterator it2 = service.getPorts().values().iterator();
                while (it2.hasNext()) {
                    Port port = (Port)it2.next();
                    Iterator it3 = port.getExtensibilityElements().iterator();
                    while (it3.hasNext()) {
                        ExtensibilityElement ext = (ExtensibilityElement)it3.next();
                        String location = null;
                        location = ext instanceof SOAPAddress ? ((SOAPAddress)ext).getLocationURI() : ExtensibilityElementTransformerRegistry.INSTANCE.transform(ext);
                        if (location == null) continue;
                        if (location.startsWith("https://")) {
                            location = "http://" + location.substring(8);
                        }
                        try {
                            URL url = new URL(location);
                            url = new URL(url.getProtocol(), url.getHost(), this.monitoredPort, url.getFile());
                            return url.toString();
                        }
                        catch (MalformedURLException malformedURLException) {
                            String file;
                            int protocolIndex = location.indexOf("://");
                            if (protocolIndex == -1) continue;
                            String protocol = location.substring(0, protocolIndex + 3);
                            int hostPortIndex = location.indexOf(47, protocolIndex + 3);
                            if (hostPortIndex == -1) {
                                hostPortIndex = location.length();
                                file = "";
                            } else {
                                file = location.substring(hostPortIndex, location.length());
                            }
                            String hostPort = location.substring(protocolIndex + 3, hostPortIndex);
                            int hostIndex = hostPort.indexOf(58);
                            String host = hostIndex != -1 ? hostPort.substring(0, hostIndex + 1) : String.valueOf(hostPort) + ':';
                            String newPort = String.valueOf(this.monitoredPort);
                            StringBuffer endpoint = new StringBuffer(protocol);
                            endpoint.append(host);
                            endpoint.append(newPort);
                            endpoint.append(file);
                            return endpoint.toString();
                        }
                    }
                }
            }
        }
        return null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }
}

