/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.archive.IArchiveExportParticipant;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentExportDataModelProperties;
import org.eclipse.jst.j2ee.internal.archive.ArchiveExportParticipantsExtensionPoint;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public abstract class J2EEArtifactExportDataModelProvider
extends AbstractDataModelProvider
implements IJ2EEComponentExportDataModelProperties {
    public HashMap componentMap;

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.RUN_BUILD");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.COMPONENT");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.RUNTIME");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS");
        return propertyNames;
    }

    protected abstract String getProjectType();

    protected abstract String getWrongComponentTypeString(String var1);

    protected abstract String getModuleExtension();

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION")) {
            return "";
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME")) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME")) {
            return this.getDataModel().getValidPropertyDescriptors("IJ2EEComponentExportDataModelProperties.RUNTIME").length > 0;
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.RUNTIME")) {
            return this.getBooleanProperty("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME");
        }
        return true;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean set = super.propertySet(propertyName, propertyValue);
        IDataModel dm = this.getDataModel();
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.PROJECT_NAME")) {
            IVirtualComponent component;
            if (this.getComponentMap().isEmpty()) {
                this.intializeComponentMap();
            }
            if ((component = (IVirtualComponent)this.getComponentMap().get(propertyValue)) != null && component.getName().equals(propertyValue)) {
                this.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", component);
            } else {
                this.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", null);
            }
            dm.notifyPropertyChange("IJ2EEComponentExportDataModelProperties.RUNTIME", 4);
            IFacetedProject fproj = null;
            if (component != null) {
                try {
                    fproj = ProjectFacetsManager.create((IProject)component.getProject());
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(-1, e.getMessage(), e);
                }
            }
            boolean optimize = false;
            IRuntime runtime = null;
            if (fproj != null) {
                runtime = fproj.getPrimaryRuntime();
                if (runtime != null) {
                    optimize = true;
                } else {
                    DataModelPropertyDescriptor[] validValues = dm.getValidPropertyDescriptors("IJ2EEComponentExportDataModelProperties.RUNTIME");
                    if (validValues.length > 0) {
                        runtime = (IRuntime)validValues[0].getPropertyValue();
                    }
                }
            }
            this.setProperty("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME", optimize);
            this.setProperty("IJ2EEComponentExportDataModelProperties.RUNTIME", runtime);
        } else if (propertyName.equals("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME")) {
            dm.notifyPropertyChange("IJ2EEComponentExportDataModelProperties.RUNTIME", 3);
        } else if (propertyName.equals("IJ2EEComponentExportDataModelProperties.RUNTIME")) {
            IProject project;
            List currentExtDataList = (List)this.getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS");
            if (currentExtDataList != null) {
                for (IJ2EEComponentExportDataModelProperties.IArchiveExportParticipantData extData : currentExtDataList) {
                    dm.removeNestedModel(extData.getId());
                }
            }
            ArrayList<ArchiveExportParticipantData> extensions = new ArrayList<ArchiveExportParticipantData>();
            if (propertyValue != null && (project = this.getProject()) != null) {
                IRuntime runtime = (IRuntime)propertyValue;
                for (ArchiveExportParticipantsExtensionPoint.ParticipantInfo partInfo : ArchiveExportParticipantsExtensionPoint.getExtensions(project, runtime)) {
                    ArchiveExportParticipantData partData = new ArchiveExportParticipantData();
                    partData.id = partInfo.getId();
                    partData.extension = partInfo.loadParticipant();
                    if (partData.extension != null) {
                        try {
                            partData.datamodel = partData.extension.createDataModel(dm);
                            dm.addNestedModel(partData.id, partData.datamodel);
                        }
                        catch (Exception e) {
                            J2EEPlugin.logError(-1, e.getMessage(), e);
                            partData = null;
                        }
                    } else {
                        partData = null;
                    }
                    if (partData == null) continue;
                    extensions.add(partData);
                }
            }
            this.setProperty("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS", Collections.unmodifiableList(extensions));
        }
        return set;
    }

    public HashMap getComponentMap() {
        if (this.componentMap == null) {
            this.componentMap = new HashMap();
        }
        return this.componentMap;
    }

    public void intializeComponentMap() {
        IVirtualComponent[] comps = ComponentUtilities.getAllWorkbenchComponents();
        int i = 0;
        while (i < comps.length) {
            this.getComponentMap().put(comps[i].getName(), comps[i]);
            ++i;
        }
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        IRuntime runtime;
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.RUNTIME") && (runtime = (IRuntime)this.getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME")) != null) {
            return new DataModelPropertyDescriptor((Object)runtime, runtime.getLocalizedName());
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.PROJECT_NAME")) {
            ArrayList<String> componentNames = new ArrayList<String>();
            IVirtualComponent[] wbComps = ComponentUtilities.getAllWorkbenchComponents();
            ArrayList<IVirtualComponent> relevantComponents = new ArrayList<IVirtualComponent>();
            int i = 0;
            while (i < wbComps.length) {
                if (J2EEProjectUtilities.getJ2EEProjectType(wbComps[i].getProject()).equals(this.getProjectType())) {
                    relevantComponents.add(wbComps[i]);
                    this.getComponentMap().put(wbComps[i].getName(), wbComps[i]);
                }
                ++i;
            }
            if (relevantComponents.size() == 0) {
                return null;
            }
            int j = 0;
            while (j < relevantComponents.size()) {
                componentNames.add(((IVirtualComponent)relevantComponents.get(j)).getName());
                ++j;
            }
            Object[] names = componentNames.toArray(new String[componentNames.size()]);
            return DataModelPropertyDescriptor.createDescriptors((Object[])names);
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.RUNTIME")) {
            ArrayList<IRuntime> runtimes = new ArrayList<IRuntime>();
            IVirtualComponent component = (IVirtualComponent)this.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
            if (component != null) {
                try {
                    IFacetedProject fproj = ProjectFacetsManager.create((IProject)component.getProject());
                    for (IRuntime runtime : RuntimeManager.getRuntimes()) {
                        if (!fproj.isTargetable(runtime)) continue;
                        runtimes.add(runtime);
                    }
                    DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[runtimes.size()];
                    Iterator iterator = runtimes.iterator();
                    int i = 0;
                    while (i < descriptors.length) {
                        IRuntime runtime = (IRuntime)iterator.next();
                        descriptors[i] = new DataModelPropertyDescriptor((Object)runtime, runtime.getLocalizedName());
                        ++i;
                    }
                    if (descriptors.length > 2) {
                        Arrays.sort(descriptors, 0, descriptors.length, new Comparator(){

                            public int compare(Object arg0, Object arg1) {
                                DataModelPropertyDescriptor d1 = (DataModelPropertyDescriptor)arg0;
                                DataModelPropertyDescriptor d2 = (DataModelPropertyDescriptor)arg1;
                                return d1.getPropertyDescription().compareTo(d2.getPropertyDescription());
                            }
                        });
                    }
                    return descriptors;
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(-1, e.getMessage(), e);
                }
            }
            return DataModelPropertyDescriptor.createDescriptors(null);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String propertyName) {
        String location;
        if ("IJ2EEComponentExportDataModelProperties.PROJECT_NAME".equals(propertyName)) {
            String projectName = (String)this.model.getProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
            if (projectName == null || projectName.equals("")) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"38"));
            }
            IVirtualComponent component = (IVirtualComponent)this.componentMap.get(projectName);
            if (component == null) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"38"));
            }
            if (!J2EEProjectUtilities.getJ2EEProjectType(component.getProject()).equals(this.getProjectType())) {
                return WTPCommonPlugin.createErrorStatus((String)this.getWrongComponentTypeString(projectName));
            }
        }
        if ("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION".equals(propertyName)) {
            IStatus tempStatus;
            String archiveLocation = (String)this.model.getProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
            if (!this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION") || archiveLocation.equals("")) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"10"));
            }
            if (this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION") && !this.validateModuleType(archiveLocation)) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"9", (Object[])new Object[]{this.getModuleExtension()}));
            }
            if (this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION") && (tempStatus = this.validateLocation(archiveLocation)) != OK_STATUS) {
                return tempStatus;
            }
        }
        if (("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION".equals(propertyName) || "IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING".equals(propertyName)) && this.checkForExistingFileResource(location = (String)this.getProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION"))) {
            return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"12", (Object[])new Object[]{location}));
        }
        return OK_STATUS;
    }

    private IStatus validateLocation(String archiveLocation) {
        Path path = null;
        try {
            path = new Path(archiveLocation);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"10"));
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(path.lastSegment(), 1);
        if (!status.isOK()) {
            return status;
        }
        String device = path.getDevice();
        if (device == null) {
            return OK_STATUS;
        }
        if (device.length() == 1 && device.charAt(0) == ':') {
            return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"10"));
        }
        if (!path.toFile().canWrite()) {
            if (path.toFile().exists()) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"11"));
            }
            boolean OK = false;
            path = path.removeLastSegments(1);
            int i = 1;
            while (!OK && i < 20 && path.segmentCount() > 0) {
                if (path.toFile().exists()) {
                    OK = true;
                }
                if (!(status = workspace.validateName(path.lastSegment(), 2)).isOK()) {
                    return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"10"));
                }
                path = path.removeLastSegments(1);
                ++i;
            }
        }
        return OK_STATUS;
    }

    private boolean checkForExistingFileResource(String fileName) {
        File externalFile;
        return !this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING") && (externalFile = new File(fileName)).exists();
    }

    private boolean validateModuleType(String archive) {
        return archive.length() >= 4 && archive.substring(archive.length() - 4, archive.length()).equalsIgnoreCase(this.getModuleExtension());
    }

    private IProject getProject() {
        IVirtualComponent component = (IVirtualComponent)this.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
        if (component != null) {
            return component.getProject();
        }
        return null;
    }

    private static final class ArchiveExportParticipantData
    implements IJ2EEComponentExportDataModelProperties.IArchiveExportParticipantData {
        private String id = null;
        private IArchiveExportParticipant extension = null;
        private IDataModel datamodel = null;

        private ArchiveExportParticipantData() {
        }

        public String getId() {
            return this.id;
        }

        public IArchiveExportParticipant getParticipant() {
            return this.extension;
        }

        public IDataModel getDataModel() {
            return this.datamodel;
        }
    }
}

