/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.comment;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.comment.CommentingStrategy;

public class BlockCommentingStrategy
extends CommentingStrategy {
    private String fPrefix;
    private String fSuffix;

    public BlockCommentingStrategy(String prefix, String suffix) {
        this.fPrefix = prefix;
        this.fSuffix = suffix;
    }

    public void apply(IStructuredDocument document, int offset, int length) throws BadLocationException {
        int commentPrefixOffset = offset;
        int commentSuffixOffset = commentPrefixOffset + length;
        try {
            document.replace(commentSuffixOffset, 0, " " + this.fSuffix);
            this.remove(document, commentPrefixOffset + this.fPrefix.length(), length, false);
            document.replace(commentPrefixOffset, 0, String.valueOf(this.fPrefix) + " ");
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }

    public void remove(IStructuredDocument document, int offset, int length, boolean removeEnclosing) throws BadLocationException {
        Region region = new Region(offset, length);
        ITypedRegion[] typedRegions = document.computePartitioning(region.getOffset(), region.getLength());
        List commentRegions = this.getAssociatedCommentedRegions(typedRegions);
        int i = commentRegions.size() - 1;
        while (i >= 0) {
            try {
                IStructuredDocumentRegion structuredRegion;
                ITypedRegion typedRegion = (ITypedRegion)commentRegions.get(i);
                Region commentRegion = new Region(typedRegion.getOffset(), typedRegion.getLength());
                if (!this.alreadyCommenting(document, (IRegion)commentRegion) && !this.alreadyCommenting(document, (IRegion)(commentRegion = new Region((structuredRegion = document.getRegionAtCharacterOffset(commentRegion.getOffset())).getStartOffset(), structuredRegion.getLength())))) {
                    ITextRegion enclosedRegion = structuredRegion.getRegionAtCharacterOffset(typedRegion.getOffset());
                    int enclosedOffset = structuredRegion.getStartOffset(enclosedRegion);
                    commentRegion = new Region(enclosedOffset, structuredRegion.getTextEndOffset(enclosedRegion) - enclosedOffset);
                }
                if (this.alreadyCommenting(document, (IRegion)commentRegion)) {
                    String regionContent = document.get(commentRegion.getOffset(), commentRegion.getLength());
                    int commentPrefixOffset = commentRegion.getOffset() + regionContent.indexOf(this.fPrefix);
                    int commentSuffixOffset = commentRegion.getOffset();
                    if (removeEnclosing || commentPrefixOffset >= offset && (commentSuffixOffset += regionContent.lastIndexOf(this.fSuffix)) <= offset + length) {
                        BlockCommentingStrategy.uncomment((IDocument)document, commentPrefixOffset, this.fPrefix, commentSuffixOffset, this.fSuffix);
                    }
                } else {
                    Logger.log(4, "BlockCommentingStrategy#remove could not find the commenting region to remove");
                }
            }
            catch (BadLocationException e) {
                Logger.logException("This should only ever happen if something has gone wrong with the partitioning", e);
            }
            --i;
        }
    }

    public boolean alreadyCommenting(IStructuredDocument document, IRegion region) throws BadLocationException {
        String regionContent = document.get(region.getOffset(), region.getLength()).trim();
        return regionContent.startsWith(this.fPrefix) && regionContent.endsWith(this.fSuffix);
    }

    public Object clone() {
        return new BlockCommentingStrategy(this.fPrefix, this.fSuffix);
    }
}

