/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class ServerLabelProvider
implements ILabelProvider,
IColorProvider,
IWorkbenchAdapter {
    private ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
    protected transient List<ILabelProviderListener> listeners;
    protected ILabelProviderListener providerListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            ServerLabelProvider.this.fireListener(event);
        }
    };

    public ServerLabelProvider() {
        this.decorator.addListener(this.providerListener);
    }

    public void addListener(ILabelProviderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<ILabelProviderListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireListener(LabelProviderChangedEvent event) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        int size = this.listeners.size();
        ILabelProviderListener[] srl = new ILabelProviderListener[size];
        this.listeners.toArray(srl);
        int i = 0;
        while (i < size) {
            block4: {
                try {
                    srl[i].labelProviderChanged(event);
                }
                catch (Exception e) {
                    if (!Trace.WARNING) break block4;
                    Trace.trace("/warning", "  Error firing label change event to " + srl[i], e);
                }
            }
            ++i;
        }
    }

    protected Image getModuleImage(String typeId) {
        if (typeId == null) {
            return null;
        }
        Image image = ImageResource.getImage(typeId);
        int ind = typeId.indexOf(".");
        while (image == null && ind >= 0) {
            typeId = typeId.substring(0, ind);
            image = ImageResource.getImage(typeId);
        }
        return image;
    }

    protected ImageDescriptor getModuleImageDescriptor(String typeId) {
        if (typeId == null) {
            return null;
        }
        ImageDescriptor image = ImageResource.getImageDescriptor(typeId);
        int ind = typeId.indexOf(".");
        while (image == null && ind >= 0) {
            typeId = typeId.substring(0, ind);
            image = ImageResource.getImageDescriptor(typeId);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        block9: {
            try {
                if (element instanceof IRuntimeType) {
                    IRuntimeType runtimeType = (IRuntimeType)element;
                    return ImageResource.getImageDescriptor(runtimeType.getId());
                }
                if (element instanceof IRuntime) {
                    IRuntime runtime = (IRuntime)element;
                    return ImageResource.getImageDescriptor(runtime.getRuntimeType().getId());
                }
                if (element instanceof IServerType) {
                    IServerType serverType = (IServerType)element;
                    return ImageResource.getImageDescriptor(serverType.getId());
                }
                if (element instanceof IServer) {
                    IServer server = (IServer)element;
                    return ImageResource.getImageDescriptor(server.getServerType().getId());
                }
                if (element instanceof IModule) {
                    IModule module = (IModule)element;
                    IModuleType mt = module.getModuleType();
                    return this.getModuleImageDescriptor(mt.getId());
                }
                if (element instanceof IModule[]) {
                    IModule[] modules = (IModule[])element;
                    IModule module = modules[modules.length - 1];
                    IModuleType mt = module.getModuleType();
                    return this.getModuleImageDescriptor(mt.getId());
                }
                if (element instanceof IWorkbenchAdapter) {
                    return ((IWorkbenchAdapter)element).getImageDescriptor(null);
                }
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block9;
                Trace.trace("/severe", "Could not get image descriptor", e);
            }
        }
        return null;
    }

    private Image decorate(Image image, Object obj) {
        Image dec = this.decorator.decorateImage(image, obj);
        if (dec != null) {
            return dec;
        }
        return image;
    }

    private String decorate(String text, Object obj) {
        String dec = this.decorator.decorateText(text, obj);
        if (dec != null) {
            return dec;
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getImage(Object element) {
        try {
            if (element instanceof IRuntimeType) {
                IRuntimeType runtimeType = (IRuntimeType)element;
                return this.decorate(ImageResource.getImage(runtimeType.getId()), (Object)runtimeType);
            }
            if (element instanceof IRuntime) {
                IRuntime runtime = (IRuntime)element;
                return this.decorate(ImageResource.getImage(runtime.getRuntimeType().getId()), (Object)runtime);
            }
            if (element instanceof IServerType) {
                IServerType serverType = (IServerType)element;
                return this.decorate(ImageResource.getImage(serverType.getId()), (Object)serverType);
            }
            if (element instanceof IServer) {
                IServer server = (IServer)element;
                if (server.getServerType() != null) return this.decorate(ImageResource.getImage(server.getServerType().getId()), (Object)server);
                return null;
            }
            if (element instanceof IModule) {
                IModule module = (IModule)element;
                IModuleType mt = module.getModuleType();
                if (mt != null) return this.decorate(this.getModuleImage(mt.getId()), (Object)module);
                return null;
            }
            if (element instanceof IModule[]) {
                IModule[] modules = (IModule[])element;
                IModule module = modules[modules.length - 1];
                IModuleType mt = module.getModuleType();
                if (mt != null) return this.decorate(this.getModuleImage(mt.getId()), (Object)modules);
                return null;
            }
            if (!(element instanceof ModuleServer)) return null;
            ModuleServer ms = (ModuleServer)element;
            IModule module = ms.module[ms.module.length - 1];
            IModuleType mt = module.getModuleType();
            if (mt != null) return this.decorate(this.getModuleImage(mt.getId()), (Object)ms);
            return null;
        }
        catch (Exception e) {
            if (!Trace.SEVERE) return null;
            Trace.trace("/severe", "Could not get image descriptor", e);
        }
        return null;
    }

    protected String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof IRuntime) {
            IRuntime runtime = (IRuntime)element;
            return this.decorate(this.getString(runtime.getName()), (Object)runtime);
        }
        if (element instanceof IServer) {
            IServer server = (IServer)element;
            return this.decorate(this.getString(server.getName()), (Object)server);
        }
        if (element instanceof IRuntimeType) {
            IRuntimeType rt = (IRuntimeType)element;
            return this.decorate(rt.getName(), (Object)rt);
        }
        if (element instanceof IServerType) {
            IServerType st = (IServerType)element;
            return this.decorate(st.getName(), (Object)st);
        }
        if (element instanceof IClient) {
            IClient client = (IClient)element;
            return this.decorate(client.getName(), (Object)client);
        }
        if (element instanceof IModule) {
            IModule module = (IModule)element;
            return this.decorate(module.getName(), (Object)module);
        }
        if (element instanceof IModule[]) {
            IModule[] modules = (IModule[])element;
            IModule module = modules[modules.length - 1];
            return this.decorate(module.getName(), (Object)modules);
        }
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            IModule module = ms.module[ms.module.length - 1];
            return this.decorate(module.getName(), (Object)ms);
        }
        if (element instanceof IWorkbenchAdapter) {
            return ((IWorkbenchAdapter)element).getLabel(null);
        }
        return "";
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        this.decorator.removeListener(this.providerListener);
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            IModule module = ms.module[0];
            if (module.isExternal()) {
                Color c = Display.getCurrent().getSystemColor(15);
                return c;
            }
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public String getLabel(Object o) {
        return this.getText(o);
    }

    public Object getParent(Object o) {
        return null;
    }
}

