/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.discovery.Discovery;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeComposite;
import org.eclipse.wst.server.ui.internal.viewers.DefaultViewerSorter;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTypeTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTypeTreeLabelProvider;

public class RuntimeTypeComposite
extends AbstractTreeComposite {
    protected IRuntimeType selection;
    protected RuntimeTypeSelectionListener listener;
    protected boolean creation;
    protected String type;
    protected String version;
    protected String runtimeTypeId;
    protected RuntimeTypeTreeContentProvider contentProvider;
    protected boolean initialSelection = true;

    public RuntimeTypeComposite(Composite parent, boolean creation, RuntimeTypeSelectionListener listener2, String type, String version, String runtimeTypeId) {
        super(parent);
        this.listener = listener2;
        this.creation = creation;
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
        this.contentProvider = new RuntimeTypeTreeContentProvider(creation, type, version, runtimeTypeId);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        RuntimeTypeTreeLabelProvider labelProvider = new RuntimeTypeTreeLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    RuntimeTypeComposite.this.treeViewer.refresh(true);
                } else {
                    obj = ServerUIPlugin.adaptLabelChangeObjects(obj);
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        RuntimeTypeComposite.this.treeViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = RuntimeTypeComposite.this.getSelection(event.getSelection());
                if (obj instanceof IRuntimeType) {
                    RuntimeTypeComposite.this.selection = (IRuntimeType)obj;
                    RuntimeTypeComposite.this.setDescription(RuntimeTypeComposite.this.selection.getDescription());
                } else {
                    RuntimeTypeComposite.this.selection = null;
                    RuntimeTypeComposite.this.setDescription("");
                }
                RuntimeTypeComposite.this.listener.runtimeTypeSelected(RuntimeTypeComposite.this.selection);
            }
        });
        this.treeViewer.setSorter((ViewerSorter)new DefaultViewerSorter());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.initialSelection) {
            this.initialSelection = false;
            if (this.contentProvider.getInitialSelection() != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.contentProvider.getInitialSelection()), true);
            }
        }
    }

    protected String getTitleLabel() {
        return Messages.runtimeTypeCompTree;
    }

    protected String getDescriptionLabel() {
        return null;
    }

    public void refresh() {
        ISelection sel = this.treeViewer.getSelection();
        this.treeViewer.setContentProvider((IContentProvider)new RuntimeTypeTreeContentProvider(this.creation, this.type, this.version, this.runtimeTypeId));
        this.treeViewer.setSelection(sel);
    }

    public IRuntimeType getSelectedRuntimeType() {
        return this.selection;
    }

    protected String getDetailsLabel() {
        return Messages.installableServerLink;
    }

    private void closeWizard(Composite comp) {
        if (comp == null || comp.isDisposed()) {
            return;
        }
        Composite c = comp.getParent();
        if (c instanceof Shell) {
            Shell s = (Shell)c;
            s.close();
        }
        this.closeWizard(c);
    }

    protected void detailsSelected() {
        if (Discovery.launchExtensionWizard((Shell)this.getShell(), (String)Messages.wizNewInstallableServerTitle, (String)Messages.wizNewInstallableServerDescription)) {
            this.closeWizard(this);
        }
    }

    public static interface RuntimeTypeSelectionListener {
        public void runtimeTypeSelected(IRuntimeType var1);
    }
}

