/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.jsdi.ArrayReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.Property;
import org.eclipse.wst.jsdt.debug.core.jsdi.Value;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.Messages;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ObjectReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.StackFrameImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.UndefinedValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;

public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    protected static final Value[] NO_VALUES = new Value[0];
    private ArrayList values = null;

    public ArrayReferenceImpl(VirtualMachineImpl vm, Map body, StackFrameImpl stackFrameImpl) {
        super(vm, body, stackFrameImpl);
    }

    public Value getValue(int index) throws IndexOutOfBoundsException {
        Value value = (Value)this.getValues().get(index);
        if (value == null) {
            return this.vm.mirrorOfNull();
        }
        return value;
    }

    public synchronized List getValues() {
        if (this.values == null) {
            HashMap<Integer, Value> members = new HashMap<Integer, Value>();
            int length = 0;
            Iterator iter = this.properties().iterator();
            while (iter.hasNext()) {
                Property property = (Property)iter.next();
                if (Character.isDigit(property.name().charAt(0))) {
                    members.put(Integer.valueOf(property.name()), property.value());
                    continue;
                }
                if (!property.name().equals("length")) continue;
                length = Integer.parseInt(property.value().valueString());
            }
            this.values = new ArrayList(length);
            int i = 0;
            while (i < length) {
                Object value = members.get(new Integer(i));
                if (value == null) {
                    value = new UndefinedValueImpl(this.vm);
                }
                this.values.add(value);
                ++i;
            }
        }
        return this.values;
    }

    public int length() {
        return this.getValues().size();
    }

    public String valueString() {
        return "Array";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NLS.bind((String)Messages.ArrayReferenceImpl_array_count_, (Object[])new String[]{Integer.toString(this.length())}));
        return buffer.toString();
    }
}

