/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent.monitor;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.virgo.kernel.services.concurrent.diagnostics.ConcurrentLogEvents;
import org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.util.math.Sets;

final class DeadlockMonitor {
    private static final int PERIOD = 10;
    private static final TimeUnit UNIT = TimeUnit.SECONDS;
    private final ScheduledExecutorService executorService;
    private final DumpGenerator dumpGenerator;
    private final EventLogger eventLogger;
    private volatile ScheduledFuture<?> future;

    public DeadlockMonitor(ScheduledExecutorService executorService, DumpGenerator dumpGenerator, EventLogger eventLogger) {
        this.executorService = executorService;
        this.dumpGenerator = dumpGenerator;
        this.eventLogger = eventLogger;
    }

    public void start() {
        this.future = this.executorService.scheduleAtFixedRate(new DeadlockMonitorTask(this.dumpGenerator, this.eventLogger), 10L, 10L, UNIT);
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    private static class DeadlockMonitorTask
    implements Runnable {
        private final DeadlockAnalyser analyser = new DeadlockAnalyser();
        private final EventLogger eventLogger;
        private final Set<DeadlockAnalyser.Deadlock> lastSeenDeadlocks = new HashSet<DeadlockAnalyser.Deadlock>();
        private final Object monitor = new Object();
        private final DumpGenerator dumpGenerator;

        public DeadlockMonitorTask(DumpGenerator dumpGenerator, EventLogger eventLogger) {
            this.dumpGenerator = dumpGenerator;
            this.eventLogger = eventLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                Object[] deadlocks = this.analyser.findDeadlocks();
                if (deadlocks != null && deadlocks.length > 0) {
                    Set asSet = Sets.asSet((Object[])deadlocks);
                    if (!asSet.equals(this.lastSeenDeadlocks)) {
                        this.eventLogger.log((LogEvent)ConcurrentLogEvents.DEADLOCK_DETECTED, new Object[0]);
                        this.dumpGenerator.generateDump("deadlock", new Throwable[0]);
                        this.lastSeenDeadlocks.clear();
                        this.lastSeenDeadlocks.addAll(asSet);
                    }
                } else {
                    this.lastSeenDeadlocks.clear();
                }
            }
        }
    }
}

