/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.TupleQuery;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CriteriaQueryImpl<T>
extends AbstractQueryImpl<T>
implements CriteriaQuery<T> {
    protected SelectionImpl<?> selection;
    protected Set<ParameterExpression<?>> parameters = new HashSet();
    protected List<Order> orderBy;
    protected List<FromImpl> joins;

    public CriteriaQueryImpl(Metamodel metamodel, AbstractQueryImpl.ResultType queryResult, Class result, CriteriaBuilderImpl queryBuilder) {
        super(metamodel, queryResult, queryBuilder, result);
    }

    public CriteriaQuery<T> select(Selection<? extends T> selection) {
        this.findRootAndParameters(selection);
        this.selection = (SelectionImpl)selection;
        if (selection.isCompoundSelection()) {
            for (Selection select : selection.getCompoundSelectionItems()) {
                if (!((InternalSelection)select).isFrom()) continue;
                ((FromImpl)select).isLeaf = false;
            }
            if (selection.getJavaType().equals(Tuple.class)) {
                this.queryResult = AbstractQueryImpl.ResultType.TUPLE;
                this.queryType = Tuple.class;
            } else if (((InternalSelection)selection).isConstructor()) {
                Selection[] selectArray = selection.getCompoundSelectionItems().toArray(new Selection[selection.getCompoundSelectionItems().size()]);
                this.populateAndSetConstructorSelection((ConstructorSelectionImpl)selection, this.selection.getJavaType(), selectArray);
                this.queryType = selection.getJavaType();
            } else {
                this.queryResult = AbstractQueryImpl.ResultType.OBJECT_ARRAY;
                this.queryType = ClassConstants.AOBJECT;
            }
        } else {
            this.queryType = selection.getJavaType();
            TypeImpl type = ((MetamodelImpl)this.metamodel).getType(this.queryType);
            if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                this.queryResult = AbstractQueryImpl.ResultType.ENTITY;
                ((FromImpl)selection).isLeaf = false;
            } else {
                this.queryResult = AbstractQueryImpl.ResultType.OTHER;
            }
        }
        return this;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... selections) {
        if (selections == null || selections.length == 0) {
            this.selection = null;
            return this;
        }
        Selection<?>[] selectionArray = selections;
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            Selection<?> select = selectionArray[n2];
            this.findRootAndParameters(select);
            if (((InternalSelection)select).isFrom()) {
                ((FromImpl)select).isLeaf = false;
            }
            ++n2;
        }
        if (this.queryResult == AbstractQueryImpl.ResultType.CONSTRUCTOR) {
            this.populateAndSetConstructorSelection(null, this.queryType, selections);
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY)) {
            if (selections.length == 1 && selections[0].getJavaType().equals(this.queryType)) {
                this.selection = (SelectionImpl)selections[0];
            } else {
                try {
                    this.populateAndSetConstructorSelection(null, this.queryType, selections);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.queryResult = AbstractQueryImpl.ResultType.PARTIAL;
                    this.selection = new CompoundSelectionImpl(this.queryType, selections);
                }
            }
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE)) {
            this.selection = new CompoundSelectionImpl(this.queryType, selections);
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.OTHER)) {
            if (selections.length == 1 && selections[0].getJavaType().equals(this.queryType)) {
                this.selection = (SelectionImpl)selections[0];
            } else {
                if (!BasicTypeHelperImpl.getInstance().isDateClass((Object)this.queryType)) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"MULTIPLE_SELECTIONS_PASSED_TO_QUERY_WITH_PRIMITIVE_RESULT"));
                }
                this.populateAndSetConstructorSelection(null, this.queryType, selections);
            }
        } else {
            this.selection = new CompoundSelectionImpl(this.queryType, selections);
        }
        return this;
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        if (selectionList == null) {
            this.selection = null;
            return this;
        }
        return this.multiselect(selectionList.toArray(new Selection[selectionList.size()]));
    }

    @Override
    public CriteriaQuery<T> where(javax.persistence.criteria.Expression<Boolean> restriction) {
        return (CriteriaQuery)super.where(restriction);
    }

    @Override
    public CriteriaQuery<T> where(Predicate ... restrictions) {
        return (CriteriaQuery)super.where(restrictions);
    }

    @Override
    public CriteriaQuery<T> groupBy(javax.persistence.criteria.Expression<?> ... grouping) {
        super.groupBy(grouping);
        return this;
    }

    @Override
    public CriteriaQuery<T> groupBy(List<javax.persistence.criteria.Expression<?>> grouping) {
        super.groupBy(grouping);
        return this;
    }

    @Override
    public CriteriaQuery<T> having(javax.persistence.criteria.Expression<Boolean> restriction) {
        super.having(restriction);
        return this;
    }

    @Override
    public CriteriaQuery<T> having(Predicate ... restrictions) {
        super.having(restrictions);
        return this;
    }

    @Override
    protected void integrateRoot(RootImpl root) {
        if (!this.roots.contains(root)) {
            this.roots.add(root);
        }
    }

    public CriteriaQuery<T> orderBy(Order ... o) {
        this.orderBy = new ArrayList<Order>();
        Order[] orderArray = o;
        int n = o.length;
        int n2 = 0;
        while (n2 < n) {
            Order order = orderArray[n2];
            this.orderBy.add(order);
            ++n2;
        }
        return this;
    }

    public CriteriaQuery<T> orderBy(List<Order> o) {
        this.orderBy = o;
        return this;
    }

    @Override
    public void addParameter(ParameterExpression<?> parameter) {
        this.parameters.add(parameter);
    }

    public void populateAndSetConstructorSelection(ConstructorSelectionImpl constructorSelection, Class<?> class1, Selection<?> ... selections) throws IllegalArgumentException {
        Class[] constructorArgs = new Class[selections.length];
        int count = 0;
        Selection<?>[] selectionArray = selections;
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            Selection<?> select = selectionArray[n2];
            constructorArgs[count++] = select.getJavaType();
            ++n2;
        }
        Constructor constructor = null;
        try {
            constructor = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(class1, constructorArgs, false)) : PrivilegedAccessHelper.getConstructorFor(class1, (Class[])constructorArgs, (boolean)false);
            if (constructorSelection == null) {
                constructorSelection = new ConstructorSelectionImpl(class1, selections);
            }
            this.queryResult = AbstractQueryImpl.ResultType.CONSTRUCTOR;
            constructorSelection.setConstructor(constructor);
            constructorSelection.setConstructorArgTypes(constructorArgs);
            this.selection = constructorSelection;
        }
        catch (Exception e) {
            Object[] params = new Object[]{this.queryType};
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"criteria_no_constructor_found", (Object[])params), e);
        }
    }

    @Override
    public CriteriaQuery<T> distinct(boolean distinct) {
        super.distinct(distinct);
        return this;
    }

    @Override
    public void addJoin(FromImpl from) {
        if (this.joins == null) {
            this.joins = new ArrayList<FromImpl>();
        }
        this.joins.add(from);
    }

    public List<Order> getOrderList() {
        return this.orderBy;
    }

    public Set<ParameterExpression<?>> getParameters() {
        return this.parameters;
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    protected ObjectLevelReadQuery createCompoundQuery() {
        ReadAllQuery query = null;
        if (this.queryResult == AbstractQueryImpl.ResultType.UNKNOWN) {
            this.queryResult = this.selection.isConstructor() ? AbstractQueryImpl.ResultType.CONSTRUCTOR : (this.selection.getJavaType().equals(Tuple.class) ? AbstractQueryImpl.ResultType.TUPLE : AbstractQueryImpl.ResultType.OBJECT_ARRAY);
        }
        if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.PARTIAL)) {
            ReadAllQuery raq = new ReadAllQuery(this.queryType);
            for (Selection<?> selection : this.selection.getCompoundSelectionItems()) {
                raq.addPartialAttribute(((SelectionImpl)selection).currentNode);
            }
            raq.setExpressionBuilder(((InternalSelection)this.selection.getCompoundSelectionItems().get(0)).getCurrentNode().getBuilder());
            query = raq;
        } else {
            ReportQuery reportQuery = null;
            if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.CONSTRUCTOR) || this.queryResult.equals((Object)AbstractQueryImpl.ResultType.OTHER)) {
                reportQuery = new ReportQuery();
                reportQuery.addConstructorReportItem(((ConstructorSelectionImpl)this.selection).translate());
                reportQuery.setShouldReturnSingleAttribute(true);
            } else {
                if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE)) {
                    reportQuery = new TupleQuery(this.selection == null ? new ArrayList() : this.selection.getCompoundSelectionItems());
                } else {
                    reportQuery = new ReportQuery();
                    reportQuery.setShouldReturnWithoutReportQueryResult(true);
                }
                reportQuery.setExpressionBuilder(((InternalSelection)this.selection.getCompoundSelectionItems().get(0)).getCurrentNode().getBuilder());
                for (Selection<?> nested : this.selection.getCompoundSelectionItems()) {
                    if (((SelectionImpl)nested).isConstructor()) {
                        reportQuery.addConstructorReportItem(((ConstructorSelectionImpl)nested).translate());
                        continue;
                    }
                    if (((SelectionImpl)nested).isCompoundSelection()) {
                        throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"NESTED_COMPOUND_SELECTION_OTHER_THAN_CONSTRUCTOR_NOT_SUPPORTED"));
                    }
                    if (((InternalSelection)nested).isFrom()) {
                        reportQuery.addItem(nested.getAlias(), ((SelectionImpl)nested).getCurrentNode(), ((FromImpl)nested).findJoinFetches());
                        continue;
                    }
                    if (((InternalExpression)nested).isCompoundExpression() && ((FunctionExpressionImpl)nested).getOperation() == "size") {
                        PathImpl collectionExpression = (PathImpl)((FunctionExpressionImpl)nested).getChildExpressions().get(0);
                        ExpressionImpl fromExpression = (ExpressionImpl)collectionExpression.getParentPath();
                        reportQuery.addAttribute(nested.getAlias(), collectionExpression.getCurrentNode().count(), ClassConstants.INTEGER);
                        reportQuery.addGrouping(fromExpression.getCurrentNode());
                        continue;
                    }
                    reportQuery.addAttribute(nested.getAlias(), ((SelectionImpl)nested).getCurrentNode(), nested.getJavaType());
                }
            }
            if (this.where != null && ((InternalSelection)this.where).getCurrentNode() != null && ((InternalSelection)this.where).getCurrentNode().getBuilder().getQueryClass() != null) {
                reportQuery.setReferenceClass(((InternalSelection)this.where).getCurrentNode().getBuilder().getQueryClass());
                reportQuery.setExpressionBuilder(((InternalSelection)this.where).getCurrentNode().getBuilder());
            } else {
                reportQuery.setExpressionBuilder(((InternalSelection)this.selection.getCompoundSelectionItems().get(0)).getCurrentNode().getBuilder());
                reportQuery.setReferenceClass(((InternalSelection)this.selection.getCompoundSelectionItems().get(0)).getCurrentNode().getBuilder().getQueryClass());
            }
            query = reportQuery;
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                for (javax.persistence.criteria.Expression exp : this.groupBy) {
                    reportQuery.addGrouping(((InternalSelection)exp).getCurrentNode());
                }
            }
            if (this.havingClause != null) {
                reportQuery.setHavingExpression(((InternalSelection)this.havingClause).getCurrentNode());
            }
        }
        return query;
    }

    protected ObjectLevelReadQuery createSimpleQuery() {
        PathImpl collectionExpression;
        List<Object> list;
        ReadAllQuery query = null;
        if (this.queryResult == AbstractQueryImpl.ResultType.UNKNOWN) {
            if (this.selection == null) {
                if (this.roots != null && !this.roots.isEmpty()) {
                    this.selection = (SelectionImpl)this.roots.iterator().next();
                    query = new ReadAllQuery(((FromImpl)this.selection).getJavaType());
                    List<Expression> list2 = ((FromImpl)this.roots.iterator().next()).findJoinFetches();
                    for (Expression fetch : list2) {
                        query.addJoinedAttribute(fetch);
                    }
                    if (!list2.isEmpty()) {
                        query.setShouldFilterDuplicates(false);
                        query.setExpressionBuilder(list2.get(0).getBuilder());
                    }
                } else if (this.roots == null || this.roots.isEmpty()) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"CRITERIA_NO_ROOT_FOR_COMPOUND_QUERY"));
                }
            } else {
                TypeImpl<?> type = ((MetamodelImpl)this.metamodel).getType(this.selection.getJavaType());
                if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                    query = new ReadAllQuery(type.getJavaType());
                    list = ((FromImpl)this.roots.iterator().next()).findJoinFetches();
                    for (Expression expression : list) {
                        query.addJoinedAttribute(expression);
                    }
                    if (!list.isEmpty()) {
                        query.setShouldFilterDuplicates(false);
                    }
                    query.setExpressionBuilder(this.selection.getCurrentNode().getBuilder());
                } else {
                    query = new ReportQuery();
                    query.setReferenceClass(this.selection.getCurrentNode().getBuilder().getQueryClass());
                    if (!this.selection.isCompoundSelection() && ((InternalExpression)((Object)this.selection)).isCompoundExpression()) {
                        if (((FunctionExpressionImpl)this.selection).getOperation() == "size") {
                            collectionExpression = (PathImpl)((FunctionExpressionImpl)this.selection).getChildExpressions().get(0);
                            ExpressionImpl expressionImpl = (ExpressionImpl)collectionExpression.getParentPath();
                            ((ReportQuery)query).addAttribute(this.selection.getAlias(), collectionExpression.getCurrentNode().count(), ClassConstants.INTEGER);
                            ((ReportQuery)query).addGrouping(expressionImpl.getCurrentNode());
                        }
                        ((ReportQuery)query).addAttribute(this.selection.getAlias(), ((FunctionExpressionImpl)this.selection).getCurrentNode(), this.selection.getJavaType());
                    } else {
                        ((ReportQuery)query).addItem(this.selection.getAlias(), this.selection.getCurrentNode());
                        ((ReportQuery)query).setShouldReturnSingleAttribute(true);
                    }
                }
            }
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY)) {
            if (this.selection != null && !this.selection.isRoot()) {
                query = new ReportQuery();
                query.setReferenceClass(this.queryType);
                ((ReportQuery)query).addItem(this.selection.getAlias(), this.selection.getCurrentNode(), ((FromImpl)this.selection).findJoinFetches());
                ((ReportQuery)query).setShouldReturnSingleAttribute(true);
            } else {
                query = new ReadAllQuery(this.queryType);
                if (this.roots != null && !this.roots.isEmpty()) {
                    List<Expression> list2 = ((FromImpl)this.roots.iterator().next()).findJoinFetches();
                    if (!list2.isEmpty()) {
                        query.setShouldFilterDuplicates(false);
                        query.setExpressionBuilder(list2.get(0).getBuilder());
                    }
                    for (Expression fetch : list2) {
                        query.addJoinedAttribute(fetch);
                    }
                }
                if (this.selection != null) {
                    query.setExpressionBuilder(this.selection.currentNode.getBuilder());
                }
            }
        } else {
            ReportQuery reportQuery = null;
            if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE)) {
                list = new ArrayList();
                list.add(this.selection);
                reportQuery = new TupleQuery(list);
            } else {
                reportQuery = new ReportQuery();
                reportQuery.setShouldReturnWithoutReportQueryResult(true);
            }
            if (this.selection != null) {
                if (!this.selection.isCompoundSelection() && ((InternalExpression)((Object)this.selection)).isCompoundExpression()) {
                    if (((FunctionExpressionImpl)this.selection).getOperation() == "size") {
                        collectionExpression = (PathImpl)((FunctionExpressionImpl)this.selection).getChildExpressions().get(0);
                        ExpressionImpl expressionImpl = (ExpressionImpl)collectionExpression.getParentPath();
                        reportQuery.addAttribute(this.selection.getAlias(), collectionExpression.getCurrentNode().count(), ClassConstants.INTEGER);
                        reportQuery.addGrouping(expressionImpl.getCurrentNode());
                    } else {
                        reportQuery.addAttribute(this.selection.getAlias(), ((FunctionExpressionImpl)this.selection).getCurrentNode(), this.selection.getJavaType());
                    }
                } else if (this.selection.isFrom()) {
                    reportQuery.addItem(this.selection.getAlias(), this.selection.getCurrentNode(), ((FromImpl)this.selection).findJoinFetches());
                } else {
                    reportQuery.addAttribute(this.selection.getAlias(), this.selection.getCurrentNode(), this.selection.getJavaType());
                }
                reportQuery.setReferenceClass(this.selection.getCurrentNode().getBuilder().getQueryClass());
                reportQuery.setExpressionBuilder(this.selection.getCurrentNode().getBuilder());
            }
            query = reportQuery;
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                for (javax.persistence.criteria.Expression exp : this.groupBy) {
                    reportQuery.addGrouping(((InternalSelection)exp).getCurrentNode());
                }
            }
            if (this.havingClause != null) {
                reportQuery.setHavingExpression(((InternalSelection)this.havingClause).getCurrentNode());
            }
        }
        if (query.getReferenceClass() == null) {
            if (this.where != null && ((InternalSelection)this.where).getCurrentNode() != null && ((InternalSelection)this.where).getCurrentNode().getBuilder() != null && ((InternalSelection)this.where).getCurrentNode().getBuilder().getQueryClass() != null) {
                query.setReferenceClass(((InternalSelection)this.where).getCurrentNode().getBuilder().getQueryClass());
            } else if (this.roots != null && !this.roots.isEmpty()) {
                Root<?> root = this.getRoots().iterator().next();
                query.setReferenceClass(root.getJavaType());
            }
        }
        if (this.selection == null && this.roots != null && !this.roots.isEmpty()) {
            for (Root<?> root : this.getRoots()) {
                if (!root.getJavaType().equals(this.queryType)) continue;
                query.setExpressionBuilder(((RootImpl)root).getCurrentNode().getBuilder());
                break;
            }
        }
        return query;
    }

    public DatabaseQuery translate() {
        Iterator<Root<?>> iterator = this.getRoots().iterator();
        while (iterator.hasNext()) {
            this.findJoins((FromImpl)iterator.next());
        }
        ObjectLevelReadQuery query = null;
        query = this.selection == null || !this.selection.isCompoundSelection() ? this.createSimpleQuery() : this.createCompoundQuery();
        for (ParameterExpression<?> parameter : this.getParameters()) {
            query.addArgument(parameter.getName(), parameter.getJavaType());
        }
        if (this.where != null) {
            if (((InternalExpression)this.where).isPredicate() && ((InternalSelection)this.where).getCurrentNode() == null) {
                if (((PredicateImpl)this.where).getOperator() == Predicate.BooleanOperator.OR) {
                    query.setSelectionCriteria(new ConstantExpression((Object)1, (Expression)query.getExpressionBuilder()).equal(0));
                }
            } else {
                query.setSelectionCriteria(((InternalSelection)this.where).getCurrentNode());
            }
        }
        if (this.joins != null && !this.joins.isEmpty()) {
            query.setShouldFilterDuplicates(false);
            for (FromImpl join : this.joins) {
                query.addNonFetchJoinedAttribute(join.getCurrentNode());
            }
        }
        if (this.distinct) {
            query.setDistinctState((short)1);
            query.setShouldFilterDuplicates(true);
        } else {
            query.setDistinctState((short)2);
        }
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            for (Order order : this.orderBy) {
                OrderImpl orderImpl = (OrderImpl)order;
                Expression orderExp = ((ExpressionImpl)orderImpl.getExpression()).getCurrentNode();
                orderExp = orderImpl.isAscending() ? orderExp.ascending() : orderExp.descending();
                query.addOrdering(orderExp);
            }
        }
        return query;
    }
}

