/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.hook;

import java.util.Collection;
import org.eclipse.equinox.internal.region.hook.RegionDigraphVisitorBase;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.bundle.FindHook;

public final class RegionBundleFindHook
implements FindHook {
    private final RegionDigraph regionDigraph;
    private final long hookImplID;

    public RegionBundleFindHook(RegionDigraph regionDigraph, long hookImplID) {
        this.regionDigraph = regionDigraph;
        this.hookImplID = hookImplID;
    }

    public void find(BundleContext context, Collection<Bundle> bundles) {
        Bundle finderBundle = RegionBundleFindHook.getBundle(context);
        if (finderBundle == null) {
            bundles.clear();
            return;
        }
        long bundleID = finderBundle.getBundleId();
        if (bundleID == 0L || bundleID == this.hookImplID) {
            return;
        }
        Region finderRegion = this.regionDigraph.getRegion(finderBundle);
        if (finderRegion == null) {
            bundles.clear();
            return;
        }
        Visitor visitor = new Visitor(bundles);
        finderRegion.visitSubgraph(visitor);
        Collection allowed = visitor.getAllowed();
        bundles.retainAll(allowed);
    }

    static Bundle getBundle(BundleContext context) {
        try {
            return context.getBundle();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    class Visitor
    extends RegionDigraphVisitorBase<Bundle> {
        Visitor(Collection<Bundle> candidates) {
            super(candidates);
        }

        @Override
        protected boolean contains(Region region, Bundle candidate) {
            return region.contains(candidate);
        }

        @Override
        protected boolean isAllowed(Bundle candidate, RegionFilter filter) {
            return filter.isAllowed(candidate);
        }
    }
}

