/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.groups.Groups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsComputer {
    private static final Groups DEFAULT_GROUPS = new GroupsComputer().computeGroups(Arrays.asList(GroupsComputer.getDefaultGroupArray()));
    private final Map<Class<?>, List<Group>> resolvedSequences = Collections.synchronizedMap(new HashMap());

    public static Class<?>[] getDefaultGroupArray() {
        return new Class[]{Default.class};
    }

    public Groups computeGroups(Class<?>[] groups) {
        if (groups == null) {
            throw new IllegalArgumentException("null passed as group");
        }
        if (groups.length == 0) {
            return DEFAULT_GROUPS;
        }
        return this.computeGroups(Arrays.asList(groups));
    }

    protected Groups computeGroups(Collection<Class<?>> groups) {
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException("At least one group has to be specified.");
        }
        for (Class<?> clazz : groups) {
            if (clazz.isInterface()) continue;
            throw new ValidationException("A group has to be an interface. " + clazz.getName() + " is not.");
        }
        Groups chain = new Groups();
        for (Class<?> clazz : groups) {
            GroupSequence anno = clazz.getAnnotation(GroupSequence.class);
            if (anno == null) {
                Group group = new Group(clazz);
                chain.insertGroup(group);
                this.insertInheritedGroups(clazz, chain);
                continue;
            }
            this.insertSequence(clazz, anno, chain);
        }
        return chain;
    }

    private void insertInheritedGroups(Class<?> clazz, Groups chain) {
        for (Class<?> extendedInterface : clazz.getInterfaces()) {
            Group group = new Group(extendedInterface);
            chain.insertGroup(group);
            this.insertInheritedGroups(extendedInterface, chain);
        }
    }

    private void insertSequence(Class<?> clazz, GroupSequence anno, Groups chain) {
        List<Group> sequence = this.resolvedSequences.containsKey(clazz) ? this.resolvedSequences.get(clazz) : this.resolveSequence(clazz, anno, new HashSet());
        chain.insertSequence(sequence);
    }

    private List<Group> resolveSequence(Class<?> group, GroupSequence sequenceAnnotation, Set<Class<?>> processedSequences) {
        Class[] sequenceArray;
        if (processedSequences.contains(group)) {
            throw new GroupDefinitionException("Cyclic dependency in groups definition");
        }
        processedSequences.add(group);
        LinkedList<Group> resolvedGroupSequence = new LinkedList<Group>();
        for (Class clazz : sequenceArray = sequenceAnnotation.value()) {
            GroupSequence anno = clazz.getAnnotation(GroupSequence.class);
            if (anno == null) {
                resolvedGroupSequence.add(new Group(clazz));
                continue;
            }
            List<Group> tmpSequence = this.resolveSequence(clazz, anno, processedSequences);
            resolvedGroupSequence.addAll(tmpSequence);
        }
        this.resolvedSequences.put(group, resolvedGroupSequence);
        return resolvedGroupSequence;
    }
}

