/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.management.internal;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.BundleArtifact;
import org.eclipse.virgo.kernel.model.CompositeArtifact;
import org.eclipse.virgo.kernel.model.internal.ArtifactRepositoryListener;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.model.management.internal.DelegatingManageableArtifact;
import org.eclipse.virgo.kernel.model.management.internal.DelegatingManageableBundleArtifact;
import org.eclipse.virgo.kernel.model.management.internal.DelegatingManageableCompositeArtifact;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxArtifactRepositoryListener
implements ArtifactRepositoryListener {
    private static final String USER_REGION_NAME = "org.eclipse.virgo.region.user";
    private static final String GLOBAL_REGION_NAME = "global";
    private final Logger logger;
    private final MBeanServer server;
    private final RuntimeArtifactModelObjectNameCreator artifactObjectNameCreator;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public JmxArtifactRepositoryListener(@NonNull RuntimeArtifactModelObjectNameCreator artifactObjectNameCreator) {
        RuntimeArtifactModelObjectNameCreator runtimeArtifactModelObjectNameCreator = artifactObjectNameCreator;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)runtimeArtifactModelObjectNameCreator);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.server = ManagementFactory.getPlatformMBeanServer();
            this.artifactObjectNameCreator = artifactObjectNameCreator;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void added(Artifact artifact) {
        try {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                String regionName = artifact.getRegion().getName();
                if (USER_REGION_NAME.equals(regionName) || GLOBAL_REGION_NAME.equals(regionName)) {
                    this.publish(artifact, false);
                }
                this.publish(artifact, true);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Override
    public void removed(Artifact artifact) {
        try {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            try {
                String regionName = artifact.getRegion().getName();
                if (USER_REGION_NAME.equals(regionName) || GLOBAL_REGION_NAME.equals(regionName)) {
                    this.retract(artifact, false);
                }
                this.retract(artifact, true);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public void destroy() {
        try {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            try {
                Set<ObjectName> objectNames = this.server.queryNames(this.artifactObjectNameCreator.createAllArtifactsQuery(), null);
                for (ObjectName objectName : objectNames) {
                    try {
                        this.server.unregisterMBean(objectName);
                    }
                    catch (MBeanRegistrationException mBeanRegistrationException) {
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {}
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void publish(Artifact artifact, boolean newModel) {
        try {
            block10: {
                JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                try {
                    ObjectName objectName = this.getModelObjectName(artifact, newModel);
                    try {
                        if (artifact instanceof CompositeArtifact) {
                            this.server.registerMBean(new DelegatingManageableCompositeArtifact(this.artifactObjectNameCreator, (CompositeArtifact)artifact, newModel), objectName);
                            break block10;
                        }
                        if (artifact instanceof BundleArtifact) {
                            this.server.registerMBean(new DelegatingManageableBundleArtifact(this.artifactObjectNameCreator, (BundleArtifact)artifact, newModel), objectName);
                            break block10;
                        }
                        this.server.registerMBean(new DelegatingManageableArtifact(this.artifactObjectNameCreator, artifact, newModel), objectName);
                    }
                    catch (InstanceAlreadyExistsException e) {
                        this.logger.error(String.format("Unable to register '%s'", objectName.toString()), (Throwable)e);
                    }
                    catch (MBeanRegistrationException e) {
                        this.logger.error(String.format("Unable to register '%s'", objectName.toString()), (Throwable)e);
                    }
                    catch (NotCompliantMBeanException e) {
                        this.logger.error(String.format("Unable to register '%s'", objectName.toString()), (Throwable)e);
                    }
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
            }
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void retract(Artifact artifact, boolean newModel) {
        try {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                ObjectName objectName = this.getModelObjectName(artifact, newModel);
                try {
                    this.server.unregisterMBean(objectName);
                }
                catch (MBeanRegistrationException e) {
                    this.logger.error(String.format("Unable to unregister '%s'", objectName.toString()), (Throwable)e);
                }
                catch (InstanceNotFoundException e) {
                    this.logger.error(String.format("Unable to unregister '%s'", objectName.toString()), (Throwable)e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            JmxArtifactRepositoryListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private ObjectName getModelObjectName(Artifact artifact, boolean newModel) {
        try {
            ObjectName objectName = newModel ? this.artifactObjectNameCreator.createArtifactModel(artifact) : this.artifactObjectNameCreator.createModel(artifact);
            return objectName;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("JmxArtifactRepositoryListener.java", Class.forName("org.eclipse.virgo.kernel.model.management.internal.JmxArtifactRepositoryListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "added", "org.eclipse.virgo.kernel.model.management.internal.JmxArtifactRepositoryListener", "org.eclipse.virgo.kernel.model.Artifact:", "artifact:", "", "void"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removed", "org.eclipse.virgo.kernel.model.management.internal.JmxArtifactRepositoryListener", "org.eclipse.virgo.kernel.model.Artifact:", "artifact:", "", "void"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.eclipse.virgo.kernel.model.management.internal.JmxArtifactRepositoryListener", "", "", "", "void"), 83);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "publish", "org.eclipse.virgo.kernel.model.management.internal.JmxArtifactRepositoryListener", "org.eclipse.virgo.kernel.model.Artifact:boolean:", "artifact:newModel:", "", "void"), 96);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retract", "org.eclipse.virgo.kernel.model.management.internal.JmxArtifactRepositoryListener", "org.eclipse.virgo.kernel.model.Artifact:boolean:", "artifact:newModel:", "", "void"), 117);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.management.internal.JmxArtifactRepositoryListener");
    }
}

