/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.dependency.internal;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.osgi.service.dependency.internal.DefaultMandatoryDependencyManager;
import org.springframework.osgi.service.dependency.internal.MandatoryServiceDependencyManager;
import org.springframework.osgi.service.exporter.support.OsgiServiceFactoryBean;
import org.springframework.osgi.service.exporter.support.internal.controller.ExporterControllerUtils;
import org.springframework.osgi.service.exporter.support.internal.controller.ExporterInternalActions;

public class MandatoryDependencyBeanPostProcessor
implements BeanFactoryAware,
BeanPostProcessor,
DestructionAwareBeanPostProcessor {
    private MandatoryServiceDependencyManager manager;
    private ConfigurableBeanFactory beanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof OsgiServiceFactoryBean) {
            this.manager.addServiceExporter(bean, beanName);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof OsgiServiceFactoryBean && this.beanFactory.containsBean(beanName)) {
            String exporterName = beanName;
            if (this.beanFactory.isFactoryBean(beanName)) {
                exporterName = "&" + beanName;
            }
            if (this.beanFactory.isSingleton(exporterName)) {
                ExporterInternalActions controller = ExporterControllerUtils.getControllerFor(bean);
                controller.registerServiceAtStartup(false);
            }
        }
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        DefaultMandatoryDependencyManager manager = new DefaultMandatoryDependencyManager();
        manager.setBeanFactory(beanFactory);
        this.manager = manager;
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (bean instanceof OsgiServiceFactoryBean) {
            this.manager.removeServiceExporter(bean, beanName);
        }
    }
}

