/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.launcher;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.virgo.osgi.launcher.FrameworkFactoryLocator;
import org.eclipse.virgo.osgi.launcher.PropertyPlaceholderResolver;
import org.eclipse.virgo.osgi.launcher.parser.ArgumentParser;
import org.eclipse.virgo.osgi.launcher.parser.BundleEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class FrameworkBuilder {
    private static final String PROP_LAUNCHER_BUNDLES = "launcher.bundles";
    private final ArgumentParser parser = new ArgumentParser();
    private final List<BundleEntry> bundleEntries = new ArrayList<BundleEntry>();
    private final FrameworkCustomizer customizer;
    private final Properties configuration;

    public FrameworkBuilder(Properties frameworkProperties) {
        this(frameworkProperties, new NoOpFrameworkCustomizer());
    }

    public FrameworkBuilder(Properties frameworkProperties, FrameworkCustomizer customizer) {
        this.customizer = customizer;
        this.configuration = frameworkProperties == null ? new Properties() : frameworkProperties;
        this.parseLauncherBundlesProperty(this.configuration);
    }

    public final FrameworkBuilder addBundle(URI uri) {
        return this.addBundle(uri, false);
    }

    public final FrameworkBuilder addBundle(File file) {
        return this.addBundle(file.toURI(), false);
    }

    public final FrameworkBuilder addBundle(URI uri, boolean autoStart) {
        BundleEntry entry = new BundleEntry(uri, autoStart);
        this.bundleEntries.add(entry);
        return this;
    }

    public final FrameworkBuilder addBundle(File file, boolean autoStart) {
        return this.addBundle(file.toURI(), autoStart);
    }

    public final FrameworkBuilder addBundle(String declaration) {
        BundleEntry entry = this.parser.parseBundleEntry(declaration);
        return this.addBundle(entry.getURI(), entry.isAutoStart());
    }

    public final FrameworkBuilder addFrameworkProperty(String key, String value) {
        this.configuration.put(key, value);
        return this;
    }

    public final Framework start() throws BundleException {
        FrameworkFactory frameworkFactory = FrameworkFactoryLocator.createFrameworkFactory();
        Properties resolvedConfiguration = new PropertyPlaceholderResolver().resolve(this.configuration);
        Map<String, String> resolvedConfigurationMap = this.convertPropertiesToMap(resolvedConfiguration);
        Framework fwk = frameworkFactory.newFramework(resolvedConfigurationMap);
        fwk.start();
        this.customizer.beforeInstallBundles(fwk);
        this.installAndStartBundles(fwk.getBundleContext());
        this.customizer.afterInstallBundles(fwk);
        return fwk;
    }

    private Map<String, String> convertPropertiesToMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> stringPropertyNames = props.stringPropertyNames();
        for (String propName : stringPropertyNames) {
            map.put(propName, props.getProperty(propName));
        }
        return map;
    }

    private void installAndStartBundles(BundleContext bundleContext) throws BundleException {
        ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
        for (BundleEntry entry : this.bundleEntries) {
            Bundle bundle = bundleContext.installBundle(entry.getURI().toString());
            if (!entry.isAutoStart()) continue;
            bundlesToStart.add(bundle);
        }
        for (Bundle bundle : bundlesToStart) {
            try {
                bundle.start();
            }
            catch (BundleException be) {
                throw new BundleException("Bundle " + bundle.getSymbolicName() + " " + bundle.getVersion() + " failed to start.", (Throwable)be);
            }
        }
    }

    private void parseLauncherBundlesProperty(Properties configuration) {
        String launcherBundlesProp = configuration.getProperty(PROP_LAUNCHER_BUNDLES);
        if (launcherBundlesProp != null) {
            BundleEntry[] entries = this.parser.parseBundleEntries(launcherBundlesProp);
            Collections.addAll(this.bundleEntries, entries);
        }
    }

    public static interface FrameworkCustomizer {
        public void beforeInstallBundles(Framework var1);

        public void afterInstallBundles(Framework var1);
    }

    private static class NoOpFrameworkCustomizer
    implements FrameworkCustomizer {
        private NoOpFrameworkCustomizer() {
        }

        @Override
        public void afterInstallBundles(Framework framework) {
        }

        @Override
        public void beforeInstallBundles(Framework framework) {
        }
    }
}

