/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactDescriptorPersister;
import org.eclipse.virgo.repository.IndexFormatException;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.codec.RepositoryCodec;
import org.eclipse.virgo.repository.internal.DelegatingRepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.IdentityUriMapper;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.io.PathReference;

public final class XmlArtifactDescriptorPersister
implements ArtifactDescriptorPersister {
    private final RepositoryCodec codec;
    private final String repositoryName;
    private final File persistenceFile;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public XmlArtifactDescriptorPersister(RepositoryCodec codec, String repositoryName, File persistenceFile) {
        this.codec = codec;
        this.repositoryName = repositoryName;
        this.persistenceFile = persistenceFile;
    }

    @Override
    public void persistArtifactDescriptors(Set<RepositoryAwareArtifactDescriptor> artifacts) throws IOException {
        FileOutputStream stream = null;
        try {
            if (!this.persistenceFile.exists()) {
                this.createPersistenceFile();
            }
            stream = new FileOutputStream(this.persistenceFile);
            this.codec.write(new HashSet<RepositoryAwareArtifactDescriptor>(artifacts), stream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)stream);
    }

    private void createPersistenceFile() {
        PathReference pr = new PathReference(this.persistenceFile);
        pr.getParent().createDirectory();
        pr.createFile();
    }

    @Override
    public Set<RepositoryAwareArtifactDescriptor> loadArtifacts() throws IndexFormatException {
        HashSet<RepositoryAwareArtifactDescriptor> hashSet;
        if (!this.persistenceFile.exists()) {
            return new HashSet<RepositoryAwareArtifactDescriptor>();
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.persistenceFile);
            IdentityUriMapper mapper = new IdentityUriMapper();
            HashSet<RepositoryAwareArtifactDescriptor> artifacts = new HashSet<RepositoryAwareArtifactDescriptor>();
            for (ArtifactDescriptor descriptor : this.codec.read(stream)) {
                artifacts.add(new DelegatingRepositoryAwareArtifactDescriptor(descriptor, this.repositoryName, mapper));
            }
            hashSet = artifacts;
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)stream);
        return hashSet;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.XmlArtifactDescriptorPersister");
    }
}

