/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.equinox.internal.util.pool.ObjectCreator;
import org.eclipse.equinox.internal.util.pool.ObjectPool;

public final class SCRUtil
implements ObjectCreator {
    private static ObjectPool objectArrayPool;
    private static Method setAccessibleMethod;
    private static Object[] args;
    private static boolean failed;

    static {
        SCRUtil u = new SCRUtil();
        objectArrayPool = new ObjectPool((ObjectCreator)u, 10, 2);
        setAccessibleMethod = null;
        args = null;
        failed = false;
    }

    private SCRUtil() {
    }

    public static Object[] getObjectArray() {
        return (Object[])objectArrayPool.getObject();
    }

    public static void release(Object[] objectArray) {
        int j = 0;
        while (j < objectArray.length) {
            objectArray[j] = null;
            ++j;
        }
        objectArrayPool.releaseObject((Object)objectArray);
    }

    public Object getInstance() throws Exception {
        return new Object[1];
    }

    public static void copyTo(Dictionary dst, Dictionary src) {
        if (src == null || dst == null) {
            return;
        }
        Enumeration e = src.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            dst.put(key, src.get(key));
        }
    }

    public static boolean checkMethodAccess(Class implClass, Class currentClass, Method methodToCheck, boolean isComponent11) {
        int modifiers = methodToCheck.getModifiers();
        boolean result = true;
        if (isComponent11) {
            if (currentClass != implClass) {
                if (Modifier.isPrivate(modifiers)) {
                    result = false;
                } else if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && currentClass.getPackage() != implClass.getPackage()) {
                    result = false;
                }
            }
        } else {
            result = Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
        }
        return result;
    }

    public static final void setAccessible(Method method) {
        try {
            if (setAccessibleMethod == null && !failed) {
                setAccessibleMethod = Class.forName("java.lang.reflect.AccessibleObject").getMethod("setAccessible", Boolean.TYPE);
                args = new Object[]{Boolean.TRUE};
            }
            if (setAccessibleMethod != null) {
                setAccessibleMethod.invoke((Object)method, args);
            }
        }
        catch (Exception exception) {
            failed = true;
        }
    }

    public static String getStringRepresentation(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return (String)value;
        }
        StringBuffer res = new StringBuffer(200);
        if (value instanceof String[]) {
            res.append("String[");
            String[] arr = (String[])value;
            int i = 0;
            while (i < arr.length) {
                res.append(arr[i]);
                if (i != arr.length - 1) {
                    res.append(",");
                }
                ++i;
            }
            res.append("]");
        } else if (value instanceof int[]) {
            res.append("int[");
            int[] arr = (int[])value;
            int i = 0;
            while (i < arr.length) {
                res.append(String.valueOf(arr[i]));
                if (i != arr.length - 1) {
                    res.append(",");
                }
                ++i;
            }
            res.append("]");
        } else if (value instanceof long[]) {
            res.append("long[");
            long[] arr = (long[])value;
            int i = 0;
            while (i < arr.length) {
                res.append(String.valueOf(arr[i]));
                if (i != arr.length - 1) {
                    res.append(",");
                }
                ++i;
            }
            res.append("]");
        } else if (value instanceof char[]) {
            res.append("char[");
            char[] arr = (char[])value;
            int i = 0;
            while (i < arr.length) {
                res.append(String.valueOf(arr[i]));
                if (i != arr.length - 1) {
                    res.append(",");
                }
                ++i;
            }
            res.append("]");
        } else if (value instanceof boolean[]) {
            res.append("boolean[");
            boolean[] arr = (boolean[])value;
            int i = 0;
            while (i < arr.length) {
                res.append(String.valueOf(arr[i]));
                if (i != arr.length - 1) {
                    res.append(",");
                }
                ++i;
            }
            res.append("]");
        } else if (value instanceof double[]) {
            res.append("double[");
            double[] arr = (double[])value;
            int i = 0;
            while (i < arr.length) {
                res.append(String.valueOf(arr[i]));
                if (i != arr.length - 1) {
                    res.append(",");
                }
                ++i;
            }
            res.append("]");
        } else if (value instanceof float[]) {
            res.append("float[");
            float[] arr = (float[])value;
            int i = 0;
            while (i < arr.length) {
                res.append(String.valueOf(arr[i]));
                if (i != arr.length - 1) {
                    res.append(",");
                }
                ++i;
            }
            res.append("]");
        } else if (value instanceof Object[]) {
            res.append("Object[");
            Object[] arr = (Object[])value;
            int i = 0;
            while (i < arr.length) {
                res.append(SCRUtil.getStringRepresentation(arr[i]));
                if (i != arr.length - 1) {
                    res.append(",");
                }
                ++i;
            }
            res.append("]");
        } else {
            return value.toString();
        }
        return res.toString();
    }

    public static String getStateStringRepresentation(int state) {
        String result = "Unknown";
        switch (state) {
            case 8: {
                result = "Activating";
                break;
            }
            case 16: {
                result = "Active";
                break;
            }
            case 128: {
                result = "Deactivating";
                break;
            }
            case 1: {
                result = "Disabled";
                break;
            }
            case 256: {
                result = "Disposed";
                break;
            }
            case 2048: {
                result = "Disposing";
                break;
            }
            case 512: {
                result = "Enabling";
                break;
            }
            case 64: {
                result = "Factory";
                break;
            }
            case 32: {
                result = "Registered";
                break;
            }
            case 4: {
                result = "Unsatisfied";
            }
        }
        return result;
    }
}

