/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.importexpansion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.kernel.artifact.bundle.BundleBridge;
import org.eclipse.virgo.kernel.osgi.framework.ImportExpander;
import org.eclipse.virgo.kernel.osgi.framework.ImportMergeException;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException;
import org.eclipse.virgo.kernel.serviceability.Assert;
import org.eclipse.virgo.kernel.userregion.internal.UserRegionLogEvents;
import org.eclipse.virgo.kernel.userregion.internal.importexpansion.BundleManifestProcessor;
import org.eclipse.virgo.kernel.userregion.internal.importexpansion.StandardImportPromotionVector;
import org.eclipse.virgo.kernel.userregion.internal.importexpansion.StandardTrackedPackageImportsFactory;
import org.eclipse.virgo.kernel.userregion.internal.importexpansion.TrackedPackageImports;
import org.eclipse.virgo.kernel.userregion.internal.importexpansion.TrackedPackageImportsFactory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.util.math.OrderedPair;
import org.eclipse.virgo.util.osgi.VersionRange;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.ImportedBundle;
import org.eclipse.virgo.util.osgi.manifest.ImportedLibrary;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.Resolution;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImportExpansionHandler
implements ImportExpander {
    private static final String IMPORT_SCOPE_APPLICATION = "application";
    private static final String IMPORT_SCOPE_DIRECTIVE = "import-scope";
    private static final String MISSING_BUNDLE_SYMBOLIC_NAME = "<bundle symbolic name not present>";
    private static final String INSTRUMENTED_SUFFIX = ".instrumented";
    private static final String SYNTHETIC_CONTEXT_SUFFIX = "-synthetic.context";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Repository repository;
    private final TrackedPackageImportsFactory trackedPackageImportsFactory = new StandardTrackedPackageImportsFactory();
    private final BundleContext bundleContext;
    private final Set<String> packagesExportedBySystemBundle;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public ImportExpansionHandler(Repository repository, Set<String> packagesExportedBySystemBundle, EventLogger eventLogger) {
        this(repository, null, packagesExportedBySystemBundle, eventLogger);
    }

    public ImportExpansionHandler(Repository repository, BundleContext bundleContext, Set<String> packagesExportedBySystemBundle, EventLogger eventLogger) {
        this.repository = repository;
        this.bundleContext = bundleContext;
        this.packagesExportedBySystemBundle = packagesExportedBySystemBundle;
        this.eventLogger = eventLogger;
    }

    public ImportExpander.ImportPromotionVector expandImports(List<BundleManifest> bundleManifests) throws UnableToSatisfyDependenciesException, ImportMergeException {
        StandardImportPromotionVector importPromotionVector = new StandardImportPromotionVector(this.trackedPackageImportsFactory);
        TrackedPackageImports packageImportsToBePromoted = this.trackedPackageImportsFactory.createCollector();
        for (BundleManifest bundleManifest : bundleManifests) {
            TrackedPackageImports bundlePackageImportsToBePromoted = this.trackedPackageImportsFactory.createCollector();
            this.detectPromotedPackageImports(bundleManifest, bundlePackageImportsToBePromoted);
            this.expandImportsIfNecessary(bundleManifest, bundlePackageImportsToBePromoted, bundleManifests);
            if (bundlePackageImportsToBePromoted.isEmpty()) continue;
            packageImportsToBePromoted.merge(bundlePackageImportsToBePromoted);
            BundleSymbolicName bundleSymbolicNameHeader = bundleManifest.getBundleSymbolicName();
            Assert.notNull((Object)bundleSymbolicNameHeader, (String)"Bundle-SymbolicName must be present for import promotion tracking", (Object[])new Object[0]);
            importPromotionVector.put(bundleSymbolicNameHeader.getSymbolicName(), bundlePackageImportsToBePromoted);
        }
        this.mergePromotedImports(packageImportsToBePromoted, bundleManifests);
        return importPromotionVector;
    }

    private void detectPromotedPackageImports(BundleManifest bundleManifest, TrackedPackageImports bundlePackageImportsToBePromoted) {
        List importedPackages = bundleManifest.getImportPackage().getImportedPackages();
        ArrayList<ImportedPackage> importedPackagesToPromote = new ArrayList<ImportedPackage>();
        for (ImportedPackage importedPackage : importedPackages) {
            if (!IMPORT_SCOPE_APPLICATION.equals(importedPackage.getDirectives().get(IMPORT_SCOPE_DIRECTIVE))) continue;
            importedPackagesToPromote.add(importedPackage);
        }
        TrackedPackageImports trackedPackageImportsToPromote = this.trackedPackageImportsFactory.create(importedPackagesToPromote, "Import-Package in '" + bundleManifest.getBundleSymbolicName().getSymbolicName() + "' version '" + bundleManifest.getBundleVersion() + "'");
        bundlePackageImportsToBePromoted.merge(trackedPackageImportsToPromote);
    }

    private void mergePromotedImports(TrackedPackageImports importsToBemerged, List<BundleManifest> bundleManifests) throws ImportMergeException {
        for (BundleManifest bundleManifest : bundleManifests) {
            this.mergePromotedImports(importsToBemerged, bundleManifest);
        }
    }

    private void mergePromotedImports(TrackedPackageImports importsToBemerged, BundleManifest bundleManifest) throws ImportMergeException {
        BundleSymbolicName bundleSymbolicNameHeader = bundleManifest.getBundleSymbolicName();
        if (bundleSymbolicNameHeader.getSymbolicName() == null || !bundleSymbolicNameHeader.getSymbolicName().endsWith(SYNTHETIC_CONTEXT_SUFFIX)) {
            this.mergeImports(importsToBemerged, bundleManifest);
        }
    }

    private void mergeImports(TrackedPackageImports importsToBemerged, BundleManifest bundleManifest) throws ImportMergeException {
        TrackedPackageImports bundleTrackedPackageImports = this.trackedPackageImportsFactory.create(bundleManifest);
        bundleTrackedPackageImports.merge(importsToBemerged);
        this.setMergedImports(bundleManifest, bundleTrackedPackageImports);
    }

    private boolean expandImportsIfNecessary(BundleManifest manifest, TrackedPackageImports packageImportsToBePromoted, List<BundleManifest> bundleManifests) throws UnableToSatisfyDependenciesException {
        boolean expanded = false;
        List directlyImportedBundles = manifest.getImportBundle().getImportedBundles();
        List importedLibraries = manifest.getImportLibrary().getImportedLibraries();
        if (directlyImportedBundles.size() > 0 || importedLibraries.size() > 0) {
            this.logger.info("Import-Library and/or Import-Bundle header found. Original manifest: \n{}", (Object)manifest);
            this.expandImports(importedLibraries, directlyImportedBundles, manifest, packageImportsToBePromoted, bundleManifests);
            this.logger.info("Updated manifest: \n{}", (Object)manifest);
            expanded = true;
        }
        return expanded;
    }

    UnableToSatisfyBundleDependenciesException createExceptionForMissingLibrary(String name, VersionRange versionRange, BundleManifest bundleManifest) {
        String description = String.format("A library with the name '%s' and a version within the range '%s' could not be found", name, versionRange);
        BundleSymbolicName bundleSymbolicName = bundleManifest.getBundleSymbolicName();
        return new UnableToSatisfyBundleDependenciesException(bundleSymbolicName != null ? bundleSymbolicName.getSymbolicName() : MISSING_BUNDLE_SYMBOLIC_NAME, bundleManifest.getBundleVersion(), description);
    }

    void expandImports(List<ImportedLibrary> libraryImports, List<ImportedBundle> directlyImportedBundles, BundleManifest bundleManifest) throws UnableToSatisfyDependenciesException {
        this.expandImports(libraryImports, directlyImportedBundles, bundleManifest, this.trackedPackageImportsFactory.createCollector(), Collections.EMPTY_LIST);
    }

    void expandImports(List<ImportedLibrary> libraryImports, List<ImportedBundle> directlyImportedBundles, BundleManifest bundleManifest, List<BundleManifest> bundleManifests) throws UnableToSatisfyDependenciesException {
        this.expandImports(libraryImports, directlyImportedBundles, bundleManifest, this.trackedPackageImportsFactory.createCollector(), bundleManifests);
    }

    private void expandImports(List<ImportedLibrary> libraryImports, List<ImportedBundle> directlyImportedBundles, BundleManifest bundleManifest, TrackedPackageImports packageImportsToBePromoted, List<BundleManifest> bundleManifests) throws UnableToSatisfyDependenciesException {
        Assert.notNull(libraryImports, (String)"Library imports must be non-null", (Object[])new Object[0]);
        Assert.notNull(directlyImportedBundles, (String)"Direct bundle imports must be non-null", (Object[])new Object[0]);
        this.mergeImports(this.getAdditionalPackageImports(libraryImports, directlyImportedBundles, bundleManifest, packageImportsToBePromoted, bundleManifests), bundleManifest);
        bundleManifest.getImportBundle().getImportedBundles().clear();
        bundleManifest.getImportLibrary().getImportedLibraries().clear();
    }

    private TrackedPackageImports getAdditionalPackageImports(List<ImportedLibrary> importedLibraries, List<ImportedBundle> directlyImportedBundles, BundleManifest bundleManifest, TrackedPackageImports packageImportsToBePromoted, List<BundleManifest> additionalManifests) throws UnableToSatisfyDependenciesException, UnableToSatisfyBundleDependenciesException {
        TrackedPackageImports additionalPackageImports = this.trackedPackageImportsFactory.createCollector();
        TrackedPackageImports libraryPackageImports = this.getLibraryPackageImports(importedLibraries, packageImportsToBePromoted, bundleManifest, additionalManifests);
        additionalPackageImports.merge(libraryPackageImports);
        for (ImportedBundle directlyImportedBundle : directlyImportedBundles) {
            additionalPackageImports.merge(this.getBundlePackageImports(directlyImportedBundle, packageImportsToBePromoted, bundleManifest, additionalManifests));
        }
        return additionalPackageImports;
    }

    private TrackedPackageImports getBundlePackageImports(ImportedBundle importedBundle, TrackedPackageImports packageImportsToBePromoted, BundleManifest importingBundle, List<BundleManifest> additionalManifests) throws UnableToSatisfyBundleDependenciesException {
        String bundleSymbolicName = importedBundle.getBundleSymbolicName();
        VersionRange importVersionRange = importedBundle.getVersion();
        boolean mandatory = importedBundle.getResolution().equals((Object)Resolution.MANDATORY);
        if (bundleSymbolicName.equals(importingBundle.getBundleSymbolicName().getSymbolicName()) && importVersionRange.includes(importingBundle.getBundleVersion())) {
            throw new UnableToSatisfyBundleDependenciesException(importingBundle.getBundleSymbolicName().getSymbolicName(), importingBundle.getBundleVersion(), "Import-Bundle must not import the importing bundle");
        }
        OrderedPair<BundleManifest, Boolean> bundleManifestHolder = this.findBundle(bundleSymbolicName, importVersionRange, additionalManifests);
        if (bundleManifestHolder != null && bundleManifestHolder.getFirst() != null) {
            return this.createTrackedPackageImportsFromImportedBundle(bundleManifestHolder, importedBundle.isApplicationImportScope(), packageImportsToBePromoted);
        }
        if (mandatory) {
            throw new UnableToSatisfyBundleDependenciesException(importingBundle.getBundleSymbolicName() != null ? importingBundle.getBundleSymbolicName().getSymbolicName() : MISSING_BUNDLE_SYMBOLIC_NAME, importingBundle.getBundleVersion(), "Import-Bundle with symbolic name '" + bundleSymbolicName + "' in version range '" + importVersionRange + "' could not be satisfied");
        }
        return this.trackedPackageImportsFactory.createEmpty();
    }

    private TrackedPackageImports createTrackedPackageImportsFromImportedBundle(OrderedPair<BundleManifest, Boolean> bundleManifest, boolean promoteExports, TrackedPackageImports packageImportsToBePromoted) {
        TrackedPackageImports bundlePackageImports = this.createPackageImportsFromPackageExports(bundleManifest, promoteExports);
        if (promoteExports) {
            packageImportsToBePromoted.merge(bundlePackageImports);
        }
        return bundlePackageImports;
    }

    private TrackedPackageImports createPackageImportsFromPackageExports(OrderedPair<BundleManifest, Boolean> bundleManifestHolder, boolean promoteExports) {
        List<ImportedPackage> packageImports;
        BundleManifest bundleManifest = (BundleManifest)bundleManifestHolder.getFirst();
        List exportedPackages = bundleManifest.getExportPackage().getExportedPackages();
        if (exportedPackages.isEmpty()) {
            return this.trackedPackageImportsFactory.createEmpty();
        }
        String bundleVersion = bundleManifest.getBundleVersion().toString();
        String bundleSymbolicName = bundleManifest.getBundleSymbolicName().getSymbolicName();
        if (bundleManifest.getFragmentHost().getBundleSymbolicName() != null) {
            bundleSymbolicName = bundleManifest.getFragmentHost().getBundleSymbolicName();
            packageImports = BundleManifestProcessor.createImportedPackageForEachExportedPackageOfFragment(exportedPackages, bundleSymbolicName, bundleManifest.getFragmentHost().getBundleVersion());
        } else {
            packageImports = BundleManifestProcessor.createImportedPackageForEachExportedPackage(exportedPackages, bundleSymbolicName, bundleVersion);
        }
        if (promoteExports) {
            this.tagImportsAsPromoted(packageImports);
        }
        if (((Boolean)bundleManifestHolder.getSecond()).booleanValue()) {
            this.diagnoseSystemBundleOverlap(packageImports, bundleSymbolicName, bundleVersion);
        }
        return this.trackedPackageImportsFactory.create(packageImports, "Import-Bundle '" + bundleManifest.getBundleSymbolicName().getSymbolicName() + "' version '" + bundleManifest.getBundleVersion() + "'");
    }

    private void tagImportsAsPromoted(List<ImportedPackage> packageImports) {
        for (ImportedPackage importedPackage : packageImports) {
            importedPackage.getDirectives().put(IMPORT_SCOPE_DIRECTIVE, IMPORT_SCOPE_APPLICATION);
        }
    }

    private void diagnoseSystemBundleOverlap(List<ImportedPackage> importedPackages, String bundleSymbolicNameString, String bundleVersion) {
        boolean overlap = false;
        for (ImportedPackage importedPackage : importedPackages) {
            if (!this.packagesExportedBySystemBundle.contains(importedPackage.getPackageName())) continue;
            overlap = true;
            break;
        }
        if (overlap) {
            StringBuilder imports = new StringBuilder();
            boolean first = true;
            for (ImportedPackage packageImport : importedPackages) {
                if (!first) {
                    imports.append(",");
                }
                first = false;
                imports.append(packageImport.getPackageName());
            }
            this.eventLogger.log((LogEvent)UserRegionLogEvents.SYSTEM_BUNDLE_OVERLAP, new Object[]{bundleSymbolicNameString, bundleVersion, imports.toString()});
        }
    }

    private TrackedPackageImports getLibraryPackageImports(List<ImportedLibrary> importedLibraries, TrackedPackageImports packageImportsToBePromoted, BundleManifest importingBundle, List<BundleManifest> additionalManifests) throws UnableToSatisfyBundleDependenciesException {
        TrackedPackageImports allLibraryPackageImports = this.trackedPackageImportsFactory.createCollector();
        for (ImportedLibrary importedLibrary : importedLibraries) {
            VersionRange libraryVersionRange = importedLibrary.getVersion();
            String libraryName = importedLibrary.getLibrarySymbolicName();
            ArtifactDescriptor libraryArtefact = this.findArtifactDescriptorForLibrary(libraryName, libraryVersionRange);
            if (libraryArtefact != null) {
                if (!libraryName.endsWith(INSTRUMENTED_SUFFIX) && libraryArtefact.getName().endsWith(INSTRUMENTED_SUFFIX)) {
                    this.eventLogger.log((LogEvent)UserRegionLogEvents.ALTERNATE_INSTRUMENTED_LIBRARY_FOUND, new Object[]{importingBundle.getBundleSymbolicName(), libraryName, libraryVersionRange.toString(), libraryArtefact.getName()});
                }
                Version libraryVersion = libraryArtefact.getVersion();
                TrackedPackageImports libraryPackageImports = this.trackedPackageImportsFactory.createContainer("Import-Library '" + importedLibrary.getLibrarySymbolicName() + "' version '" + libraryVersion + "'");
                Set importedBundles = libraryArtefact.getAttribute("Import-Bundle");
                for (Attribute importedBundle : importedBundles) {
                    Map properties;
                    Set versionSet;
                    VersionRange bundleVersionRange;
                    String bundleSymbolicName = importedBundle.getValue();
                    OrderedPair<BundleManifest, Boolean> bundleManifest = this.findBundle(bundleSymbolicName, bundleVersionRange = (versionSet = (Set)(properties = importedBundle.getProperties()).get("version")) != null && !versionSet.isEmpty() ? new VersionRange((String)versionSet.iterator().next()) : VersionRange.NATURAL_NUMBER_RANGE, additionalManifests);
                    if (bundleManifest.getFirst() != null) {
                        boolean applicationImportScope = false;
                        Set importScopeSet = (Set)properties.get(IMPORT_SCOPE_DIRECTIVE);
                        if (importScopeSet != null && !importScopeSet.isEmpty()) {
                            applicationImportScope = IMPORT_SCOPE_APPLICATION.equals(importScopeSet.iterator().next());
                        }
                        libraryPackageImports.merge(this.createTrackedPackageImportsFromImportedBundle(bundleManifest, applicationImportScope, packageImportsToBePromoted));
                        continue;
                    }
                    Resolution importedBundleResolution = Resolution.MANDATORY;
                    Set resolutionSet = (Set)properties.get("resolution");
                    if (resolutionSet != null && !resolutionSet.isEmpty()) {
                        importedBundleResolution = Resolution.valueOf((String)((String)resolutionSet.iterator().next()).toUpperCase(Locale.ENGLISH));
                    }
                    if (!importedBundleResolution.equals((Object)Resolution.MANDATORY)) continue;
                    throw new UnableToSatisfyBundleDependenciesException(importingBundle.getBundleSymbolicName() != null ? importingBundle.getBundleSymbolicName().getSymbolicName() : MISSING_BUNDLE_SYMBOLIC_NAME, importingBundle.getBundleVersion(), "Imported library '" + libraryName + "' version '" + libraryVersion + "' contains Import-Bundle for bundle '" + bundleSymbolicName + "' in version range '" + bundleVersionRange + "' which could not be satisfied");
                }
                allLibraryPackageImports.merge(libraryPackageImports);
                continue;
            }
            if (!importedLibrary.getResolution().equals((Object)Resolution.MANDATORY)) continue;
            throw this.createExceptionForMissingLibrary(libraryName, libraryVersionRange, importingBundle);
        }
        return allLibraryPackageImports;
    }

    private void setMergedImports(BundleManifest bundleManifest, TrackedPackageImports bundleTrackedPackageImports) {
        bundleManifest.getImportPackage().getImportedPackages().clear();
        bundleManifest.getImportPackage().getImportedPackages().addAll(bundleTrackedPackageImports.getMergedImports());
    }

    private OrderedPair<BundleManifest, Boolean> findBundle(String bundleSymbolicName, VersionRange versionRange, List<BundleManifest> additionalManifests) {
        ArtifactDescriptor artefact;
        boolean diagnose = false;
        BundleManifest bundleManifest = this.findMatchingManifest(bundleSymbolicName, versionRange, additionalManifests);
        if (bundleManifest == null && this.bundleContext != null) {
            Bundle[] installedBundles;
            Bundle[] bundleArray = installedBundles = this.bundleContext.getBundles();
            int n = installedBundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundleSymbolicName.equals(bundle.getSymbolicName()) && versionRange.includes(bundle.getVersion()) && (bundleManifest = this.getBundleManifest(bundle)) != null) {
                    diagnose = true;
                    break;
                }
                ++n2;
            }
        }
        if (bundleManifest == null && (artefact = this.findArtifactDescriptorForBundle(bundleSymbolicName, versionRange)) != null) {
            diagnose = true;
            bundleManifest = BundleManifestFactory.createBundleManifest((Dictionary)BundleBridge.convertToDictionary((ArtifactDescriptor)artefact));
        }
        if (bundleManifest != null) {
            this.logger.info("Found definition for bundle with symbolic name '{}' and version range '{}': {}", new Object[]{bundleSymbolicName, versionRange, bundleManifest});
        } else {
            this.logger.info("Could not find definition for bundle with symbolic name '{}' and version range '{}'", (Object)bundleSymbolicName, (Object)versionRange);
        }
        return new OrderedPair((Object)bundleManifest, (Object)diagnose);
    }

    private BundleManifest findMatchingManifest(String bundleSymbolicName, VersionRange versionRange, List<BundleManifest> additionalManifests) {
        Version selectedVersion = null;
        BundleManifest selectedManifest = null;
        for (BundleManifest manifest : additionalManifests) {
            Version version;
            BundleSymbolicName bsn = manifest.getBundleSymbolicName();
            if (bsn == null || !bundleSymbolicName.equals(bsn.getSymbolicName()) || !versionRange.includes(version = manifest.getBundleVersion()) || selectedVersion != null && version.compareTo(selectedVersion) <= 0) continue;
            selectedVersion = version;
            selectedManifest = manifest;
        }
        return selectedManifest;
    }

    private ArtifactDescriptor findArtifactDescriptorForBundle(String bundleSymbolicName, VersionRange versionRange) {
        return this.repository.get("bundle", bundleSymbolicName, versionRange);
    }

    private ArtifactDescriptor findArtifactDescriptorForLibrary(String librarySymbolicName, VersionRange versionRange) {
        return this.repository.get("library", librarySymbolicName, versionRange);
    }

    private BundleManifest getBundleManifest(Bundle bundle) {
        return BundleManifestFactory.createBundleManifest((Dictionary)bundle.getHeaders());
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.importexpansion.ImportExpansionHandler");
    }
}

