/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.eclipse.virgo.util.common.Assert;
import org.eclipse.virgo.util.io.FatalIOException;
import org.slf4j.Logger;

public final class FileSystemUtils {
    private static final String URI_FILE_SCHEME = "file";

    private FileSystemUtils() {
    }

    public static String convertToCanonicalPath(String path) throws FatalIOException {
        return FileSystemUtils.convertToCanonicalPath(path, false);
    }

    public static String convertToCanonicalPath(String path, boolean verifyPathIsDirectory) throws FatalIOException {
        if (path == null) {
            return null;
        }
        try {
            File dir = new File(path);
            if (verifyPathIsDirectory && !dir.isDirectory()) {
                throw new FatalIOException("The supplied path [" + path + "] is not a directory.");
            }
            return dir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new FatalIOException("Could not determine the canonical path for [" + path + "]", e);
        }
    }

    public static String convertToCanonicalPath(URI uri) throws FatalIOException {
        if (uri == null) {
            return null;
        }
        Assert.isTrue((boolean)uri.getScheme().equals(URI_FILE_SCHEME), (String)"Cannot determine path of URI '%s' with non-file scheme", (Object[])new Object[]{uri});
        try {
            return new File(uri).getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new FatalIOException("Could not determine the canonical path for URI [" + uri + "]", ioe);
        }
    }

    public static String createDirectoryIfNecessary(String path) {
        boolean success;
        Assert.notNull((Object)path, (String)"'path' must not be null.", (Object[])new Object[0]);
        File dir = new File(path);
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new FatalIOException("Unable to create needed directory " + path);
        }
        return FileSystemUtils.convertToCanonicalPath(path);
    }

    public static boolean deleteRecursively(File root) {
        return FileSystemUtils.doRecursiveDelete(root);
    }

    public static boolean deleteRecursively(String path) {
        return FileSystemUtils.deleteRecursively(new File(path));
    }

    public static String[] list(File dir) throws FatalIOException {
        return FileSystemUtils.list(dir, null);
    }

    public static String[] list(File dir, Logger logger) throws FatalIOException {
        String[] filenames = dir.list();
        if (filenames == null) {
            if (logger != null) {
                logger.warn("'" + dir + "'.list() returned null first time.");
            }
            FileSystemUtils.preRetryFileOp(dir, logger);
            filenames = dir.list();
        }
        if (filenames == null) {
            if (logger != null) {
                logger.error("'" + dir + "'.list() returned null on retry.");
            }
            throw new FatalIOException("list() failed for file " + dir);
        }
        return filenames;
    }

    public static String[] list(File dir, FilenameFilter filenameFilter) throws FatalIOException {
        return FileSystemUtils.list(dir, filenameFilter, null);
    }

    public static String[] list(File dir, FilenameFilter filenameFilter, Logger logger) throws FatalIOException {
        String[] filenames = dir.list(filenameFilter);
        if (filenames == null) {
            if (logger != null) {
                logger.warn("'" + dir + "'.list(<FilenameFilter>) returned null first time.");
            }
            FileSystemUtils.preRetryFileOp(dir, logger);
            filenames = dir.list(filenameFilter);
        }
        if (filenames == null) {
            if (logger != null) {
                logger.error("'" + dir + "'.list(<FilenameFilter>) returned null on retry.");
            }
            throw new FatalIOException("list(FilenameFilter) failed for file " + dir);
        }
        return filenames;
    }

    public static File[] listFiles(File dir, Logger logger) throws FatalIOException {
        File[] files = dir.listFiles();
        if (files == null) {
            if (logger != null) {
                logger.warn("'" + dir + "'.listFiles() returned null first time.");
            }
            FileSystemUtils.preRetryFileOp(dir, logger);
            files = dir.listFiles();
        }
        if (files == null) {
            if (logger != null) {
                logger.error("'" + dir + "'.listFiles() returned null on retry.");
            }
            throw new FatalIOException("listFiles() failed for file " + dir);
        }
        return files;
    }

    public static File[] listFiles(File dir, FileFilter fileFilter) throws FatalIOException {
        return FileSystemUtils.listFiles(dir, fileFilter, null);
    }

    public static File[] listFiles(File dir) throws FatalIOException {
        return FileSystemUtils.listFiles(dir, null);
    }

    public static File[] listFiles(File dir, FileFilter fileFilter, Logger logger) throws FatalIOException {
        File[] files = dir.listFiles(fileFilter);
        if (files == null) {
            if (logger != null) {
                logger.warn("'" + dir + "'.listFiles(<FileFilter>) returned null first time.");
            }
            FileSystemUtils.preRetryFileOp(dir, logger);
            files = dir.listFiles(fileFilter);
        }
        if (files == null) {
            if (logger != null) {
                logger.error("'" + dir + "'.listFiles(<FileFilter>) returned null on retry.");
            }
            throw new FatalIOException("listFiles(FileFilter) failed for file " + dir);
        }
        return files;
    }

    public static File[] listFiles(File dir, FilenameFilter filenameFilter) throws FatalIOException {
        return FileSystemUtils.listFiles(dir, filenameFilter, null);
    }

    public static File[] listFiles(File dir, FilenameFilter filenameFilter, Logger logger) throws FatalIOException {
        File[] files = dir.listFiles(filenameFilter);
        if (files == null) {
            if (logger != null) {
                logger.warn("'" + dir + "'.listFiles(<FilenameFilter>) returned null first time.");
            }
            FileSystemUtils.preRetryFileOp(dir, logger);
            files = dir.listFiles(filenameFilter);
        }
        if (files == null) {
            if (logger != null) {
                logger.error("'" + dir + "'.listFiles(<FilenameFilter>) returned null on retry.");
            }
            throw new FatalIOException("listFiles(FilenameFilter) failed for file " + dir);
        }
        return files;
    }

    private static final void preRetryFileOp(File file, Logger logger) {
        block2: {
            try {
                file.getCanonicalPath();
            }
            catch (IOException ioe) {
                if (logger == null) break block2;
                logger.warn("PreRetry logic '" + file + "'.getCanonicalPath() threw IOException.", (Throwable)ioe);
            }
        }
    }

    private static boolean doRecursiveDelete(File root) {
        if (root.exists()) {
            File[] children;
            if (root.isDirectory() && (children = root.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    FileSystemUtils.doRecursiveDelete(file);
                    ++n2;
                }
            }
            return root.delete();
        }
        return false;
    }
}

