/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class BeanReference
extends SpelNodeImpl {
    private String beanname;

    public BeanReference(int pos, String beanname) {
        super(pos, new SpelNodeImpl[0]);
        this.beanname = beanname;
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        BeanResolver beanResolver = state.getEvaluationContext().getBeanResolver();
        if (beanResolver == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.NO_BEAN_RESOLVER_REGISTERED, this.beanname);
        }
        try {
            TypedValue bean = new TypedValue(beanResolver.resolve(state.getEvaluationContext(), this.beanname));
            return bean;
        }
        catch (AccessException ae) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_BEAN_RESOLUTION, this.beanname, ae.getMessage());
        }
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        if (this.beanname.indexOf(46) == -1) {
            sb.append(this.beanname);
        } else {
            sb.append("'").append(this.beanname).append("'");
        }
        return sb.toString();
    }
}

