/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.virgo.ide.runtime.core.IServerWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyArtefactOrderCommand;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ArtefactOrderEditorSection
extends ServerEditorSection {
    protected IServerWorkingCopy serverWorkingCopy;
    protected boolean updating;
    protected PropertyChangeListener listener;
    private Table bundleTable;
    private TableViewer bundleTableViewer;
    private Button upButton;
    private Button downButton;
    private ArtefactContentProvider contentProvider;

    protected void addConfigurationChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ArtefactOrderEditorSection.this.updating) {
                    return;
                }
                ArtefactOrderEditorSection.this.updating = true;
                if ("org.eclipse.virgo.ide.runtime.coreartefact.deploy.order".equals(event.getPropertyName())) {
                    ArtefactOrderEditorSection.this.bundleTableViewer.setInput((Object)ArtefactOrderEditorSection.this.server);
                }
                ArtefactOrderEditorSection.this.updating = false;
            }
        };
        this.serverWorkingCopy.addConfigurationChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText("Artefact Deployment Order");
        section.setDescription("Specify the deployment order of targeted bundles and PARs on server startup.");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 1;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.bundleTable = toolkit.createTable(composite, 66052);
        GridData data = new GridData(770);
        data.heightHint = 100;
        this.bundleTable.setLayoutData((Object)data);
        this.bundleTableViewer = new TableViewer(this.bundleTable);
        this.contentProvider = new ArtefactContentProvider();
        this.bundleTableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.bundleTableViewer.setLabelProvider((IBaseLabelProvider)ServerUICore.getLabelProvider());
        this.bundleTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                ArtefactOrderEditorSection.this.updateButtons(obj);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        this.upButton = toolkit.createButton(buttonComposite, "Up", 8);
        data = new GridData();
        data.widthHint = 50;
        this.upButton.setLayoutData((Object)data);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedArtefact = ((IStructuredSelection)ArtefactOrderEditorSection.this.bundleTableViewer.getSelection()).getFirstElement();
                ArrayList<Object> modules = new ArrayList<Object>();
                modules.addAll(Arrays.asList(ArtefactOrderEditorSection.this.contentProvider.getElements(ArtefactOrderEditorSection.this.server)));
                int index = modules.indexOf(selectedArtefact);
                modules.remove(selectedArtefact);
                modules.add(index - 1, selectedArtefact);
                ArrayList<String> artefactOrder = new ArrayList<String>();
                for (Object e2 : modules) {
                    artefactOrder.add(((IModule)e2).getId());
                }
                if (ArtefactOrderEditorSection.this.updating) {
                    return;
                }
                ArtefactOrderEditorSection.this.updating = true;
                ArtefactOrderEditorSection.this.execute((IUndoableOperation)new ModifyArtefactOrderCommand(ArtefactOrderEditorSection.this.serverWorkingCopy, artefactOrder));
                ArtefactOrderEditorSection.this.bundleTableViewer.setInput((Object)ArtefactOrderEditorSection.this.server);
                ArtefactOrderEditorSection.this.updateButtons(selectedArtefact);
                ArtefactOrderEditorSection.this.updating = false;
            }
        });
        this.downButton = toolkit.createButton(buttonComposite, "Down", 8);
        this.downButton.setLayoutData((Object)data);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedArtefact = ((IStructuredSelection)ArtefactOrderEditorSection.this.bundleTableViewer.getSelection()).getFirstElement();
                ArrayList<Object> modules = new ArrayList<Object>();
                modules.addAll(Arrays.asList(ArtefactOrderEditorSection.this.contentProvider.getElements(ArtefactOrderEditorSection.this.server)));
                int index = modules.indexOf(selectedArtefact);
                modules.remove(selectedArtefact);
                modules.add(index + 1, selectedArtefact);
                if (ArtefactOrderEditorSection.this.updating) {
                    return;
                }
                ArtefactOrderEditorSection.this.updating = true;
                ArrayList<String> artefactOrder = new ArrayList<String>();
                for (Object e2 : modules) {
                    artefactOrder.add(((IModule)e2).getId());
                }
                ArtefactOrderEditorSection.this.execute((IUndoableOperation)new ModifyArtefactOrderCommand(ArtefactOrderEditorSection.this.serverWorkingCopy, artefactOrder));
                ArtefactOrderEditorSection.this.bundleTableViewer.setInput((Object)ArtefactOrderEditorSection.this.server);
                ArtefactOrderEditorSection.this.updateButtons(selectedArtefact);
                ArtefactOrderEditorSection.this.updating = false;
            }
        });
        this.initialize();
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverWorkingCopy = (IServerWorkingCopy)this.server.loadAdapter(IServerWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor());
        this.addConfigurationChangeListener();
    }

    protected void initialize() {
        this.updating = true;
        this.bundleTableViewer.setInput((Object)this.server);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.updating = false;
    }

    private void updateButtons(Object obj) {
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        if (obj instanceof IModule) {
            List<Object> modules = Arrays.asList(this.contentProvider.getElements(this.server));
            int index = modules.indexOf(obj);
            if (index > 0) {
                this.upButton.setEnabled(true);
            }
            if (index < modules.size() - 1) {
                this.downButton.setEnabled(true);
            }
        }
    }

    class ArtefactContentProvider
    implements ITreeContentProvider {
        ArtefactContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IServer) {
                IServer server = (IServer)inputElement;
                IModule[] modules = server.getModules();
                IServerWorkingCopy workingServer = (IServerWorkingCopy)server.loadAdapter(IServerWorkingCopy.class, null);
                final List orderedArtefacts = workingServer.getConfiguration().getArtefactOrder();
                List<IModule> orderedModules = Arrays.asList(modules);
                Collections.sort(orderedModules, new Comparator<IModule>(){

                    @Override
                    public int compare(IModule o1, IModule o2) {
                        Integer m1 = orderedArtefacts.contains(o1.getId()) ? orderedArtefacts.indexOf(o1.getId()) : Integer.MAX_VALUE;
                        Integer m2 = orderedArtefacts.contains(o2.getId()) ? orderedArtefacts.indexOf(o2.getId()) : Integer.MAX_VALUE;
                        return m1.compareTo(m2);
                    }
                });
                return orderedModules.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }
}

