/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.transformation.eventdriven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.eclipse.viatra.query.runtime.api.GenericQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableEVM;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableEVMFactory;
import org.eclipse.viatra.transformation.evm.api.adapter.IAdapterConfiguration;
import org.eclipse.viatra.transformation.evm.api.adapter.IEVMAdapter;
import org.eclipse.viatra.transformation.evm.api.adapter.IEVMListener;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.resolver.ArbitraryOrderConflictResolver;
import org.eclipse.viatra.transformation.runtime.emf.rules.EventDrivenTransformationRuleGroup;
import org.eclipse.viatra.transformation.runtime.emf.rules.eventdriven.EventDrivenTransformationRule;

public class EventDrivenTransformation {
    private ViatraQueryEngine queryEngine;
    private ExecutionSchema executionSchema;
    private Map<RuleSpecification<?>, EventDrivenTransformationRule<?, ?>> rules;

    public static EventDrivenTransformationBuilder forScope(EMFScope scope) {
        return EventDrivenTransformation.forEngine(ViatraQueryEngine.on((QueryScope)scope));
    }

    public static EventDrivenTransformationBuilder forEngine(ViatraQueryEngine engine) {
        return new EventDrivenTransformationBuilder().setQueryEngine(engine);
    }

    private EventDrivenTransformation(ExecutionSchema executionSchema, ViatraQueryEngine queryEngine) {
        this.executionSchema = executionSchema;
        this.queryEngine = queryEngine;
    }

    public EventDrivenTransformation setDebugLevel(Level level) {
        this.executionSchema.getLogger().setLevel(level);
        return this;
    }

    public ViatraQueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public ExecutionSchema getExecutionSchema() {
        return this.executionSchema;
    }

    public void useDebugInfo(boolean debug) {
        if (debug) {
            this.executionSchema.getLogger().setLevel(Level.DEBUG);
        }
    }

    public Map<RuleSpecification<?>, EventDrivenTransformationRule<?, ?>> getTransformationRules() {
        return this.rules;
    }

    protected void setRules(Map<RuleSpecification<?>, EventDrivenTransformationRule<?, ?>> rules) {
        this.rules = rules;
    }

    public void dispose() {
        this.executionSchema.dispose();
    }

    public static class EventDrivenTransformationBuilder {
        private ConflictResolver conflictResolver;
        private ViatraQueryEngine engine;
        private Scheduler.ISchedulerFactory schedulerFactory;
        private List<EventDrivenTransformationRule<?, ?>> rules = new ArrayList();
        private List<IEVMAdapter> adapters = new ArrayList<IEVMAdapter>();
        private List<IEVMListener> listeners = new ArrayList<IEVMListener>();

        public EventDrivenTransformationBuilder setScope(EMFScope scope) {
            this.engine = ViatraQueryEngine.on((QueryScope)scope);
            return this;
        }

        public EventDrivenTransformationBuilder setQueryEngine(ViatraQueryEngine engine) {
            this.engine = engine;
            return this;
        }

        public EventDrivenTransformationBuilder addAdapter(IEVMAdapter adapter) {
            this.adapters.add(adapter);
            return this;
        }

        public EventDrivenTransformationBuilder addListener(IEVMListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public EventDrivenTransformationBuilder addAdapterConfiguration(IAdapterConfiguration config) {
            this.listeners.addAll(config.getListeners());
            this.adapters.addAll(config.getAdapters());
            return this;
        }

        public EventDrivenTransformationBuilder setSchedulerFactory(Scheduler.ISchedulerFactory schedulerFactory) {
            this.schedulerFactory = schedulerFactory;
            return this;
        }

        public EventDrivenTransformationBuilder setConflictResolver(ConflictResolver resolver) {
            this.conflictResolver = resolver;
            return this;
        }

        public EventDrivenTransformationBuilder addRule(EventDrivenTransformationRule<?, ?> rule) {
            this.rules.add(rule);
            return this;
        }

        public EventDrivenTransformationBuilder addRules(EventDrivenTransformationRuleGroup ruleGroup) {
            for (EventDrivenTransformationRule rule : ruleGroup) {
                this.rules.add(rule);
            }
            return this;
        }

        public EventDrivenTransformation build() {
            Preconditions.checkState((this.engine != null ? 1 : 0) != 0, (String)"ViatraQueryEngine must be set.");
            HashMap rulesToAdd = new HashMap();
            if (this.schedulerFactory == null) {
                this.schedulerFactory = Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)this.engine);
            }
            if (this.conflictResolver == null) {
                this.conflictResolver = new ArbitraryOrderConflictResolver();
            }
            AdaptableEVM vm = AdaptableEVMFactory.getInstance().createAdaptableEVM();
            vm.addAdapters(this.adapters);
            vm.addListeners(this.listeners);
            ExecutionSchema schema = this.adapters.size() > 0 || this.listeners.size() > 0 ? vm.createAdaptableExecutionSchema(this.engine, this.schedulerFactory, this.conflictResolver) : ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)this.engine, (Scheduler.ISchedulerFactory)this.schedulerFactory, (ConflictResolver)this.conflictResolver);
            GenericQueryGroup.of(this.collectPreconditions()).prepare(this.engine);
            for (EventDrivenTransformationRule<?, ?> rule : this.rules) {
                schema.addRule(rule.getRuleSpecification(), rule.getFilter());
                rulesToAdd.put(rule.getRuleSpecification(), rule);
            }
            EventDrivenTransformation transformation = new EventDrivenTransformation(schema, this.engine);
            transformation.setRules(rulesToAdd);
            vm.initialize(this.engine);
            return transformation;
        }

        private Set<IQuerySpecification<?>> collectPreconditions() {
            return this.rules.stream().filter(Objects::nonNull).map(EventDrivenTransformationRule::getPrecondition).filter(Objects::nonNull).collect(Collectors.toSet());
        }
    }
}

