/**
 * 
 *   Copyright (c) 2010-2013, Abel Hegedus, Zoltan Ujhelyi, Denes Harmath, Istvan Rath and Daniel Varro, IncQuery Labs Ltd.
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.integration.uml.derivedfeatures;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecificationWithGenericMatcher;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

/**
 * A pattern-specific query specification that can instantiate GenericPatternMatcher in a type-safe way.
 * 
 * <p>Original source:
 *         <code><pre>
 *         (if connector.type = null 
 *         then
 *           null 
 *         else
 *           let index : Integer = connector.end-{@literal >}indexOf(self) in
 *             connector.type.memberEnd-{@literal >}at(index)
 *         endif)
 *         
 *         // Can't compile OCL to VIATRA Query because of org.eclipse.ocl.SemanticException: Unrecognized variable: (connector)
 *         //{@literal @}Surrogate(feature = "definingEnd")
 *         //{@literal @}QueryExplorer(checked = false)
 *         //pattern connectorEndDefiningEnd(source: ConnectorEnd, target: Property) {}
 *         
 *         
 *         (deployment.deployedArtifact-{@literal >}select(oclIsKindOf(Artifact))-{@literal >}collect(oclAsType(Artifact).manifestation)-{@literal >}collect(utilizedElement)-{@literal >}asSet())
 *         
 *         {@literal @}Surrogate(feature = "deployedElement")
 *         pattern deploymentTargetDeployedElement(
 *             self : DeploymentTarget,
 *             packageableElement : PackageableElement
 *         ) {
 *             Artifact(artifact);
 *             temp2 == artifact;
 *             DeploymentTarget.deployment(self, deployment);
 *             temp1 == deployment;
 *             Deployment.deployedArtifact(temp1, deployedArtifact);
 *             temp2 == deployedArtifact;
 *             temp3 == temp2;
 *             Artifact.manifestation(temp3, manifestation);
 *             temp4 == manifestation;
 *             Manifestation.utilizedElement(temp4, packageableElement);
 *         }
 * </pre></code>
 * 
 * @see GenericPatternMatcher
 * @see GenericPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class DeploymentTargetDeployedElement extends BaseGeneratedEMFQuerySpecificationWithGenericMatcher {
  private DeploymentTargetDeployedElement() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
   * 
   */
  public static DeploymentTargetDeployedElement instance() {
    try{
        return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
        throw processInitializerError(err);
    }
  }
  
  /**
   * Inner class allowing the singleton instance of {@link DeploymentTargetDeployedElement} to be created 
   *     <b>not</b> at the class load time of the outer class, 
   *     but rather at the first call to {@link DeploymentTargetDeployedElement#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private static final DeploymentTargetDeployedElement INSTANCE = new DeploymentTargetDeployedElement();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private static final Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternal();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private static final DeploymentTargetDeployedElement.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_self = new PParameter("self", "org.eclipse.uml2.uml.DeploymentTarget", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "DeploymentTarget")), PParameterDirection.INOUT);
    
    private final PParameter parameter_packageableElement = new PParameter("packageableElement", "org.eclipse.uml2.uml.PackageableElement", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_self, parameter_packageableElement);
    
    private GeneratedPQuery() {
      super(PVisibility.PUBLIC);
    }
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.integration.uml.derivedfeatures.deploymentTargetDeployedElement";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","packageableElement");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() {
      setEvaluationHints(new QueryEvaluationHint(null, QueryEvaluationHint.BackendRequirement.UNSPECIFIED));
      Set<PBody> bodies = new LinkedHashSet<>();
      {
          PBody body = new PBody(this);
          PVariable var_self = body.getOrCreateVariableByName("self");
          PVariable var_packageableElement = body.getOrCreateVariableByName("packageableElement");
          PVariable var_artifact = body.getOrCreateVariableByName("artifact");
          PVariable var_temp2 = body.getOrCreateVariableByName("temp2");
          PVariable var_deployment = body.getOrCreateVariableByName("deployment");
          PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
          PVariable var_deployedArtifact = body.getOrCreateVariableByName("deployedArtifact");
          PVariable var_temp3 = body.getOrCreateVariableByName("temp3");
          PVariable var_manifestation = body.getOrCreateVariableByName("manifestation");
          PVariable var_temp4 = body.getOrCreateVariableByName("temp4");
          new TypeConstraint(body, Tuples.flatTupleOf(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "DeploymentTarget")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_packageableElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_self, parameter_self),
             new ExportedParameter(body, var_packageableElement, parameter_packageableElement)
          ));
          //     Artifact(artifact)
          new TypeConstraint(body, Tuples.flatTupleOf(var_artifact), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Artifact")));
          //     temp2 == artifact
          new Equality(body, var_temp2, var_artifact);
          //     DeploymentTarget.deployment(self, deployment)
          new TypeConstraint(body, Tuples.flatTupleOf(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "DeploymentTarget")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_self, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "DeploymentTarget", "deployment")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Deployment")));
          new Equality(body, var__virtual_0_, var_deployment);
          //     temp1 == deployment
          new Equality(body, var_temp1, var_deployment);
          //     Deployment.deployedArtifact(temp1, deployedArtifact)
          new TypeConstraint(body, Tuples.flatTupleOf(var_temp1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Deployment")));
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_temp1, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Deployment", "deployedArtifact")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_1_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "DeployedArtifact")));
          new Equality(body, var__virtual_1_, var_deployedArtifact);
          //     temp2 == deployedArtifact
          new Equality(body, var_temp2, var_deployedArtifact);
          //     temp3 == temp2
          new Equality(body, var_temp3, var_temp2);
          //     Artifact.manifestation(temp3, manifestation)
          new TypeConstraint(body, Tuples.flatTupleOf(var_temp3), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Artifact")));
          PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_temp3, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Artifact", "manifestation")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_2_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Manifestation")));
          new Equality(body, var__virtual_2_, var_manifestation);
          //     temp4 == manifestation
          new Equality(body, var_temp4, var_manifestation);
          //     Manifestation.utilizedElement(temp4, packageableElement)
          new TypeConstraint(body, Tuples.flatTupleOf(var_temp4), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Manifestation")));
          PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_temp4, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Manifestation", "utilizedElement")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_3_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
          new Equality(body, var__virtual_3_, var_packageableElement);
          bodies.add(body);
      }
      {
          PAnnotation annotation = new PAnnotation("Surrogate");
          annotation.addAttribute("feature", "deployedElement");
          addAnnotation(annotation);
      }
      return bodies;
    }
  }
}
