/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

abstract class AbstractTimelyMaskedMemory<Timestamp extends Comparable<Timestamp>, KeyType>
extends MaskedTupleMemory<Timestamp> {
    protected final TreeMap<Timestamp, Set<KeyType>> foldingStates;
    protected final Map<KeyType, TimelyMemory<Timestamp>> memoryMap;
    protected final boolean isLazy;

    public AbstractTimelyMaskedMemory(TupleMask mask, Object owner, boolean isLazy) {
        super(mask, owner);
        this.isLazy = isLazy;
        this.memoryMap = CollectionsFactory.createMap();
        this.foldingStates = this.isLazy ? CollectionsFactory.createTreeMap() : null;
    }

    @Override
    public void initializeWith(MaskedTupleMemory<Timestamp> other, Timestamp defaultValue) {
        Iterable<Tuple> signatures = other.getSignatures();
        for (Tuple signature : signatures) {
            if (other.isTimely()) {
                Map<Tuple, Timeline<Timestamp>> tupleMap = other.getWithTimeline(signature);
                for (Map.Entry entry : tupleMap.entrySet()) {
                    for (Signed signed : ((Timeline)entry.getValue()).asChangeSequence()) {
                        if (signed.getDirection() == Direction.DELETE) {
                            this.removeWithTimestamp((Tuple)entry.getKey(), signed.getPayload());
                            continue;
                        }
                        this.addWithTimestamp((Tuple)entry.getKey(), signed.getPayload());
                    }
                }
                continue;
            }
            Collection<Tuple> tuples = other.get(signature);
            for (Tuple tuple : tuples) {
                this.addWithTimestamp(tuple, defaultValue);
            }
        }
    }

    public boolean isPresentAtInfinityInteral(KeyType key) {
        TimelyMemory<Timestamp> values = this.memoryMap.get(key);
        if (values == null) {
            return false;
        }
        return values.getCountAtInfinity() != 0;
    }

    @Override
    public void clear() {
        this.memoryMap.clear();
    }

    @Override
    public int getKeysetSize() {
        return this.memoryMap.keySet().size();
    }

    @Override
    public int getTotalSize() {
        int i = 0;
        for (Map.Entry<KeyType, TimelyMemory<Timestamp>> entry : this.memoryMap.entrySet()) {
            i += entry.getValue().size();
        }
        return i;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.memoryMap.values().stream().flatMap(e -> e.keySet().stream()).iterator();
    }

    protected Collection<Tuple> getInternal(KeyType key) {
        TimelyMemory<Timestamp> memory = this.memoryMap.get(key);
        if (memory == null) {
            return null;
        }
        return memory.getTuplesAtInfinity();
    }

    public Map<Tuple, Timeline<Timestamp>> getWithTimestampInternal(KeyType key) {
        TimelyMemory<Timestamp> memory = this.memoryMap.get(key);
        if (memory == null) {
            return null;
        }
        return memory.asMap();
    }

    protected Diff<Timestamp> removeInternal(KeyType key, Tuple tuple, Timestamp timestamp) {
        Timestamp oldResumableTimestamp = null;
        Timestamp newResumableTimestamp = null;
        TimelyMemory<Timestamp> keyMemory = this.memoryMap.get(key);
        if (keyMemory == null) {
            throw this.raiseDuplicateDeletion(tuple);
        }
        if (this.isLazy) {
            oldResumableTimestamp = keyMemory.getResumableTimestamp();
        }
        Diff<Timestamp> diff = null;
        try {
            diff = keyMemory.remove(tuple, timestamp);
        }
        catch (IllegalStateException e) {
            throw this.raiseDuplicateDeletion(tuple);
        }
        if (keyMemory.isEmpty()) {
            this.memoryMap.remove(key);
        }
        if (this.isLazy && !Objects.equals(oldResumableTimestamp, newResumableTimestamp = (Timestamp)keyMemory.getResumableTimestamp())) {
            this.unregisterFoldingState(oldResumableTimestamp, key);
            this.registerFoldingState(newResumableTimestamp, key);
        }
        return diff;
    }

    protected Diff<Timestamp> addInternal(KeyType key, Tuple tuple, Timestamp timestamp) {
        Timestamp oldResumableTimestamp = null;
        Timestamp newResumableTimestamp = null;
        TimelyMemory keyMemory = this.memoryMap.computeIfAbsent(key, k -> new TimelyMemory(this.isLazy));
        if (this.isLazy) {
            oldResumableTimestamp = keyMemory.getResumableTimestamp();
        }
        Diff<Timestamp> diff = keyMemory.put(tuple, timestamp);
        if (this.isLazy && !Objects.equals(oldResumableTimestamp, newResumableTimestamp = (Timestamp)keyMemory.getResumableTimestamp())) {
            this.unregisterFoldingState(oldResumableTimestamp, key);
            this.registerFoldingState(newResumableTimestamp, key);
        }
        return diff;
    }

    @Override
    public Diff<Timestamp> removeWithTimestamp(Tuple tuple, Timestamp timestamp) {
        return this.removeWithTimestamp(tuple, null, timestamp);
    }

    @Override
    public Diff<Timestamp> addWithTimestamp(Tuple tuple, Timestamp timestamp) {
        return this.addWithTimestamp(tuple, null, timestamp);
    }

    @Override
    public boolean isTimely() {
        return true;
    }

    protected void registerFoldingState(Timestamp timestamp, KeyType key) {
        if (timestamp != null) {
            this.foldingStates.compute(timestamp, (k, v) -> {
                if (v == null) {
                    v = CollectionsFactory.createSet();
                }
                v.add(key);
                return v;
            });
        }
    }

    protected void unregisterFoldingState(Timestamp timestamp, KeyType key) {
        if (timestamp != null) {
            this.foldingStates.compute(timestamp, (k, v) -> {
                v.remove(key);
                return v.isEmpty() ? null : v;
            });
        }
    }

    @Override
    public Timestamp getResumableTimestamp() {
        if (this.foldingStates == null || this.foldingStates.isEmpty()) {
            return null;
        }
        return (Timestamp)((Comparable)this.foldingStates.firstKey());
    }
}

