/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybasedfeatures.runtime;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureSettingDelegateFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class QueryBasedFeatureSetup {
    private static final String WRONG_CLASS_MESSAGE = "Query-based feature setting delegate factory is %s but should be %s";

    private QueryBasedFeatureSetup() {
    }

    public static Set<EStructuralFeature> initializeAllQueryBasedFeatures(Notifier rootNotifier, EPackage ... ePackages) {
        Preconditions.checkArgument((rootNotifier != null ? 1 : 0) != 0, (String)"Root notifier cannot be null!");
        Preconditions.checkArgument((ePackages.length > 0 ? 1 : 0) != 0, (String)"EPackage list cannot be empty!");
        QueryBasedFeatureSettingDelegateFactory qbfFactory = QueryBasedFeatureSetup.getOrCreateFactory();
        Set<EPackage> packagesWithQBFs = QueryBasedFeatureSetup.filterPackagesWithQBFs(ePackages);
        Set<EStructuralFeature> qbfFeatures = QueryBasedFeatureSetup.getQBFeaturesOfPackages(packagesWithQBFs);
        Set<EStructuralFeature> initializedQBFFeatures = QueryBasedFeatureSetup.initializeFeatures(rootNotifier, qbfFactory, qbfFeatures);
        return initializedQBFFeatures;
    }

    private static QueryBasedFeatureSettingDelegateFactory getOrCreateFactory() {
        QueryBasedFeatureSettingDelegateFactory qbfFactory = null;
        EStructuralFeature.Internal.SettingDelegate.Factory.Registry settingDelegateFactoryRegistry = EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE;
        EStructuralFeature.Internal.SettingDelegate.Factory factory = settingDelegateFactoryRegistry.getFactory("org.eclipse.viatra.query.querybasedfeature");
        if (factory == null) {
            qbfFactory = new QueryBasedFeatureSettingDelegateFactory();
            settingDelegateFactoryRegistry.put((Object)"org.eclipse.viatra.query.querybasedfeature", (Object)qbfFactory);
        } else if (factory instanceof QueryBasedFeatureSettingDelegateFactory) {
            qbfFactory = (QueryBasedFeatureSettingDelegateFactory)factory;
        } else {
            String errorMessage = String.format(WRONG_CLASS_MESSAGE, factory.getClass().getName(), QueryBasedFeatureSettingDelegateFactory.class.getName());
            throw new IllegalStateException(errorMessage);
        }
        return qbfFactory;
    }

    private static Set<EPackage> filterPackagesWithQBFs(EPackage ... ePackages) {
        HashSet<EPackage> packagesWithQBFs = new HashSet<EPackage>();
        EPackage[] ePackageArray = ePackages;
        int n = ePackages.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePkg = ePackageArray[n2];
            if (QueryBasedFeatureSetup.hasQBFSettingDelegate(ePkg)) {
                packagesWithQBFs.add(ePkg);
            }
            ++n2;
        }
        return packagesWithQBFs;
    }

    private static boolean hasQBFSettingDelegate(EPackage ePkg) {
        List settingDelegates = EcoreUtil.getSettingDelegates((EPackage)ePkg);
        boolean hasQBFSettingDelegate = false;
        if (settingDelegates.contains("org.eclipse.viatra.query.querybasedfeature")) {
            hasQBFSettingDelegate = true;
        }
        return hasQBFSettingDelegate;
    }

    private static Set<EStructuralFeature> getQBFeaturesOfPackages(Set<EPackage> packagesWithQBFs) {
        HashSet<EStructuralFeature> qbfFeatures = new HashSet<EStructuralFeature>();
        for (EPackage ePkg : packagesWithQBFs) {
            TreeIterator allContents = ePkg.eAllContents();
            while (allContents.hasNext()) {
                EStructuralFeature structuralFeature;
                EObject next = (EObject)allContents.next();
                if (!(next instanceof EStructuralFeature) || (structuralFeature = (EStructuralFeature)next).getEAnnotation("org.eclipse.viatra.query.querybasedfeature") == null) continue;
                qbfFeatures.add(structuralFeature);
            }
        }
        return qbfFeatures;
    }

    private static Set<EStructuralFeature> initializeFeatures(Notifier rootNotifier, QueryBasedFeatureSettingDelegateFactory qbfFactory, Set<EStructuralFeature> qbfFeatures) {
        HashSet<EStructuralFeature> initializedQBFFeatures = new HashSet<EStructuralFeature>();
        for (EStructuralFeature eStructuralFeature : qbfFeatures) {
            qbfFactory.getSettingDelegate(eStructuralFeature).ifPresent(delegate -> {
                delegate.initializeSettingDelegate(rootNotifier);
                initializedQBFFeatures.add(eStructuralFeature);
            });
        }
        return initializedQBFFeatures;
    }
}

