/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.planning.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.util.Sets;

public class FunctionalDependencyHelper {
    private FunctionalDependencyHelper() {
    }

    public static <A> Set<A> closureOf(Collection<A> attributes, Map<Set<A>, Set<A>> dependencies) {
        HashSet<A> closureSet = new HashSet<A>();
        HashSet<Object> closureSet1 = new HashSet<A>(attributes);
        while (closureSet.addAll(closureSet1)) {
            closureSet1 = new HashSet();
            for (Map.Entry<Set<A>, Set<A>> dependency : dependencies.entrySet()) {
                if (!closureSet.containsAll((Collection)dependency.getKey())) continue;
                closureSet1.addAll((Collection)dependency.getValue());
            }
        }
        return closureSet;
    }

    public static <A> boolean isTrivial(Set<A> left, Set<A> right) {
        return left.containsAll(right);
    }

    public static <A> Map<Set<A>, Set<A>> projectDependencies(Map<Set<A>, Set<A>> originalDependencies, Set<A> targetAttributes) {
        HashSet<A> leftCandidates = new HashSet<A>();
        for (Map.Entry<Set<A>, Set<A>> dependency : originalDependencies.entrySet()) {
            if (FunctionalDependencyHelper.isTrivial(dependency.getKey(), dependency.getValue())) continue;
            leftCandidates.addAll(Sets.intersection(dependency.getKey(), targetAttributes));
        }
        HashMap initialDependencies = new HashMap();
        for (Set leftSet : Sets.powerSet(leftCandidates)) {
            Set rightSet;
            if (FunctionalDependencyHelper.isTrivial(leftSet, rightSet = Sets.intersection(FunctionalDependencyHelper.closureOf(leftSet, originalDependencies), targetAttributes))) continue;
            initialDependencies.put(leftSet, rightSet);
        }
        Set constants = Sets.intersection(FunctionalDependencyHelper.closureOf(Collections.emptySet(), originalDependencies), targetAttributes);
        if (!constants.isEmpty()) {
            initialDependencies.put(Collections.emptySet(), constants);
        }
        HashMap<Set, Set> solidDependencies = new HashMap<Set, Set>();
        for (Map.Entry dependency : initialDependencies.entrySet()) {
            Set leftSet = (Set)dependency.getKey();
            Set rightSet = (Set)dependency.getValue();
            boolean solid = true;
            for (Object skipped : leftSet) {
                Set singleton = Collections.singleton(skipped);
                Set candidate = Sets.difference(leftSet, singleton);
                Set rightCandidate = (Set)initialDependencies.get(candidate);
                if (rightCandidate == null || !Sets.union(rightCandidate, singleton).containsAll(rightSet)) continue;
                solid = false;
                break;
            }
            if (!solid) continue;
            solidDependencies.put(leftSet, rightSet);
        }
        return Collections.unmodifiableMap(solidDependencies);
    }

    public static <A> void includeDependency(Map<Set<A>, Set<A>> accumulator, Set<A> left, Set<A> right) {
        Set accumulatorRights = accumulator.computeIfAbsent(left, l -> new HashSet());
        accumulatorRights.addAll(right);
    }

    public static <A> void includeDependencies(Map<Set<A>, Set<A>> accumulator, Map<Set<A>, Set<A>> additionalDependencies) {
        for (Map.Entry<Set<A>, Set<A>> entry : additionalDependencies.entrySet()) {
            FunctionalDependencyHelper.includeDependency(accumulator, entry.getKey(), entry.getValue());
        }
    }
}

