/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.Solution;
import org.eclipse.viatra.dse.api.SolutionTrajectory;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.GlobalContext;
import org.eclipse.viatra.dse.designspace.api.DesignSpace;
import org.eclipse.viatra.dse.designspace.api.IDesignSpace;
import org.eclipse.viatra.dse.objectives.IGlobalConstraint;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.solutionstore.ISolutionNameProvider;
import org.eclipse.viatra.dse.solutionstore.IdBasedSolutionNameProvider;
import org.eclipse.viatra.dse.solutionstore.SolutionStore;
import org.eclipse.viatra.dse.statecode.IStateCoderFactory;
import org.eclipse.viatra.dse.statecoding.simple.SimpleStateCoderFactory;
import org.eclipse.viatra.dse.visualizer.IDesignSpaceVisualizer;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class DesignSpaceExplorer {
    private Notifier model;
    private GlobalContext globalContext = new GlobalContext();
    private final Logger logger = Logger.getLogger(this.getClass());
    private Set<EPackage> metaModelPackages = new HashSet<EPackage>();
    private static final String MODEL_NOT_YET_GIVEN = "The starting model is not given yet. Please call the setInitialModel method first.";
    private boolean deepCopyModel;

    public DesignSpaceExplorer() {
        this.setDesignspace(new DesignSpace());
    }

    public void addMetaModelPackage(EPackage metaModelPackage) {
        this.metaModelPackages.add(metaModelPackage);
    }

    public void setInitialModel(Notifier model, boolean deepCopyModel) {
        this.model = model;
        this.deepCopyModel = deepCopyModel;
    }

    public void setInitialModel(Notifier model) {
        this.setInitialModel(model, true);
    }

    public void setInitialModelUncloned(Notifier model) {
        this.setInitialModel(model, false);
    }

    public void addTransformationRule(BatchTransformationRule<?, ?> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0);
        for (BatchTransformationRule<?, ?> rule2 : this.globalContext.getTransformations()) {
            if (!rule.getPrecondition().equals(rule2.getPrecondition())) continue;
            throw new DSEException("Two transformation rule (" + rule.getName() + "; " + rule2.getName() + ") uses the same LHS VIATRA Query pattern (" + rule.getPrecondition().getFullyQualifiedName() + "), which may lead to hash collision." + " Please wrap the pattern with an other pattern with the 'find' keyword (or duplicate the code), and use that for one of the rules LHS.");
        }
        this.globalContext.getTransformations().add(rule);
    }

    public void addGlobalConstraint(IGlobalConstraint constraint) {
        this.globalContext.getGlobalConstraints().add(constraint);
    }

    public void addObjective(IObjective objective) {
        for (IObjective o : this.globalContext.getObjectives()) {
            if (!o.getName().equals(objective.getName())) continue;
            throw new DSEException("Two objectives with the same name cannot be registered:" + o.getName());
        }
        this.globalContext.getObjectives().add(objective);
    }

    public final void setStateCoderFactory(IStateCoderFactory stateCoderFactory) {
        this.globalContext.setStateCoderFactory(stateCoderFactory);
    }

    public void setMaxNumberOfThreads(int maxNumberOfThreads) {
        this.globalContext.getThreadPool().setMaximumPoolSize(maxNumberOfThreads);
    }

    public final void setDesignspace(IDesignSpace designspace) {
        this.globalContext.setDesignSpace(designspace);
    }

    public void setSolutionStore(SolutionStore solutionStore) {
        this.globalContext.setSolutionStore(solutionStore);
    }

    public void startExploration(IStrategy strategy) {
        this.startExploration(strategy, true, -1L);
    }

    public void startExplorationAsync(IStrategy strategy) {
        this.startExploration(strategy, false, -1L);
    }

    public boolean startExplorationWithTimeout(IStrategy strategy, long timeout) {
        return this.startExploration(strategy, true, timeout);
    }

    public boolean startExplorationAsyncWithTimeout(IStrategy strategy, long timeout) {
        return this.startExploration(strategy, false, timeout);
    }

    public boolean startExploration(IStrategy strategy, boolean waitForTermination, long timeout) {
        this.initExploration(strategy);
        Timer timer = new Timer();
        final AtomicBoolean wasTimeout = new AtomicBoolean(false);
        if (timeout > 0L) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    DesignSpaceExplorer.this.logger.info((Object)"Timeout, stopping threads...");
                    DesignSpaceExplorer.this.globalContext.stopAllThreads();
                    wasTimeout.set(true);
                }
            };
            timer.schedule(timerTask, timeout);
        }
        if (waitForTermination) {
            this.waitForTerminaition();
            timer.cancel();
        } else {
            this.logger.info((Object)"Design space exploration started asynchronously.");
        }
        return wasTimeout.get();
    }

    private void initExploration(IStrategy strategy) {
        Preconditions.checkArgument((this.model != null ? 1 : 0) != 0, (String)MODEL_NOT_YET_GIVEN);
        Preconditions.checkArgument((strategy != null ? 1 : 0) != 0, (String)"A strategy must be given. Use the Strategies helper class.");
        Preconditions.checkState((!this.globalContext.getTransformations().isEmpty() ? 1 : 0) != 0, (String)"At least one transformation rule must be added to start the exploration.");
        if (this.globalContext.getStateCoderFactory() == null) {
            if (this.getMetaModelPackages() == null || this.getMetaModelPackages().isEmpty()) {
                throw new DSEException("Cannot initialize state coder. Please specifiy the EPackages your model uses with addMetaModelPackage(EPackage)");
            }
            this.globalContext.setStateCoderFactory(new SimpleStateCoderFactory(this.getMetaModelPackages()));
        }
        this.logger.info((Object)"DesignSpaceExplorer started exploration.");
        if (this.deepCopyModel) {
            this.globalContext.startFirstThread(strategy, this.model);
        } else {
            this.globalContext.startFirstThreadWithoutModelClone(strategy, this.model);
        }
    }

    public Collection<Solution> getSolutions() {
        return this.globalContext.getSolutionStore().getSolutions();
    }

    public SolutionTrajectory getArbitrarySolution() {
        Collection<Solution> solutions = this.getSolutions();
        if (solutions.isEmpty()) {
            return null;
        }
        return solutions.iterator().next().getArbitraryTrajectory();
    }

    public long getNumberOfStates() {
        return this.globalContext.getDesignSpace().getNumberOfStates();
    }

    public long getNumberOfTransitions() {
        return this.globalContext.getDesignSpace().getNumberOfTransitions();
    }

    public Set<EPackage> getMetaModelPackages() {
        return this.metaModelPackages;
    }

    public boolean isDone() {
        return this.globalContext.isDone();
    }

    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }

    public void addDesignSpaceVisulaizer(IDesignSpaceVisualizer visualizer) {
        this.globalContext.registerDesignSpaceVisualizer(visualizer);
    }

    public String toStringSolutions() {
        StringBuilder sb = new StringBuilder();
        Collection<Solution> solutions = this.getSolutions();
        sb.append("Number of solutions: ");
        sb.append(solutions.size());
        sb.append("\n");
        for (Solution solution : solutions) {
            sb.append("Solution: ");
            sb.append(solution.getStateCode());
            sb.append("\n");
            for (SolutionTrajectory trajectory : solution.getTrajectories()) {
                sb.append("  ");
                sb.append(trajectory.toPrettyString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this.globalContext.setConflictResolver(conflictResolver);
    }

    public static void turnOnLogging(DseLoggingLevel dseLoggingLevel) {
        switch (dseLoggingLevel) {
            case OFF: {
                Logger.getLogger(DesignSpaceExplorer.class).setLevel(Level.OFF);
                Logger.getLogger(IStrategy.class).setLevel(Level.OFF);
                Logger.getLogger(DesignSpaceManager.class).setLevel(Level.OFF);
                break;
            }
            case WARN: {
                Logger.getLogger(DesignSpaceExplorer.class).setLevel(Level.WARN);
                Logger.getLogger(IStrategy.class).setLevel(Level.WARN);
                Logger.getLogger(DesignSpaceManager.class).setLevel(Level.WARN);
                break;
            }
            case BASIC: {
                Logger.getLogger(DesignSpaceExplorer.class).setLevel(Level.INFO);
                Logger.getLogger(IStrategy.class).setLevel(Level.INFO);
                Logger.getLogger(DesignSpaceManager.class).setLevel(Level.WARN);
                break;
            }
            case VERBOSE_STRATEGY: {
                Logger.getLogger(DesignSpaceExplorer.class).setLevel(Level.DEBUG);
                Logger.getLogger(IStrategy.class).setLevel(Level.DEBUG);
                Logger.getLogger(DesignSpaceManager.class).setLevel(Level.WARN);
                break;
            }
            case VERBOSE_FULL: {
                Logger.getLogger(DesignSpaceExplorer.class).setLevel(Level.DEBUG);
                Logger.getLogger(IStrategy.class).setLevel(Level.DEBUG);
                Logger.getLogger(DesignSpaceManager.class).setLevel(Level.DEBUG);
                break;
            }
            default: {
                throw new DSEException("Not supported logging level.");
            }
        }
    }

    public static void turnOnLoggingWithBasicConfig(DseLoggingLevel dseLoggingLevel) {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
        DesignSpaceExplorer.turnOnLogging(dseLoggingLevel);
    }

    public void stopExploration() {
        if (this.globalContext.isDone()) {
            this.logger.info((Object)"Cannot stop exploration - design space exploration has already finished.");
        } else if (this.globalContext.isNotStarted()) {
            this.logger.info((Object)"Cannot stop exploration - design space exploration has not been started.");
        } else {
            this.globalContext.stopAllThreads();
            this.waitForTerminaition();
        }
    }

    public void stopExplorationAsync() {
        if (this.globalContext.isDone()) {
            this.logger.info((Object)"Cannot stop exploration - design space exploration has already finished.");
        } else if (this.globalContext.isNotStarted()) {
            this.logger.info((Object)"Cannot stop exploration - design space exploration has not been started.");
        } else {
            this.globalContext.stopAllThreads();
        }
    }

    public void waitForTerminaition() {
        this.globalContext.waitForTermination();
    }

    public void saveModels(Notifier model) {
        this.saveModels(model, "solution", "xmi");
    }

    public void saveModels(Notifier model, String extension) {
        this.saveModels(model, "solution", extension);
    }

    public void saveModels(Notifier model, String fileNamePrefix, String extension) {
        this.globalContext.getSolutionStore().saveModels(model, new IdBasedSolutionNameProvider(fileNamePrefix, extension));
    }

    public void saveModels(Notifier model, ISolutionNameProvider solutionNameProvider) {
        this.globalContext.getSolutionStore().saveModels(model, solutionNameProvider);
    }

    public static enum DseLoggingLevel {
        OFF,
        WARN,
        BASIC,
        VERBOSE_STRATEGY,
        VERBOSE_FULL;

    }
}

