/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.sirius.handlers;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.diagram.business.internal.metamodel.spec.DSemanticDiagramSpec;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PatternPackage;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;

public class LoadVgqlPatternHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        IViewPart resultView = HandlerUtil.getActiveSite((ExecutionEvent)event).getPage().findView("org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView");
        if (resultView instanceof QueryResultView) {
            boolean active = ((QueryResultView)resultView).hasActiveEngine();
            if (active && editorPart instanceof DiagramDocumentEditor) {
                DiagramDocumentEditor xtextEditor = (DiagramDocumentEditor)editorPart;
                Diagram model = (Diagram)xtextEditor.getDiagramEditPart().getModel();
                DSemanticDiagramSpec element = (DSemanticDiagramSpec)model.getElement();
                PatternPackage pkg = (PatternPackage)element.getTarget();
                URI uri = pkg.eResource().getURI();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1));
                String sourceId = "dynamic:" + project.getName();
                Set patternFQNs = pkg.getPatterns().stream().map(p -> String.valueOf(pkg.getPackageName()) + "." + p.getName()).collect(Collectors.toSet());
                ((QueryResultView)resultView).loadQueriesIntoActiveEngineInBackground(patternFQNs, sourceId);
            } else {
                MessageDialog.openError((Shell)((QueryResultView)resultView).getSite().getShell(), (String)"Query loading failed", (String)"Please load a model into the Query Results view before loading queries!");
            }
        }
        return null;
    }
}

