/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.List;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.IndexerListener;
import org.eclipse.viatra.query.runtime.rete.network.BaseNode;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public abstract class StandardIndexer
extends BaseNode
implements Indexer,
NetworkStructureChangeSensitiveNode {
    protected Supplier parent = null;
    private final List<IndexerListener> originalListeners;
    private final List<IndexerListener> proxyListeners;
    protected TupleMask mask;

    public StandardIndexer(ReteContainer reteContainer, TupleMask mask) {
        super(reteContainer);
        this.mask = mask;
        this.originalListeners = CollectionsFactory.createObserverList();
        this.proxyListeners = CollectionsFactory.createObserverList();
    }

    protected void propagate(Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
        for (IndexerListener listener : this.proxyListeners) {
            listener.notifyIndexerUpdate(direction, updateElement, signature, change, timestamp);
        }
    }

    @Override
    public TupleMask getMask() {
        return this.mask;
    }

    @Override
    public Supplier getParent() {
        return this.parent;
    }

    @Override
    public void attachListener(IndexerListener listener) {
        this.getCommunicationTracker().registerDependency(this, listener.getOwner());
        IndexerListener proxy = this.getCommunicationTracker().proxifyIndexerListener(this, listener);
        this.originalListeners.add(0, listener);
        this.proxyListeners.add(0, proxy);
    }

    @Override
    public void detachListener(IndexerListener listener) {
        this.originalListeners.remove(listener);
        IndexerListener listenerToRemove = null;
        for (IndexerListener proxyListener : this.proxyListeners) {
            if (proxyListener.getOwner() != listener.getOwner()) continue;
            listenerToRemove = proxyListener;
            break;
        }
        assert (listenerToRemove != null);
        this.proxyListeners.remove(listenerToRemove);
        this.getCommunicationTracker().unregisterDependency(this, listener.getOwner());
    }

    @Override
    public void networkStructureChanged() {
        this.proxyListeners.clear();
        for (IndexerListener original : this.originalListeners) {
            this.proxyListeners.add(this.getCommunicationTracker().proxifyIndexerListener(this, original));
        }
    }

    @Override
    public Collection<IndexerListener> getListeners() {
        return this.proxyListeners;
    }

    @Override
    public ReteContainer getContainer() {
        return this.reteContainer;
    }

    @Override
    protected String toStringCore() {
        return super.toStringCore() + "(" + String.valueOf(this.parent) + "/" + String.valueOf(this.mask) + ")";
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateFromIndexerToSupplierParent() && this.parent != null) {
            this.parent.acceptPropagatedTraceInfo(traceInfo);
        }
    }
}

