/**
 * 
 *   Copyright (c) 2010-2013, Abel Hegedus, Zoltan Ujhelyi, Denes Harmath, Istvan Rath and Daniel Varro, IncQuery Labs Ltd.
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.integration.uml.derivedfeatures;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecificationWithGenericMatcher;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

/**
 * A pattern-specific query specification that can instantiate GenericPatternMatcher in a type-safe way.
 * 
 * <p>Original source:
 *         <code><pre>
 *         (ownedAttribute-{@literal >}select(oclIsKindOf(Port))-{@literal >}collect(oclAsType(Port))-{@literal >}asOrderedSet())
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: asOrderedSet
 *         //{@literal @}Surrogate(feature = "ownedPort")
 *         //{@literal @}QueryExplorer(checked = false)
 *         //pattern encapsulatedClassifierOwnedPort(source: EncapsulatedClassifier, target: Port) {}
 *         
 *         
 *         (ownedEnd.lowerBound() = 1)
 *         
 *         // Can't compile OCL to VIATRA Query because of org.eclipse.ocl.SemanticException: Cannot find operation (=(Integer)) for the type (Sequence(Integer))
 *         //{@literal @}Surrogate(feature = "isRequired")
 *         //pattern extensionIsRequired(source: Extension, target: Boolean) {}
 *         
 *         
 *         (metaclassEnd().type.oclAsType(Class))
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: metaclassEnd
 *         //{@literal @}Surrogate(feature = "metaclass")
 *         //pattern extensionMetaclass(source: Extension, target: Class) {}
 *         
 *         
 *         (lowerBound())
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: lowerBound
 *         //{@literal @}Surrogate(feature = "lower")
 *         //pattern multiplicityElementLower(source: MultiplicityElement, target: Integer) {}
 *         
 *         
 *         (upperBound())
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: upperBound
 *         //{@literal @}Surrogate(feature = "upper")
 *         //pattern multiplicityElementUpper(source: MultiplicityElement, target: UnlimitedNatural) {}
 *         
 *         
 *         (Dependency.allInstances()-{@literal >}select(d | d.client-{@literal >}includes(self)))
 *         
 *         {@literal @}Surrogate(feature = "clientDependency")
 *         pattern namedElementClientDependency(
 *             self : NamedElement,
 *             d : Dependency
 *         ) {
 *             Dependency.client(d, namedElement);
 *             namedElement == self;
 *             Dependency(dependency);
 *             d == dependency;
 *         }
 * </pre></code>
 * 
 * @see GenericPatternMatcher
 * @see GenericPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class NamedElementClientDependency extends BaseGeneratedEMFQuerySpecificationWithGenericMatcher {
  private NamedElementClientDependency() {
    super(GeneratedPQuery.INSTANCE);
  }

  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
   * 
   */
  public static NamedElementClientDependency instance() {
    try{
        return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
        throw processInitializerError(err);
    }
  }

  /**
   * Inner class allowing the singleton instance of {@link NamedElementClientDependency} to be created 
   *     <b>not</b> at the class load time of the outer class, 
   *     but rather at the first call to {@link NamedElementClientDependency#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private static final NamedElementClientDependency INSTANCE = new NamedElementClientDependency();

    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private static final Object STATIC_INITIALIZER = ensureInitialized();

    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternal();
      return null;
    }
  }

  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private static final NamedElementClientDependency.GeneratedPQuery INSTANCE = new GeneratedPQuery();

    private final PParameter parameter_self = new PParameter("self", "org.eclipse.uml2.uml.NamedElement", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")), PParameterDirection.INOUT);

    private final PParameter parameter_d = new PParameter("d", "org.eclipse.uml2.uml.Dependency", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency")), PParameterDirection.INOUT);

    private final List<PParameter> parameters = Arrays.asList(parameter_self, parameter_d);

    private GeneratedPQuery() {
      super(PVisibility.PUBLIC);
    }

    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.integration.uml.derivedfeatures.namedElementClientDependency";
    }

    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","d");
    }

    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }

    @Override
    public Set<PBody> doGetContainedBodies() {
      setEvaluationHints(new QueryEvaluationHint(null, QueryEvaluationHint.BackendRequirement.UNSPECIFIED));
      Set<PBody> bodies = new LinkedHashSet<>();
      {
          PBody body = new PBody(this);
          PVariable var_self = body.getOrCreateVariableByName("self");
          PVariable var_d = body.getOrCreateVariableByName("d");
          PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
          PVariable var_dependency = body.getOrCreateVariableByName("dependency");
          new TypeConstraint(body, Tuples.flatTupleOf(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_d), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_self, parameter_self),
             new ExportedParameter(body, var_d, parameter_d)
          ));
          //     Dependency.client(d, namedElement)
          new TypeConstraint(body, Tuples.flatTupleOf(var_d), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_d, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency", "client")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
          new Equality(body, var__virtual_0_, var_namedElement);
          //     namedElement == self
          new Equality(body, var_namedElement, var_self);
          //     Dependency(dependency)
          new TypeConstraint(body, Tuples.flatTupleOf(var_dependency), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency")));
          //     d == dependency
          new Equality(body, var_d, var_dependency);
          bodies.add(body);
      }
      {
          PAnnotation annotation = new PAnnotation("Surrogate");
          annotation.addAttribute("feature", "clientDependency");
          addAnnotation(annotation);
      }
      return bodies;
    }
  }
}
