/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.xtext.xtype.XtypePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguageFactory
 * @model kind="package"
 * @generated
 */
public interface PatternLanguagePackage extends EPackage
{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "vql";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/viatra/query/patternlanguage/emf/PatternLanguage";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "PatternLanguage";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	PatternLanguagePackage eINSTANCE = org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VQLImportSectionImpl <em>VQL Import Section</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VQLImportSectionImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getVQLImportSection()
	 * @generated
	 */
	int VQL_IMPORT_SECTION = 0;

	/**
	 * The feature id for the '<em><b>Import Declarations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VQL_IMPORT_SECTION__IMPORT_DECLARATIONS = XtypePackage.XIMPORT_SECTION__IMPORT_DECLARATIONS;

	/**
	 * The feature id for the '<em><b>Package Import</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VQL_IMPORT_SECTION__PACKAGE_IMPORT = XtypePackage.XIMPORT_SECTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pattern Import</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VQL_IMPORT_SECTION__PATTERN_IMPORT = XtypePackage.XIMPORT_SECTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>VQL Import Section</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VQL_IMPORT_SECTION_FEATURE_COUNT = XtypePackage.XIMPORT_SECTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PackageImportImpl <em>Package Import</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PackageImportImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPackageImport()
	 * @generated
	 */
	int PACKAGE_IMPORT = 1;

	/**
	 * The feature id for the '<em><b>EPackage</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT__EPACKAGE = 0;

	/**
	 * The feature id for the '<em><b>Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT__ALIAS = 1;

	/**
	 * The number of structural features of the '<em>Package Import</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternImportImpl <em>Pattern Import</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternImportImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternImport()
	 * @generated
	 */
	int PATTERN_IMPORT = 2;

	/**
	 * The feature id for the '<em><b>Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_IMPORT__PATTERN = 0;

	/**
	 * The feature id for the '<em><b>Package Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_IMPORT__PACKAGE_NAME = 1;

	/**
	 * The feature id for the '<em><b>Patterns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_IMPORT__PATTERNS = 2;

	/**
	 * The number of structural features of the '<em>Pattern Import</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_IMPORT_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ConstraintImpl <em>Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ConstraintImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getConstraint()
	 * @generated
	 */
	int CONSTRAINT = 18;

	/**
	 * The number of structural features of the '<em>Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EClassifierConstraintImpl <em>EClassifier Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EClassifierConstraintImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getEClassifierConstraint()
	 * @generated
	 */
	int ECLASSIFIER_CONSTRAINT = 3;

	/**
	 * The feature id for the '<em><b>Transitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASSIFIER_CONSTRAINT__TRANSITIVE = CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASSIFIER_CONSTRAINT__TYPE = CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Var</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASSIFIER_CONSTRAINT__VAR = CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>EClassifier Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASSIFIER_CONSTRAINT_FEATURE_COUNT = CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ExpressionImpl <em>Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ExpressionImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getExpression()
	 * @generated
	 */
	int EXPRESSION = 12;

	/**
	 * The number of structural features of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ValueReferenceImpl <em>Value Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ValueReferenceImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getValueReference()
	 * @generated
	 */
	int VALUE_REFERENCE = 20;

	/**
	 * The number of structural features of the '<em>Value Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_REFERENCE_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EnumValueImpl <em>Enum Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EnumValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getEnumValue()
	 * @generated
	 */
	int ENUM_VALUE = 4;

	/**
	 * The feature id for the '<em><b>Enumeration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_VALUE__ENUMERATION = VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Literal</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_VALUE__LITERAL = VALUE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Enum Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_VALUE_FEATURE_COUNT = VALUE_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternModelImpl <em>Pattern Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternModelImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternModel()
	 * @generated
	 */
	int PATTERN_MODEL = 5;

	/**
	 * The feature id for the '<em><b>Import Packages</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_MODEL__IMPORT_PACKAGES = 0;

	/**
	 * The feature id for the '<em><b>Package Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_MODEL__PACKAGE_NAME = 1;

	/**
	 * The feature id for the '<em><b>Patterns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_MODEL__PATTERNS = 2;

	/**
	 * The number of structural features of the '<em>Pattern Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_MODEL_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.TypeImpl <em>Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.TypeImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getType()
	 * @generated
	 */
	int TYPE = 15;

	/**
	 * The feature id for the '<em><b>Typename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE__TYPENAME = 0;

	/**
	 * The number of structural features of the '<em>Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EntityTypeImpl <em>Entity Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EntityTypeImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getEntityType()
	 * @generated
	 */
	int ENTITY_TYPE = 16;

	/**
	 * The feature id for the '<em><b>Typename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_TYPE__TYPENAME = TYPE__TYPENAME;

	/**
	 * The number of structural features of the '<em>Entity Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_TYPE_FEATURE_COUNT = TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ClassTypeImpl <em>Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ClassTypeImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getClassType()
	 * @generated
	 */
	int CLASS_TYPE = 6;

	/**
	 * The feature id for the '<em><b>Typename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_TYPE__TYPENAME = ENTITY_TYPE__TYPENAME;

	/**
	 * The feature id for the '<em><b>Metamodel</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_TYPE__METAMODEL = ENTITY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Classname</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_TYPE__CLASSNAME = ENTITY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Class Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_TYPE_FEATURE_COUNT = ENTITY_TYPE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.RelationTypeImpl <em>Relation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.RelationTypeImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getRelationType()
	 * @generated
	 */
	int RELATION_TYPE = 27;

	/**
	 * The feature id for the '<em><b>Typename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATION_TYPE__TYPENAME = TYPE__TYPENAME;

	/**
	 * The number of structural features of the '<em>Relation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATION_TYPE_FEATURE_COUNT = TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ReferenceTypeImpl <em>Reference Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ReferenceTypeImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getReferenceType()
	 * @generated
	 */
	int REFERENCE_TYPE = 7;

	/**
	 * The feature id for the '<em><b>Typename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__TYPENAME = RELATION_TYPE__TYPENAME;

	/**
	 * The feature id for the '<em><b>Refname</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__REFNAME = RELATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reference Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE_FEATURE_COUNT = RELATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternImpl <em>Pattern</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPattern()
	 * @generated
	 */
	int PATTERN = 8;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN__ANNOTATIONS = 0;

	/**
	 * The feature id for the '<em><b>Modifiers</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN__MODIFIERS = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN__NAME = 2;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN__PARAMETERS = 3;

	/**
	 * The feature id for the '<em><b>Bodies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN__BODIES = 4;

	/**
	 * The number of structural features of the '<em>Pattern</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AnnotationImpl <em>Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AnnotationImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getAnnotation()
	 * @generated
	 */
	int ANNOTATION = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__NAME = 0;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__PARAMETERS = 1;

	/**
	 * The number of structural features of the '<em>Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AnnotationParameterImpl <em>Annotation Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AnnotationParameterImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getAnnotationParameter()
	 * @generated
	 */
	int ANNOTATION_PARAMETER = 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_PARAMETER__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_PARAMETER__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Annotation Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_PARAMETER_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ModifiersImpl <em>Modifiers</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ModifiersImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getModifiers()
	 * @generated
	 */
	int MODIFIERS = 11;

	/**
	 * The feature id for the '<em><b>Private</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIERS__PRIVATE = 0;

	/**
	 * The feature id for the '<em><b>Execution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIERS__EXECUTION = 1;

	/**
	 * The number of structural features of the '<em>Modifiers</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIERS_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VariableImpl <em>Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VariableImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getVariable()
	 * @generated
	 */
	int VARIABLE = 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__NAME = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__TYPE = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VariableReferenceImpl <em>Variable Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VariableReferenceImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getVariableReference()
	 * @generated
	 */
	int VARIABLE_REFERENCE = 14;

	/**
	 * The feature id for the '<em><b>Aggregator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_REFERENCE__AGGREGATOR = VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Var</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_REFERENCE__VAR = VALUE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_REFERENCE__VARIABLE = VALUE_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Variable Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_REFERENCE_FEATURE_COUNT = VALUE_REFERENCE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternBodyImpl <em>Pattern Body</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternBodyImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternBody()
	 * @generated
	 */
	int PATTERN_BODY = 17;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_BODY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_BODY__CONSTRAINTS = 1;

	/**
	 * The feature id for the '<em><b>Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_BODY__VARIABLES = 2;

	/**
	 * The number of structural features of the '<em>Pattern Body</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_BODY_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CallableRelationImpl <em>Callable Relation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CallableRelationImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getCallableRelation()
	 * @generated
	 */
	int CALLABLE_RELATION = 39;

	/**
	 * The feature id for the '<em><b>Transitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALLABLE_RELATION__TRANSITIVE = 0;

	/**
	 * The number of structural features of the '<em>Callable Relation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALLABLE_RELATION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternCallImpl <em>Pattern Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternCallImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternCall()
	 * @generated
	 */
	int PATTERN_CALL = 19;

	/**
	 * The feature id for the '<em><b>Transitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_CALL__TRANSITIVE = CALLABLE_RELATION__TRANSITIVE;

	/**
	 * The feature id for the '<em><b>Pattern Ref</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_CALL__PATTERN_REF = CALLABLE_RELATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_CALL__PARAMETERS = CALLABLE_RELATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Pattern Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_CALL_FEATURE_COUNT = CALLABLE_RELATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.LiteralValueReferenceImpl <em>Literal Value Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.LiteralValueReferenceImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getLiteralValueReference()
	 * @generated
	 */
	int LITERAL_VALUE_REFERENCE = 21;

	/**
	 * The number of structural features of the '<em>Literal Value Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE_FEATURE_COUNT = VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ComputationValueImpl <em>Computation Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ComputationValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getComputationValue()
	 * @generated
	 */
	int COMPUTATION_VALUE = 22;

	/**
	 * The number of structural features of the '<em>Computation Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_VALUE_FEATURE_COUNT = VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ParameterRefImpl <em>Parameter Ref</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ParameterRefImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getParameterRef()
	 * @generated
	 */
	int PARAMETER_REF = 23;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_REF__NAME = VARIABLE__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_REF__TYPE = VARIABLE__TYPE;

	/**
	 * The feature id for the '<em><b>Referred Param</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_REF__REFERRED_PARAM = VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Parameter Ref</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_REF_FEATURE_COUNT = VARIABLE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ParameterImpl <em>Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ParameterImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getParameter()
	 * @generated
	 */
	int PARAMETER = 24;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__NAME = VARIABLE__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__TYPE = VARIABLE__TYPE;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__DIRECTION = VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_FEATURE_COUNT = VARIABLE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.LocalVariableImpl <em>Local Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.LocalVariableImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getLocalVariable()
	 * @generated
	 */
	int LOCAL_VARIABLE = 25;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_VARIABLE__NAME = VARIABLE__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_VARIABLE__TYPE = VARIABLE__TYPE;

	/**
	 * The number of structural features of the '<em>Local Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_VARIABLE_FEATURE_COUNT = VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaTypeImpl <em>Java Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaTypeImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getJavaType()
	 * @generated
	 */
	int JAVA_TYPE = 26;

	/**
	 * The feature id for the '<em><b>Typename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_TYPE__TYPENAME = ENTITY_TYPE__TYPENAME;

	/**
	 * The feature id for the '<em><b>Class Ref</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_TYPE__CLASS_REF = ENTITY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Java Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_TYPE_FEATURE_COUNT = ENTITY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.TypeCheckConstraintImpl <em>Type Check Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.TypeCheckConstraintImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getTypeCheckConstraint()
	 * @generated
	 */
	int TYPE_CHECK_CONSTRAINT = 28;

	/**
	 * The feature id for the '<em><b>Transitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CHECK_CONSTRAINT__TRANSITIVE = CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CHECK_CONSTRAINT__TYPE = CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Var</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CHECK_CONSTRAINT__VAR = CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Type Check Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CHECK_CONSTRAINT_FEATURE_COUNT = CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternCompositionConstraintImpl <em>Pattern Composition Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternCompositionConstraintImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternCompositionConstraint()
	 * @generated
	 */
	int PATTERN_COMPOSITION_CONSTRAINT = 29;

	/**
	 * The feature id for the '<em><b>Negative</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_COMPOSITION_CONSTRAINT__NEGATIVE = CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_COMPOSITION_CONSTRAINT__CALL = CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Pattern Composition Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATTERN_COMPOSITION_CONSTRAINT_FEATURE_COUNT = CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CompareConstraintImpl <em>Compare Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CompareConstraintImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getCompareConstraint()
	 * @generated
	 */
	int COMPARE_CONSTRAINT = 30;

	/**
	 * The feature id for the '<em><b>Left Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_CONSTRAINT__LEFT_OPERAND = CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_CONSTRAINT__FEATURE = CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_CONSTRAINT__RIGHT_OPERAND = CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Compare Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_CONSTRAINT_FEATURE_COUNT = CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CheckConstraintImpl <em>Check Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CheckConstraintImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getCheckConstraint()
	 * @generated
	 */
	int CHECK_CONSTRAINT = 31;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_CONSTRAINT__EXPRESSION = CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Check Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_CONSTRAINT_FEATURE_COUNT = CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PathExpressionConstraintImpl <em>Path Expression Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PathExpressionConstraintImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPathExpressionConstraint()
	 * @generated
	 */
	int PATH_EXPRESSION_CONSTRAINT = 32;

	/**
	 * The feature id for the '<em><b>Transitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_CONSTRAINT__TRANSITIVE = CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Edge Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_CONSTRAINT__EDGE_TYPES = CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_CONSTRAINT__SOURCE_TYPE = CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Src</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_CONSTRAINT__SRC = CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Dst</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_CONSTRAINT__DST = CONSTRAINT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Path Expression Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_CONSTRAINT_FEATURE_COUNT = CONSTRAINT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.StringValueImpl <em>String Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.StringValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getStringValue()
	 * @generated
	 */
	int STRING_VALUE = 33;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_VALUE__VALUE = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_VALUE_FEATURE_COUNT = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.NumberValueImpl <em>Number Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.NumberValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getNumberValue()
	 * @generated
	 */
	int NUMBER_VALUE = 34;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMBER_VALUE__VALUE = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Negative</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMBER_VALUE__NEGATIVE = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Number Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMBER_VALUE_FEATURE_COUNT = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.BoolValueImpl <em>Bool Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.BoolValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getBoolValue()
	 * @generated
	 */
	int BOOL_VALUE = 35;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_VALUE__VALUE = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Bool Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_VALUE_FEATURE_COUNT = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ListValueImpl <em>List Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ListValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getListValue()
	 * @generated
	 */
	int LIST_VALUE = 36;

	/**
	 * The feature id for the '<em><b>Values</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_VALUE__VALUES = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>List Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_VALUE_FEATURE_COUNT = LITERAL_VALUE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.FunctionEvaluationValueImpl <em>Function Evaluation Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.FunctionEvaluationValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getFunctionEvaluationValue()
	 * @generated
	 */
	int FUNCTION_EVALUATION_VALUE = 37;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_EVALUATION_VALUE__EXPRESSION = COMPUTATION_VALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unwind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_EVALUATION_VALUE__UNWIND = COMPUTATION_VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Function Evaluation Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_EVALUATION_VALUE_FEATURE_COUNT = COMPUTATION_VALUE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AggregatedValueImpl <em>Aggregated Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AggregatedValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getAggregatedValue()
	 * @generated
	 */
	int AGGREGATED_VALUE = 38;

	/**
	 * The feature id for the '<em><b>Aggregator</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATED_VALUE__AGGREGATOR = COMPUTATION_VALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATED_VALUE__CALL = COMPUTATION_VALUE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregate Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATED_VALUE__AGGREGATE_TYPE = COMPUTATION_VALUE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Aggregated Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATED_VALUE_FEATURE_COUNT = COMPUTATION_VALUE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.UnaryTypeConstraintImpl <em>Unary Type Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.UnaryTypeConstraintImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getUnaryTypeConstraint()
	 * @generated
	 */
	int UNARY_TYPE_CONSTRAINT = 40;

	/**
	 * The feature id for the '<em><b>Transitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_TYPE_CONSTRAINT__TRANSITIVE = CALLABLE_RELATION__TRANSITIVE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_TYPE_CONSTRAINT__TYPE = CALLABLE_RELATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Var</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_TYPE_CONSTRAINT__VAR = CALLABLE_RELATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Unary Type Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_TYPE_CONSTRAINT_FEATURE_COUNT = CALLABLE_RELATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaConstantValueImpl <em>Java Constant Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaConstantValueImpl
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getJavaConstantValue()
	 * @generated
	 */
	int JAVA_CONSTANT_VALUE = 41;

	/**
	 * The feature id for the '<em><b>Class Ref</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_CONSTANT_VALUE__CLASS_REF = VALUE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Field Ref</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_CONSTANT_VALUE__FIELD_REF = VALUE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Java Constant Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_CONSTANT_VALUE_FEATURE_COUNT = VALUE_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ExecutionType <em>Execution Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ExecutionType
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getExecutionType()
	 * @generated
	 */
	int EXECUTION_TYPE = 42;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterDirection <em>Parameter Direction</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterDirection
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getParameterDirection()
	 * @generated
	 */
	int PARAMETER_DIRECTION = 43;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CompareFeature <em>Compare Feature</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CompareFeature
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getCompareFeature()
	 * @generated
	 */
	int COMPARE_FEATURE = 44;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ClosureType <em>Closure Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ClosureType
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getClosureType()
	 * @generated
	 */
	int CLOSURE_TYPE = 45;


	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection <em>VQL Import Section</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>VQL Import Section</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection
	 * @generated
	 */
	EClass getVQLImportSection();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection#getPackageImport <em>Package Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Package Import</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection#getPackageImport()
	 * @see #getVQLImportSection()
	 * @generated
	 */
	EReference getVQLImportSection_PackageImport();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection#getPatternImport <em>Pattern Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Pattern Import</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection#getPatternImport()
	 * @see #getVQLImportSection()
	 * @generated
	 */
	EReference getVQLImportSection_PatternImport();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport <em>Package Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Package Import</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport
	 * @generated
	 */
	EClass getPackageImport();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport#getEPackage <em>EPackage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>EPackage</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport#getEPackage()
	 * @see #getPackageImport()
	 * @generated
	 */
	EReference getPackageImport_EPackage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport#getAlias <em>Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alias</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport#getAlias()
	 * @see #getPackageImport()
	 * @generated
	 */
	EAttribute getPackageImport_Alias();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport <em>Pattern Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pattern Import</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport
	 * @generated
	 */
	EClass getPatternImport();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport#getPattern <em>Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Pattern</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport#getPattern()
	 * @see #getPatternImport()
	 * @generated
	 */
	EReference getPatternImport_Pattern();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport#getPackageName <em>Package Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Package Name</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport#getPackageName()
	 * @see #getPatternImport()
	 * @generated
	 */
	EAttribute getPatternImport_PackageName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport#getPatterns <em>Patterns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Patterns</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport#getPatterns()
	 * @see #getPatternImport()
	 * @generated
	 */
	EReference getPatternImport_Patterns();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.EClassifierConstraint <em>EClassifier Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EClassifier Constraint</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.EClassifierConstraint
	 * @generated
	 */
	EClass getEClassifierConstraint();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue <em>Enum Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enum Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue
	 * @generated
	 */
	EClass getEnumValue();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue#getEnumeration <em>Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Enumeration</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue#getEnumeration()
	 * @see #getEnumValue()
	 * @generated
	 */
	EReference getEnumValue_Enumeration();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue#getLiteral <em>Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Literal</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue#getLiteral()
	 * @see #getEnumValue()
	 * @generated
	 */
	EReference getEnumValue_Literal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel <em>Pattern Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pattern Model</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel
	 * @generated
	 */
	EClass getPatternModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel#getImportPackages <em>Import Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Import Packages</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel#getImportPackages()
	 * @see #getPatternModel()
	 * @generated
	 */
	EReference getPatternModel_ImportPackages();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel#getPackageName <em>Package Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Package Name</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel#getPackageName()
	 * @see #getPatternModel()
	 * @generated
	 */
	EAttribute getPatternModel_PackageName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel#getPatterns <em>Patterns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Patterns</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel#getPatterns()
	 * @see #getPatternModel()
	 * @generated
	 */
	EReference getPatternModel_Patterns();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType <em>Class Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Class Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType
	 * @generated
	 */
	EClass getClassType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType#getMetamodel <em>Metamodel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Metamodel</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType#getMetamodel()
	 * @see #getClassType()
	 * @generated
	 */
	EReference getClassType_Metamodel();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType#getClassname <em>Classname</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Classname</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType#getClassname()
	 * @see #getClassType()
	 * @generated
	 */
	EReference getClassType_Classname();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType <em>Reference Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType
	 * @generated
	 */
	EClass getReferenceType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType#getRefname <em>Refname</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Refname</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType#getRefname()
	 * @see #getReferenceType()
	 * @generated
	 */
	EReference getReferenceType_Refname();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern <em>Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pattern</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern
	 * @generated
	 */
	EClass getPattern();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getAnnotations()
	 * @see #getPattern()
	 * @generated
	 */
	EReference getPattern_Annotations();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getModifiers <em>Modifiers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Modifiers</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getModifiers()
	 * @see #getPattern()
	 * @generated
	 */
	EReference getPattern_Modifiers();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getName()
	 * @see #getPattern()
	 * @generated
	 */
	EAttribute getPattern_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getParameters()
	 * @see #getPattern()
	 * @generated
	 */
	EReference getPattern_Parameters();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getBodies <em>Bodies</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Bodies</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern#getBodies()
	 * @see #getPattern()
	 * @generated
	 */
	EReference getPattern_Bodies();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation
	 * @generated
	 */
	EClass getAnnotation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation#getName()
	 * @see #getAnnotation()
	 * @generated
	 */
	EAttribute getAnnotation_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation#getParameters()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_Parameters();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter <em>Annotation Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation Parameter</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter
	 * @generated
	 */
	EClass getAnnotationParameter();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter#getName()
	 * @see #getAnnotationParameter()
	 * @generated
	 */
	EAttribute getAnnotationParameter_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter#getValue()
	 * @see #getAnnotationParameter()
	 * @generated
	 */
	EReference getAnnotationParameter_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers <em>Modifiers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Modifiers</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers
	 * @generated
	 */
	EClass getModifiers();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers#isPrivate <em>Private</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Private</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers#isPrivate()
	 * @see #getModifiers()
	 * @generated
	 */
	EAttribute getModifiers_Private();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers#getExecution <em>Execution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Execution</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers#getExecution()
	 * @see #getModifiers()
	 * @generated
	 */
	EAttribute getModifiers_Execution();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expression</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Expression
	 * @generated
	 */
	EClass getExpression();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Variable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Variable
	 * @generated
	 */
	EClass getVariable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Variable#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Variable#getName()
	 * @see #getVariable()
	 * @generated
	 */
	EAttribute getVariable_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Variable#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Variable#getType()
	 * @see #getVariable()
	 * @generated
	 */
	EReference getVariable_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference <em>Variable Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable Reference</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference
	 * @generated
	 */
	EClass getVariableReference();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference#isAggregator <em>Aggregator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Aggregator</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference#isAggregator()
	 * @see #getVariableReference()
	 * @generated
	 */
	EAttribute getVariableReference_Aggregator();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference#getVar <em>Var</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Var</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference#getVar()
	 * @see #getVariableReference()
	 * @generated
	 */
	EAttribute getVariableReference_Var();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference#getVariable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Variable</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference#getVariable()
	 * @see #getVariableReference()
	 * @generated
	 */
	EReference getVariableReference_Variable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Type <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Type
	 * @generated
	 */
	EClass getType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Type#getTypename <em>Typename</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Typename</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Type#getTypename()
	 * @see #getType()
	 * @generated
	 */
	EAttribute getType_Typename();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.EntityType <em>Entity Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.EntityType
	 * @generated
	 */
	EClass getEntityType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody <em>Pattern Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pattern Body</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody
	 * @generated
	 */
	EClass getPatternBody();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody#getName()
	 * @see #getPatternBody()
	 * @generated
	 */
	EAttribute getPatternBody_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody#getConstraints <em>Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Constraints</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody#getConstraints()
	 * @see #getPatternBody()
	 * @generated
	 */
	EReference getPatternBody_Constraints();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody#getVariables <em>Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Variables</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody#getVariables()
	 * @see #getPatternBody()
	 * @generated
	 */
	EReference getPatternBody_Variables();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Constraint <em>Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constraint</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Constraint
	 * @generated
	 */
	EClass getConstraint();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall <em>Pattern Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pattern Call</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall
	 * @generated
	 */
	EClass getPatternCall();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall#getPatternRef <em>Pattern Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Pattern Ref</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall#getPatternRef()
	 * @see #getPatternCall()
	 * @generated
	 */
	EReference getPatternCall_PatternRef();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall#getParameters()
	 * @see #getPatternCall()
	 * @generated
	 */
	EReference getPatternCall_Parameters();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference <em>Value Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Value Reference</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference
	 * @generated
	 */
	EClass getValueReference();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.LiteralValueReference <em>Literal Value Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Literal Value Reference</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.LiteralValueReference
	 * @generated
	 */
	EClass getLiteralValueReference();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ComputationValue <em>Computation Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Computation Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ComputationValue
	 * @generated
	 */
	EClass getComputationValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterRef <em>Parameter Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter Ref</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterRef
	 * @generated
	 */
	EClass getParameterRef();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterRef#getReferredParam <em>Referred Param</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Referred Param</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterRef#getReferredParam()
	 * @see #getParameterRef()
	 * @generated
	 */
	EReference getParameterRef_ReferredParam();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter
	 * @generated
	 */
	EClass getParameter();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter#getDirection <em>Direction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Direction</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter#getDirection()
	 * @see #getParameter()
	 * @generated
	 */
	EAttribute getParameter_Direction();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.LocalVariable <em>Local Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Local Variable</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.LocalVariable
	 * @generated
	 */
	EClass getLocalVariable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.JavaType <em>Java Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Java Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.JavaType
	 * @generated
	 */
	EClass getJavaType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.JavaType#getClassRef <em>Class Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Class Ref</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.JavaType#getClassRef()
	 * @see #getJavaType()
	 * @generated
	 */
	EReference getJavaType_ClassRef();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.RelationType <em>Relation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Relation Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.RelationType
	 * @generated
	 */
	EClass getRelationType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.TypeCheckConstraint <em>Type Check Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Check Constraint</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.TypeCheckConstraint
	 * @generated
	 */
	EClass getTypeCheckConstraint();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint <em>Pattern Composition Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pattern Composition Constraint</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint
	 * @generated
	 */
	EClass getPatternCompositionConstraint();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint#isNegative <em>Negative</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Negative</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint#isNegative()
	 * @see #getPatternCompositionConstraint()
	 * @generated
	 */
	EAttribute getPatternCompositionConstraint_Negative();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint#getCall <em>Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Call</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint#getCall()
	 * @see #getPatternCompositionConstraint()
	 * @generated
	 */
	EReference getPatternCompositionConstraint_Call();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint <em>Compare Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Compare Constraint</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint
	 * @generated
	 */
	EClass getCompareConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint#getLeftOperand <em>Left Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left Operand</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint#getLeftOperand()
	 * @see #getCompareConstraint()
	 * @generated
	 */
	EReference getCompareConstraint_LeftOperand();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint#getFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Feature</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint#getFeature()
	 * @see #getCompareConstraint()
	 * @generated
	 */
	EAttribute getCompareConstraint_Feature();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint#getRightOperand <em>Right Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right Operand</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint#getRightOperand()
	 * @see #getCompareConstraint()
	 * @generated
	 */
	EReference getCompareConstraint_RightOperand();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CheckConstraint <em>Check Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Check Constraint</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CheckConstraint
	 * @generated
	 */
	EClass getCheckConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CheckConstraint#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CheckConstraint#getExpression()
	 * @see #getCheckConstraint()
	 * @generated
	 */
	EReference getCheckConstraint_Expression();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint <em>Path Expression Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Path Expression Constraint</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint
	 * @generated
	 */
	EClass getPathExpressionConstraint();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getEdgeTypes <em>Edge Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Edge Types</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getEdgeTypes()
	 * @see #getPathExpressionConstraint()
	 * @generated
	 */
	EReference getPathExpressionConstraint_EdgeTypes();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getSourceType <em>Source Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Source Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getSourceType()
	 * @see #getPathExpressionConstraint()
	 * @generated
	 */
	EReference getPathExpressionConstraint_SourceType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getSrc <em>Src</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Src</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getSrc()
	 * @see #getPathExpressionConstraint()
	 * @generated
	 */
	EReference getPathExpressionConstraint_Src();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getDst <em>Dst</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Dst</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getDst()
	 * @see #getPathExpressionConstraint()
	 * @generated
	 */
	EReference getPathExpressionConstraint_Dst();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue <em>String Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue
	 * @generated
	 */
	EClass getStringValue();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue#getValue()
	 * @see #getStringValue()
	 * @generated
	 */
	EAttribute getStringValue_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue <em>Number Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Number Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue
	 * @generated
	 */
	EClass getNumberValue();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue#getValue()
	 * @see #getNumberValue()
	 * @generated
	 */
	EReference getNumberValue_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue#isNegative <em>Negative</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Negative</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue#isNegative()
	 * @see #getNumberValue()
	 * @generated
	 */
	EAttribute getNumberValue_Negative();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.BoolValue <em>Bool Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bool Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.BoolValue
	 * @generated
	 */
	EClass getBoolValue();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.BoolValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.BoolValue#getValue()
	 * @see #getBoolValue()
	 * @generated
	 */
	EReference getBoolValue_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue <em>List Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>List Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue
	 * @generated
	 */
	EClass getListValue();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue#getValues <em>Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Values</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue#getValues()
	 * @see #getListValue()
	 * @generated
	 */
	EReference getListValue_Values();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue <em>Function Evaluation Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function Evaluation Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue
	 * @generated
	 */
	EClass getFunctionEvaluationValue();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue#getExpression()
	 * @see #getFunctionEvaluationValue()
	 * @generated
	 */
	EReference getFunctionEvaluationValue_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue#isUnwind <em>Unwind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unwind</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue#isUnwind()
	 * @see #getFunctionEvaluationValue()
	 * @generated
	 */
	EAttribute getFunctionEvaluationValue_Unwind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue <em>Aggregated Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Aggregated Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue
	 * @generated
	 */
	EClass getAggregatedValue();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getAggregator <em>Aggregator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Aggregator</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getAggregator()
	 * @see #getAggregatedValue()
	 * @generated
	 */
	EReference getAggregatedValue_Aggregator();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getCall <em>Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Call</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getCall()
	 * @see #getAggregatedValue()
	 * @generated
	 */
	EReference getAggregatedValue_Call();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getAggregateType <em>Aggregate Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Aggregate Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getAggregateType()
	 * @see #getAggregatedValue()
	 * @generated
	 */
	EReference getAggregatedValue_AggregateType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation <em>Callable Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Callable Relation</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation
	 * @generated
	 */
	EClass getCallableRelation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation#getTransitive <em>Transitive</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Transitive</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation#getTransitive()
	 * @see #getCallableRelation()
	 * @generated
	 */
	EAttribute getCallableRelation_Transitive();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint <em>Unary Type Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary Type Constraint</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint
	 * @generated
	 */
	EClass getUnaryTypeConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint#getType()
	 * @see #getUnaryTypeConstraint()
	 * @generated
	 */
	EReference getUnaryTypeConstraint_Type();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint#getVar <em>Var</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Var</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint#getVar()
	 * @see #getUnaryTypeConstraint()
	 * @generated
	 */
	EReference getUnaryTypeConstraint_Var();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.JavaConstantValue <em>Java Constant Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Java Constant Value</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.JavaConstantValue
	 * @generated
	 */
	EClass getJavaConstantValue();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.JavaConstantValue#getClassRef <em>Class Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Class Ref</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.JavaConstantValue#getClassRef()
	 * @see #getJavaConstantValue()
	 * @generated
	 */
	EReference getJavaConstantValue_ClassRef();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.JavaConstantValue#getFieldRef <em>Field Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Field Ref</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.JavaConstantValue#getFieldRef()
	 * @see #getJavaConstantValue()
	 * @generated
	 */
	EReference getJavaConstantValue_FieldRef();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ExecutionType <em>Execution Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Execution Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ExecutionType
	 * @generated
	 */
	EEnum getExecutionType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterDirection <em>Parameter Direction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Parameter Direction</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterDirection
	 * @generated
	 */
	EEnum getParameterDirection();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CompareFeature <em>Compare Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Compare Feature</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CompareFeature
	 * @generated
	 */
	EEnum getCompareFeature();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ClosureType <em>Closure Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Closure Type</em>'.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ClosureType
	 * @generated
	 */
	EEnum getClosureType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	PatternLanguageFactory getPatternLanguageFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals
	{
		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VQLImportSectionImpl <em>VQL Import Section</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VQLImportSectionImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getVQLImportSection()
		 * @generated
		 */
		EClass VQL_IMPORT_SECTION = eINSTANCE.getVQLImportSection();

		/**
		 * The meta object literal for the '<em><b>Package Import</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VQL_IMPORT_SECTION__PACKAGE_IMPORT = eINSTANCE.getVQLImportSection_PackageImport();

		/**
		 * The meta object literal for the '<em><b>Pattern Import</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VQL_IMPORT_SECTION__PATTERN_IMPORT = eINSTANCE.getVQLImportSection_PatternImport();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PackageImportImpl <em>Package Import</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PackageImportImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPackageImport()
		 * @generated
		 */
		EClass PACKAGE_IMPORT = eINSTANCE.getPackageImport();

		/**
		 * The meta object literal for the '<em><b>EPackage</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE_IMPORT__EPACKAGE = eINSTANCE.getPackageImport_EPackage();

		/**
		 * The meta object literal for the '<em><b>Alias</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PACKAGE_IMPORT__ALIAS = eINSTANCE.getPackageImport_Alias();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternImportImpl <em>Pattern Import</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternImportImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternImport()
		 * @generated
		 */
		EClass PATTERN_IMPORT = eINSTANCE.getPatternImport();

		/**
		 * The meta object literal for the '<em><b>Pattern</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_IMPORT__PATTERN = eINSTANCE.getPatternImport_Pattern();

		/**
		 * The meta object literal for the '<em><b>Package Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PATTERN_IMPORT__PACKAGE_NAME = eINSTANCE.getPatternImport_PackageName();

		/**
		 * The meta object literal for the '<em><b>Patterns</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_IMPORT__PATTERNS = eINSTANCE.getPatternImport_Patterns();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EClassifierConstraintImpl <em>EClassifier Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EClassifierConstraintImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getEClassifierConstraint()
		 * @generated
		 */
		EClass ECLASSIFIER_CONSTRAINT = eINSTANCE.getEClassifierConstraint();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EnumValueImpl <em>Enum Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EnumValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getEnumValue()
		 * @generated
		 */
		EClass ENUM_VALUE = eINSTANCE.getEnumValue();

		/**
		 * The meta object literal for the '<em><b>Enumeration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENUM_VALUE__ENUMERATION = eINSTANCE.getEnumValue_Enumeration();

		/**
		 * The meta object literal for the '<em><b>Literal</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENUM_VALUE__LITERAL = eINSTANCE.getEnumValue_Literal();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternModelImpl <em>Pattern Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternModelImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternModel()
		 * @generated
		 */
		EClass PATTERN_MODEL = eINSTANCE.getPatternModel();

		/**
		 * The meta object literal for the '<em><b>Import Packages</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_MODEL__IMPORT_PACKAGES = eINSTANCE.getPatternModel_ImportPackages();

		/**
		 * The meta object literal for the '<em><b>Package Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PATTERN_MODEL__PACKAGE_NAME = eINSTANCE.getPatternModel_PackageName();

		/**
		 * The meta object literal for the '<em><b>Patterns</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_MODEL__PATTERNS = eINSTANCE.getPatternModel_Patterns();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ClassTypeImpl <em>Class Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ClassTypeImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getClassType()
		 * @generated
		 */
		EClass CLASS_TYPE = eINSTANCE.getClassType();

		/**
		 * The meta object literal for the '<em><b>Metamodel</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS_TYPE__METAMODEL = eINSTANCE.getClassType_Metamodel();

		/**
		 * The meta object literal for the '<em><b>Classname</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS_TYPE__CLASSNAME = eINSTANCE.getClassType_Classname();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ReferenceTypeImpl <em>Reference Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ReferenceTypeImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getReferenceType()
		 * @generated
		 */
		EClass REFERENCE_TYPE = eINSTANCE.getReferenceType();

		/**
		 * The meta object literal for the '<em><b>Refname</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REFERENCE_TYPE__REFNAME = eINSTANCE.getReferenceType_Refname();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternImpl <em>Pattern</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPattern()
		 * @generated
		 */
		EClass PATTERN = eINSTANCE.getPattern();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN__ANNOTATIONS = eINSTANCE.getPattern_Annotations();

		/**
		 * The meta object literal for the '<em><b>Modifiers</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN__MODIFIERS = eINSTANCE.getPattern_Modifiers();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PATTERN__NAME = eINSTANCE.getPattern_Name();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN__PARAMETERS = eINSTANCE.getPattern_Parameters();

		/**
		 * The meta object literal for the '<em><b>Bodies</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN__BODIES = eINSTANCE.getPattern_Bodies();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AnnotationImpl <em>Annotation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AnnotationImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getAnnotation()
		 * @generated
		 */
		EClass ANNOTATION = eINSTANCE.getAnnotation();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION__NAME = eINSTANCE.getAnnotation_Name();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__PARAMETERS = eINSTANCE.getAnnotation_Parameters();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AnnotationParameterImpl <em>Annotation Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AnnotationParameterImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getAnnotationParameter()
		 * @generated
		 */
		EClass ANNOTATION_PARAMETER = eINSTANCE.getAnnotationParameter();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION_PARAMETER__NAME = eINSTANCE.getAnnotationParameter_Name();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION_PARAMETER__VALUE = eINSTANCE.getAnnotationParameter_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ModifiersImpl <em>Modifiers</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ModifiersImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getModifiers()
		 * @generated
		 */
		EClass MODIFIERS = eINSTANCE.getModifiers();

		/**
		 * The meta object literal for the '<em><b>Private</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MODIFIERS__PRIVATE = eINSTANCE.getModifiers_Private();

		/**
		 * The meta object literal for the '<em><b>Execution</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MODIFIERS__EXECUTION = eINSTANCE.getModifiers_Execution();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ExpressionImpl <em>Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ExpressionImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getExpression()
		 * @generated
		 */
		EClass EXPRESSION = eINSTANCE.getExpression();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VariableImpl <em>Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VariableImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getVariable()
		 * @generated
		 */
		EClass VARIABLE = eINSTANCE.getVariable();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VARIABLE__NAME = eINSTANCE.getVariable_Name();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE__TYPE = eINSTANCE.getVariable_Type();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VariableReferenceImpl <em>Variable Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.VariableReferenceImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getVariableReference()
		 * @generated
		 */
		EClass VARIABLE_REFERENCE = eINSTANCE.getVariableReference();

		/**
		 * The meta object literal for the '<em><b>Aggregator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VARIABLE_REFERENCE__AGGREGATOR = eINSTANCE.getVariableReference_Aggregator();

		/**
		 * The meta object literal for the '<em><b>Var</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VARIABLE_REFERENCE__VAR = eINSTANCE.getVariableReference_Var();

		/**
		 * The meta object literal for the '<em><b>Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE_REFERENCE__VARIABLE = eINSTANCE.getVariableReference_Variable();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.TypeImpl <em>Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.TypeImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getType()
		 * @generated
		 */
		EClass TYPE = eINSTANCE.getType();

		/**
		 * The meta object literal for the '<em><b>Typename</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TYPE__TYPENAME = eINSTANCE.getType_Typename();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EntityTypeImpl <em>Entity Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EntityTypeImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getEntityType()
		 * @generated
		 */
		EClass ENTITY_TYPE = eINSTANCE.getEntityType();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternBodyImpl <em>Pattern Body</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternBodyImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternBody()
		 * @generated
		 */
		EClass PATTERN_BODY = eINSTANCE.getPatternBody();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PATTERN_BODY__NAME = eINSTANCE.getPatternBody_Name();

		/**
		 * The meta object literal for the '<em><b>Constraints</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_BODY__CONSTRAINTS = eINSTANCE.getPatternBody_Constraints();

		/**
		 * The meta object literal for the '<em><b>Variables</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_BODY__VARIABLES = eINSTANCE.getPatternBody_Variables();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ConstraintImpl <em>Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ConstraintImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getConstraint()
		 * @generated
		 */
		EClass CONSTRAINT = eINSTANCE.getConstraint();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternCallImpl <em>Pattern Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternCallImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternCall()
		 * @generated
		 */
		EClass PATTERN_CALL = eINSTANCE.getPatternCall();

		/**
		 * The meta object literal for the '<em><b>Pattern Ref</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_CALL__PATTERN_REF = eINSTANCE.getPatternCall_PatternRef();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_CALL__PARAMETERS = eINSTANCE.getPatternCall_Parameters();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ValueReferenceImpl <em>Value Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ValueReferenceImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getValueReference()
		 * @generated
		 */
		EClass VALUE_REFERENCE = eINSTANCE.getValueReference();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.LiteralValueReferenceImpl <em>Literal Value Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.LiteralValueReferenceImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getLiteralValueReference()
		 * @generated
		 */
		EClass LITERAL_VALUE_REFERENCE = eINSTANCE.getLiteralValueReference();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ComputationValueImpl <em>Computation Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ComputationValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getComputationValue()
		 * @generated
		 */
		EClass COMPUTATION_VALUE = eINSTANCE.getComputationValue();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ParameterRefImpl <em>Parameter Ref</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ParameterRefImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getParameterRef()
		 * @generated
		 */
		EClass PARAMETER_REF = eINSTANCE.getParameterRef();

		/**
		 * The meta object literal for the '<em><b>Referred Param</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER_REF__REFERRED_PARAM = eINSTANCE.getParameterRef_ReferredParam();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ParameterImpl <em>Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ParameterImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getParameter()
		 * @generated
		 */
		EClass PARAMETER = eINSTANCE.getParameter();

		/**
		 * The meta object literal for the '<em><b>Direction</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARAMETER__DIRECTION = eINSTANCE.getParameter_Direction();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.LocalVariableImpl <em>Local Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.LocalVariableImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getLocalVariable()
		 * @generated
		 */
		EClass LOCAL_VARIABLE = eINSTANCE.getLocalVariable();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaTypeImpl <em>Java Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaTypeImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getJavaType()
		 * @generated
		 */
		EClass JAVA_TYPE = eINSTANCE.getJavaType();

		/**
		 * The meta object literal for the '<em><b>Class Ref</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JAVA_TYPE__CLASS_REF = eINSTANCE.getJavaType_ClassRef();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.RelationTypeImpl <em>Relation Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.RelationTypeImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getRelationType()
		 * @generated
		 */
		EClass RELATION_TYPE = eINSTANCE.getRelationType();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.TypeCheckConstraintImpl <em>Type Check Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.TypeCheckConstraintImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getTypeCheckConstraint()
		 * @generated
		 */
		EClass TYPE_CHECK_CONSTRAINT = eINSTANCE.getTypeCheckConstraint();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternCompositionConstraintImpl <em>Pattern Composition Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternCompositionConstraintImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPatternCompositionConstraint()
		 * @generated
		 */
		EClass PATTERN_COMPOSITION_CONSTRAINT = eINSTANCE.getPatternCompositionConstraint();

		/**
		 * The meta object literal for the '<em><b>Negative</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PATTERN_COMPOSITION_CONSTRAINT__NEGATIVE = eINSTANCE.getPatternCompositionConstraint_Negative();

		/**
		 * The meta object literal for the '<em><b>Call</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATTERN_COMPOSITION_CONSTRAINT__CALL = eINSTANCE.getPatternCompositionConstraint_Call();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CompareConstraintImpl <em>Compare Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CompareConstraintImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getCompareConstraint()
		 * @generated
		 */
		EClass COMPARE_CONSTRAINT = eINSTANCE.getCompareConstraint();

		/**
		 * The meta object literal for the '<em><b>Left Operand</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPARE_CONSTRAINT__LEFT_OPERAND = eINSTANCE.getCompareConstraint_LeftOperand();

		/**
		 * The meta object literal for the '<em><b>Feature</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPARE_CONSTRAINT__FEATURE = eINSTANCE.getCompareConstraint_Feature();

		/**
		 * The meta object literal for the '<em><b>Right Operand</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPARE_CONSTRAINT__RIGHT_OPERAND = eINSTANCE.getCompareConstraint_RightOperand();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CheckConstraintImpl <em>Check Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CheckConstraintImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getCheckConstraint()
		 * @generated
		 */
		EClass CHECK_CONSTRAINT = eINSTANCE.getCheckConstraint();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHECK_CONSTRAINT__EXPRESSION = eINSTANCE.getCheckConstraint_Expression();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PathExpressionConstraintImpl <em>Path Expression Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PathExpressionConstraintImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getPathExpressionConstraint()
		 * @generated
		 */
		EClass PATH_EXPRESSION_CONSTRAINT = eINSTANCE.getPathExpressionConstraint();

		/**
		 * The meta object literal for the '<em><b>Edge Types</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATH_EXPRESSION_CONSTRAINT__EDGE_TYPES = eINSTANCE.getPathExpressionConstraint_EdgeTypes();

		/**
		 * The meta object literal for the '<em><b>Source Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATH_EXPRESSION_CONSTRAINT__SOURCE_TYPE = eINSTANCE.getPathExpressionConstraint_SourceType();

		/**
		 * The meta object literal for the '<em><b>Src</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATH_EXPRESSION_CONSTRAINT__SRC = eINSTANCE.getPathExpressionConstraint_Src();

		/**
		 * The meta object literal for the '<em><b>Dst</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATH_EXPRESSION_CONSTRAINT__DST = eINSTANCE.getPathExpressionConstraint_Dst();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.StringValueImpl <em>String Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.StringValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getStringValue()
		 * @generated
		 */
		EClass STRING_VALUE = eINSTANCE.getStringValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_VALUE__VALUE = eINSTANCE.getStringValue_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.NumberValueImpl <em>Number Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.NumberValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getNumberValue()
		 * @generated
		 */
		EClass NUMBER_VALUE = eINSTANCE.getNumberValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NUMBER_VALUE__VALUE = eINSTANCE.getNumberValue_Value();

		/**
		 * The meta object literal for the '<em><b>Negative</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NUMBER_VALUE__NEGATIVE = eINSTANCE.getNumberValue_Negative();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.BoolValueImpl <em>Bool Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.BoolValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getBoolValue()
		 * @generated
		 */
		EClass BOOL_VALUE = eINSTANCE.getBoolValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BOOL_VALUE__VALUE = eINSTANCE.getBoolValue_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ListValueImpl <em>List Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.ListValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getListValue()
		 * @generated
		 */
		EClass LIST_VALUE = eINSTANCE.getListValue();

		/**
		 * The meta object literal for the '<em><b>Values</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIST_VALUE__VALUES = eINSTANCE.getListValue_Values();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.FunctionEvaluationValueImpl <em>Function Evaluation Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.FunctionEvaluationValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getFunctionEvaluationValue()
		 * @generated
		 */
		EClass FUNCTION_EVALUATION_VALUE = eINSTANCE.getFunctionEvaluationValue();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_EVALUATION_VALUE__EXPRESSION = eINSTANCE.getFunctionEvaluationValue_Expression();

		/**
		 * The meta object literal for the '<em><b>Unwind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION_EVALUATION_VALUE__UNWIND = eINSTANCE.getFunctionEvaluationValue_Unwind();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AggregatedValueImpl <em>Aggregated Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AggregatedValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getAggregatedValue()
		 * @generated
		 */
		EClass AGGREGATED_VALUE = eINSTANCE.getAggregatedValue();

		/**
		 * The meta object literal for the '<em><b>Aggregator</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AGGREGATED_VALUE__AGGREGATOR = eINSTANCE.getAggregatedValue_Aggregator();

		/**
		 * The meta object literal for the '<em><b>Call</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AGGREGATED_VALUE__CALL = eINSTANCE.getAggregatedValue_Call();

		/**
		 * The meta object literal for the '<em><b>Aggregate Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AGGREGATED_VALUE__AGGREGATE_TYPE = eINSTANCE.getAggregatedValue_AggregateType();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CallableRelationImpl <em>Callable Relation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.CallableRelationImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getCallableRelation()
		 * @generated
		 */
		EClass CALLABLE_RELATION = eINSTANCE.getCallableRelation();

		/**
		 * The meta object literal for the '<em><b>Transitive</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CALLABLE_RELATION__TRANSITIVE = eINSTANCE.getCallableRelation_Transitive();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.UnaryTypeConstraintImpl <em>Unary Type Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.UnaryTypeConstraintImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getUnaryTypeConstraint()
		 * @generated
		 */
		EClass UNARY_TYPE_CONSTRAINT = eINSTANCE.getUnaryTypeConstraint();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UNARY_TYPE_CONSTRAINT__TYPE = eINSTANCE.getUnaryTypeConstraint_Type();

		/**
		 * The meta object literal for the '<em><b>Var</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UNARY_TYPE_CONSTRAINT__VAR = eINSTANCE.getUnaryTypeConstraint_Var();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaConstantValueImpl <em>Java Constant Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaConstantValueImpl
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getJavaConstantValue()
		 * @generated
		 */
		EClass JAVA_CONSTANT_VALUE = eINSTANCE.getJavaConstantValue();

		/**
		 * The meta object literal for the '<em><b>Class Ref</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JAVA_CONSTANT_VALUE__CLASS_REF = eINSTANCE.getJavaConstantValue_ClassRef();

		/**
		 * The meta object literal for the '<em><b>Field Ref</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JAVA_CONSTANT_VALUE__FIELD_REF = eINSTANCE.getJavaConstantValue_FieldRef();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ExecutionType <em>Execution Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ExecutionType
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getExecutionType()
		 * @generated
		 */
		EEnum EXECUTION_TYPE = eINSTANCE.getExecutionType();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterDirection <em>Parameter Direction</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterDirection
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getParameterDirection()
		 * @generated
		 */
		EEnum PARAMETER_DIRECTION = eINSTANCE.getParameterDirection();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CompareFeature <em>Compare Feature</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CompareFeature
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getCompareFeature()
		 * @generated
		 */
		EEnum COMPARE_FEATURE = eINSTANCE.getCompareFeature();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ClosureType <em>Closure Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ClosureType
		 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.impl.PatternLanguagePackageImpl#getClosureType()
		 * @generated
		 */
		EEnum CLOSURE_TYPE = eINSTANCE.getClosureType();

	}

} //PatternLanguagePackage
