/**
 * 
 *   Copyright (c) 2010-2013, Abel Hegedus, Zoltan Ujhelyi, Denes Harmath, Istvan Rath and Daniel Varro, IncQuery Labs Ltd.
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.integration.uml.derivedfeatures;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.viatra.integration.uml.derivedfeatures.internal.InternalNamedElementNamespace;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecificationWithGenericMatcher;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

/**
 * A pattern-specific query specification that can instantiate GenericPatternMatcher in a type-safe way.
 * 
 * <p>Original source:
 *         <code><pre>
 *         (if self.name {@literal <}{@literal >} null and self.allNamespaces()-{@literal >}select( ns | ns.name=null )-{@literal >}isEmpty()
 *         then 
 *             self.allNamespaces()-{@literal >}iterate( ns : Namespace; agg: String = self.name | ns.name.concat(self.separator()).concat(agg))
 *         else
 *            null
 *         endif)
 *         
 *         {@literal @}Surrogate(feature = "qualifiedName")
 *         pattern namedElementQualifiedName(namedElement: NamedElement, qualifiedName : java String) {
 *             neg find internalNamedElementNamespace(namedElement, _);
 *             NamedElement.name(namedElement, qualifiedName);
 *             // qualifiedName is null if any of the names are empty!
 *             qualifiedName != "";
 *         } or {
 *             find internalNamedElementNamespace(namedElement, namespace);
 *             NamedElement.name(namedElement, name);
 *             // qualifiedName is null if any of the names are empty!
 *             name != "";
 *             find namedElementQualifiedName(namespace, namespaceQualifiedName);
 *             qualifiedName == eval(namespaceQualifiedName + "::" + name); // XXX is separator always this?
 *         }
 * </pre></code>
 * 
 * @see GenericPatternMatcher
 * @see GenericPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class NamedElementQualifiedName extends BaseGeneratedEMFQuerySpecificationWithGenericMatcher {
  private NamedElementQualifiedName() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
   * 
   */
  public static NamedElementQualifiedName instance() {
    try{
        return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
        throw processInitializerError(err);
    }
  }
  
  /**
   * Inner class allowing the singleton instance of {@link NamedElementQualifiedName} to be created 
   *     <b>not</b> at the class load time of the outer class, 
   *     but rather at the first call to {@link NamedElementQualifiedName#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private static final NamedElementQualifiedName INSTANCE = new NamedElementQualifiedName();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private static final Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternal();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private static final NamedElementQualifiedName.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_namedElement = new PParameter("namedElement", "org.eclipse.uml2.uml.NamedElement", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")), PParameterDirection.INOUT);
    
    private final PParameter parameter_qualifiedName = new PParameter("qualifiedName", "java.lang.String", new JavaTransitiveInstancesKey(java.lang.String.class), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_namedElement, parameter_qualifiedName);
    
    private GeneratedPQuery() {
      super(PVisibility.PUBLIC);
    }
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.integration.uml.derivedfeatures.namedElementQualifiedName";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("namedElement","qualifiedName");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() {
      setEvaluationHints(new QueryEvaluationHint(null, QueryEvaluationHint.BackendRequirement.UNSPECIFIED));
      Set<PBody> bodies = new LinkedHashSet<>();
      {
          PBody body = new PBody(this);
          PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
          PVariable var_qualifiedName = body.getOrCreateVariableByName("qualifiedName");
          PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
          new TypeConstraint(body, Tuples.flatTupleOf(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_qualifiedName), new JavaTransitiveInstancesKey(java.lang.String.class));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_namedElement, parameter_namedElement),
             new ExportedParameter(body, var_qualifiedName, parameter_qualifiedName)
          ));
          //     neg find internalNamedElementNamespace(namedElement, _)
          new NegativePatternCall(body, Tuples.flatTupleOf(var_namedElement, var___0_), InternalNamedElementNamespace.instance().getInternalQueryRepresentation());
          //     NamedElement.name(namedElement, qualifiedName)
          new TypeConstraint(body, Tuples.flatTupleOf(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_namedElement, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement", "name")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/Types", "String")));
          new Equality(body, var__virtual_0_, var_qualifiedName);
          //     // qualifiedName is null if any of the names are empty!    qualifiedName != ""
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new ConstantValue(body, var__virtual_1_, "");
          new Inequality(body, var_qualifiedName, var__virtual_1_);
          bodies.add(body);
      }
      {
          PBody body = new PBody(this);
          PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
          PVariable var_qualifiedName = body.getOrCreateVariableByName("qualifiedName");
          PVariable var_namespace = body.getOrCreateVariableByName("namespace");
          PVariable var_name = body.getOrCreateVariableByName("name");
          PVariable var_namespaceQualifiedName = body.getOrCreateVariableByName("namespaceQualifiedName");
          new TypeConstraint(body, Tuples.flatTupleOf(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_qualifiedName), new JavaTransitiveInstancesKey(java.lang.String.class));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_namedElement, parameter_namedElement),
             new ExportedParameter(body, var_qualifiedName, parameter_qualifiedName)
          ));
          //     find internalNamedElementNamespace(namedElement, namespace)
          new PositivePatternCall(body, Tuples.flatTupleOf(var_namedElement, var_namespace), InternalNamedElementNamespace.instance().getInternalQueryRepresentation());
          //     NamedElement.name(namedElement, name)
          new TypeConstraint(body, Tuples.flatTupleOf(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_namedElement, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement", "name")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/Types", "String")));
          new Equality(body, var__virtual_0_, var_name);
          //     // qualifiedName is null if any of the names are empty!    name != ""
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new ConstantValue(body, var__virtual_1_, "");
          new Inequality(body, var_name, var__virtual_1_);
          //     find namedElementQualifiedName(namespace, namespaceQualifiedName)
          new PositivePatternCall(body, Tuples.flatTupleOf(var_namespace, var_namespaceQualifiedName), this);
          //     qualifiedName == eval(namespaceQualifiedName + "::" + name)
          PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
          new ExpressionEvaluation(body, new IExpressionEvaluator() {
          
              @Override
              public String getShortDescription() {
                  return "Expression evaluation from pattern namedElementQualifiedName";
              }
              
              @Override
              public Iterable<String> getInputParameterNames() {
                  return Arrays.asList("name", "namespaceQualifiedName");}
          
              @Override
              public Object evaluateExpression(IValueProvider provider) throws Exception {
                  String name = (String) provider.getValue("name");
                  String namespaceQualifiedName = (String) provider.getValue("namespaceQualifiedName");
                  return evaluateExpression_2_1(name, namespaceQualifiedName);
              }
          },  var__virtual_2_ ); 
          new Equality(body, var_qualifiedName, var__virtual_2_);
          bodies.add(body);
      }
      {
          PAnnotation annotation = new PAnnotation("Surrogate");
          annotation.addAttribute("feature", "qualifiedName");
          addAnnotation(annotation);
      }
      return bodies;
    }
  }
  
  private static String evaluateExpression_2_1(final String name, final String namespaceQualifiedName) {
    return ((namespaceQualifiedName + "::") + name);
  }
}
