/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.tooling.ui.zest.views.tabs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.HorizontalShiftAlgorithm;
import org.eclipse.gef.layout.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SugiyamaLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.zest.ViatraGraphViewers;
import org.eclipse.viatra.addon.viewers.tooling.ui.views.tabs.AbstractViewerSandboxTab;
import org.eclipse.viatra.integration.zest.viewer.ModifiableZestContentViewer;

public class ZestGraphViewerSandboxTab
extends AbstractViewerSandboxTab {
    ModifiableZestContentViewer viewer;
    private Action refreshGraph = new Action("Refresh Graph"){

        public void run() {
            ZestGraphViewerSandboxTab.this.viewer.refresh();
        }
    };

    public String getTabTitle() {
        return "Zest Graph";
    }

    public void bindState(ViewerState state) {
        ViatraGraphViewers.bind((ModifiableZestContentViewer)this.viewer, (ViewerState)state, (boolean)true);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected Viewer getViewer() {
        return this.viewer;
    }

    protected Viewer createViewer(Composite parent) {
        this.viewer = new ModifiableZestContentViewer();
        this.viewer.createControl(parent, 0);
        SpringLayoutAlgorithm layout = new SpringLayoutAlgorithm();
        this.viewer.setLayoutAlgorithm((ILayoutAlgorithm)layout);
        return this.viewer;
    }

    private MenuManager createLayoutMenu() {
        MenuManager mgr = new MenuManager("Layout");
        mgr.add((IAction)this.createLayoutAction("Tree", (ILayoutAlgorithm)new TreeLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Spring", (ILayoutAlgorithm)new SpringLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Radial", (ILayoutAlgorithm)new RadialLayoutAlgorithm()));
        SugiyamaLayoutAlgorithm sugiyamaAlgorithm = new SugiyamaLayoutAlgorithm();
        HorizontalShiftAlgorithm shiftAlgorithm = new HorizontalShiftAlgorithm();
        mgr.add((IAction)this.createLayoutAction("Sugiyama (unstable)", (ILayoutAlgorithm)new CompositeLayoutAlgorithm(new ILayoutAlgorithm[]{sugiyamaAlgorithm, shiftAlgorithm})));
        return mgr;
    }

    private Action createLayoutAction(String name, final ILayoutAlgorithm lay) {
        return new Action(name){

            public void run() {
                ZestGraphViewerSandboxTab.this.viewer.setLayoutAlgorithm(lay);
                ZestGraphViewerSandboxTab.this.viewer.refresh();
            }
        };
    }

    public List<IContributionItem> getDropDownMenuContributions() {
        ArrayList<IContributionItem> r = new ArrayList<IContributionItem>();
        r.add((IContributionItem)this.createLayoutMenu());
        return r;
    }

    public List<IContributionItem> getToolBarContributions() {
        ArrayList<IContributionItem> r = new ArrayList<IContributionItem>();
        MenuManager mgr = new MenuManager();
        mgr.removeAll();
        mgr.add((IAction)this.refreshGraph);
        mgr.update(true);
        r.add((IContributionItem)mgr);
        return r;
    }
}

