/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class BuildProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null) {
            ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (currentSelection instanceof IStructuredSelection) {
                this.runBuildAction(window, currentSelection);
            } else {
                currentSelection = this.extractSelectionFromEditorInput(HandlerUtil.getActiveEditorInput((ExecutionEvent)event));
                this.runBuildAction(window, currentSelection);
            }
        }
        return null;
    }

    private ISelection extractSelectionFromEditorInput(IEditorInput activeEditorInput) {
        if (activeEditorInput instanceof FileEditorInput) {
            IProject project = ((FileEditorInput)activeEditorInput).getFile().getProject();
            return new StructuredSelection((Object)project);
        }
        return null;
    }

    private void runBuildAction(IWorkbenchWindow window, ISelection currentSelection) {
        BuildAction buildAction = this.newBuildAction(window);
        buildAction.selectionChanged((IStructuredSelection)currentSelection);
        buildAction.run();
    }

    private BuildAction newBuildAction(IWorkbenchWindow window) {
        return new BuildAction((IShellProvider)window, 10);
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext context;
        Object object;
        boolean enabled = false;
        if (evaluationContext instanceof IEvaluationContext && (object = (context = (IEvaluationContext)evaluationContext).getVariable("activeWorkbenchWindow")) instanceof IWorkbenchWindow) {
            BuildAction buildAction = this.newBuildAction((IWorkbenchWindow)object);
            enabled = buildAction.isEnabled();
        }
        this.setBaseEnabled(enabled);
    }
}

