/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.overlapping;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;

public class OverlappingNode<E extends IHTInterval>
extends HTNode<E> {
    private final Set<NodeClosedListener> fListeners = new HashSet<NodeClosedListener>();

    public OverlappingNode(IHTNode.NodeType type, int blockSize, int maxChildren, int seqNumber, int parentSeqNumber, long start) {
        super(type, blockSize, maxChildren, seqNumber, parentSeqNumber, start);
    }

    @Override
    protected @Nullable OverlappingExtraData createNodeExtraData(IHTNode.NodeType type) {
        if (type == IHTNode.NodeType.CORE) {
            return new OverlappingExtraData(this);
        }
        return null;
    }

    @Override
    public void add(E newInterval) {
        super.add(newInterval);
    }

    @Override
    public void closeThisNode(long endtime) {
        super.closeThisNode(endtime);
        this.fListeners.forEach(l2 -> l2.nodeClosed(this, endtime));
    }

    protected void addListener(NodeClosedListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    protected @Nullable OverlappingExtraData getCoreNodeData() {
        return (OverlappingExtraData)super.getCoreNodeData();
    }

    @VisibleForTesting
    public long getChildStart(int index) {
        OverlappingExtraData extraData = this.getCoreNodeData();
        if (extraData != null) {
            return extraData.getChildStart(index);
        }
        throw new UnsupportedOperationException("A leaf node does not have children");
    }

    @VisibleForTesting
    public long getChildEnd(int index) {
        OverlappingExtraData extraData = this.getCoreNodeData();
        if (extraData != null) {
            return extraData.getChildEnd(index);
        }
        throw new UnsupportedOperationException("A leaf node does not have children");
    }

    @FunctionalInterface
    protected static interface NodeClosedListener {
        public void nodeClosed(OverlappingNode<?> var1, long var2);
    }

    protected static class OverlappingExtraData
    extends HTNode.CoreNodeData {
        private final long[] fChildStart;
        private final long[] fChildEnd;

        public OverlappingExtraData(OverlappingNode<?> node) {
            super(node);
            int size = ((OverlappingNode)node).getMaxChildren();
            this.fChildStart = new long[size];
            this.fChildEnd = new long[size];
            int i = 0;
            while (i < size) {
                this.fChildStart[i] = 0L;
                this.fChildEnd[i] = Long.MAX_VALUE;
                ++i;
            }
        }

        protected OverlappingNode<?> getNode() {
            return (OverlappingNode)super.getNode();
        }

        @Override
        public void readSpecificHeader(@NonNull ByteBuffer buffer) {
            super.readSpecificHeader(buffer);
            int size = ((OverlappingNode)this.getNode()).getMaxChildren();
            int i = 0;
            while (i < size) {
                this.fChildStart[i] = buffer.getLong();
                this.fChildEnd[i] = buffer.getLong();
                ++i;
            }
        }

        @Override
        protected void writeSpecificHeader(@NonNull ByteBuffer buffer) {
            ((OverlappingNode)this.getNode()).takeReadLock();
            try {
                super.writeSpecificHeader(buffer);
                int size = ((OverlappingNode)this.getNode()).getMaxChildren();
                int i = 0;
                while (i < size) {
                    buffer.putLong(this.fChildStart[i]);
                    buffer.putLong(this.fChildEnd[i]);
                    ++i;
                }
            }
            finally {
                ((OverlappingNode)this.getNode()).releaseReadLock();
            }
        }

        @Override
        protected int getSpecificHeaderSize() {
            int maxChildren = ((OverlappingNode)this.getNode()).getMaxChildren();
            int specificSize = super.getSpecificHeaderSize();
            return specificSize += 16 * maxChildren;
        }

        @Override
        public void linkNewChild(IHTNode<?> childNode) {
            if (!(childNode instanceof OverlappingNode)) {
                throw new IllegalArgumentException("Adding a node that is not an overlapping node to an overlapping tree!");
            }
            ((OverlappingNode)this.getNode()).takeWriteLock();
            try {
                super.linkNewChild(childNode);
                int childIndex = this.getNbChildren() - 1;
                ((OverlappingNode)childNode).addListener((node, endtime) -> {
                    ((OverlappingNode)this.getNode()).takeWriteLock();
                    try {
                        this.fChildEnd[n] = endtime;
                    }
                    finally {
                        ((OverlappingNode)this.getNode()).releaseWriteLock();
                    }
                });
                this.fChildStart[childIndex] = childNode.getNodeStart();
                if (childNode.isOnDisk()) {
                    this.fChildEnd[childIndex] = childNode.getNodeEnd();
                }
            }
            finally {
                ((OverlappingNode)this.getNode()).releaseWriteLock();
            }
        }

        @Override
        protected Collection<Integer> selectNextIndices(TimeRangeCondition rc) {
            HTNode node = this.getNode();
            if (rc.max() < node.getNodeStart() || node.isOnDisk() && rc.min() > node.getNodeEnd()) {
                return Collections.emptySet();
            }
            ((OverlappingNode)node).takeReadLock();
            try {
                ArrayList<Integer> childList = new ArrayList<Integer>();
                int i = 0;
                while (i < this.getNbChildren()) {
                    if (rc.intersects(this.fChildStart[i], this.fChildEnd[i])) {
                        childList.add(i);
                    }
                    ++i;
                }
                ArrayList<Integer> arrayList = childList;
                return arrayList;
            }
            finally {
                ((OverlappingNode)node).releaseReadLock();
            }
        }

        public long getChildStart(int index) {
            ((OverlappingNode)this.getNode()).takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fChildStart[index];
                return l;
            }
            finally {
                ((OverlappingNode)this.getNode()).releaseReadLock();
            }
        }

        public long getChildEnd(int index) {
            ((OverlappingNode)this.getNode()).takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fChildEnd[index];
                return l;
            }
            finally {
                ((OverlappingNode)this.getNode()).releaseReadLock();
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fChildStart, this.fChildEnd);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            OverlappingExtraData other = (OverlappingExtraData)NonNullUtils.checkNotNull((Object)obj);
            return Arrays.equals(this.fChildStart, other.fChildStart) && Arrays.equals(this.fChildEnd, other.fChildEnd);
        }
    }
}

