/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.completion.IHelpResolver;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ScriptCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension5,
ICompletionProposalExtension6,
IContentProposal,
Comparable<ScriptCompletionProposal> {
    public static final int ORDER_HISTORY = 0;
    public static final int ORDER_PACKAGE = 60;
    public static final int ORDER_CLASS = 70;
    public static final int ORDER_FIELD = 80;
    public static final int ORDER_METHOD = 90;
    public static final int ORDER_DEFAULT = 100;
    private final String fDisplayString;
    private final String fReplacementString;
    private final IImageResolver fImageResolver;
    private StyledString fStyledString;
    private final int fSortOrder;
    private final IHelpResolver fHelpResolver;
    private final ICompletionContext fContext;

    public ScriptCompletionProposal(ICompletionContext context, String displayString, String replacementString, IImageResolver imageResolver, int sortOrder, IHelpResolver helpResolver) {
        this.fContext = context;
        this.fDisplayString = displayString;
        this.fReplacementString = replacementString;
        this.fImageResolver = imageResolver;
        this.fSortOrder = sortOrder;
        this.fHelpResolver = helpResolver;
    }

    public ScriptCompletionProposal(ICompletionContext context, StyledString styledString, String replacementString, IImageResolver imageResolver, int sortOrder, IHelpResolver helpResolver) {
        this(context, styledString.getString(), replacementString, imageResolver, sortOrder, helpResolver);
        this.fStyledString = styledString;
    }

    @Override
    public int compareTo(ScriptCompletionProposal o) {
        int priority = o.fSortOrder - this.fSortOrder;
        if (priority != 0) {
            return priority;
        }
        return this.getDisplayString().compareToIgnoreCase(o.getDisplayString());
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImageResolver != null ? this.fImageResolver.getImage() : null;
    }

    public StyledString getStyledDisplayString() {
        return this.fStyledString != null ? this.fStyledString : new StyledString(this.getDisplayString());
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fContext.getReplaceOffset(), this.fContext.getReplaceLength(), this.fReplacementString);
        }
        catch (BadLocationException e) {
            Logger.error((String)"org.eclipse.ease.ui", (String)"Could not insert completion proposal into document", (Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fContext.getReplaceOffset() + this.fReplacementString.length(), 0);
    }

    public String getAdditionalProposalInfo() {
        if (this.fHelpResolver != null) {
            try {
                FutureTask<String> futureTask = new FutureTask<String>(() -> {
                    String htmlHelp = this.fHelpResolver.resolveHTMLHelp();
                    return htmlHelp != null ? htmlHelp : this.fHelpResolver.resolveHelp();
                });
                ExecutorService executor = Executors.newSingleThreadExecutor();
                executor.execute(futureTask);
                return futureTask.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.getAdditionalProposalInfo();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getContent() {
        String prefix = this.fContext.getText().substring(0, this.fContext.getReplaceOffset() - this.fContext.getFilter().length());
        String suffix = this.fContext.getText().substring(this.fContext.getReplaceOffset());
        return String.valueOf(prefix) + this.fReplacementString + suffix;
    }

    public int getCursorPosition() {
        String prefix = this.fContext.getText().substring(0, this.fContext.getReplaceOffset() - this.fContext.getFilter().length());
        return (String.valueOf(prefix) + this.fReplacementString).length();
    }

    public String getLabel() {
        return this.getDisplayString();
    }

    public String getDescription() {
        return this.getAdditionalProposalInfo();
    }
}

