/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.coll;

import org.python.icu.impl.Normalizer2Impl;
import org.python.icu.impl.Trie2_32;
import org.python.icu.impl.coll.Collation;
import org.python.icu.text.UnicodeSet;

public final class CollationData {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    static final int JAMO_CE32S_LENGTH = 67;
    Trie2_32 trie;
    int[] ce32s;
    long[] ces;
    String contexts;
    public CollationData base;
    int[] jamoCE32s = new int[67];
    public Normalizer2Impl nfcImpl;
    long numericPrimary = 0x12000000L;
    public boolean[] compressibleBytes;
    UnicodeSet unsafeBackwardSet;
    public char[] fastLatinTable;
    char[] fastLatinTableHeader;
    char[] scripts;
    public long[] rootElements;

    CollationData(Normalizer2Impl nfc) {
        this.nfcImpl = nfc;
    }

    public int getCE32(int c) {
        return this.trie.get(c);
    }

    int getCE32FromSupplementary(int c) {
        return this.trie.get(c);
    }

    boolean isDigit(int c) {
        return c < 1632 ? c <= 57 && 48 <= c : Collation.hasCE32Tag(this.getCE32(c), 10);
    }

    public boolean isUnsafeBackward(int c, boolean numeric) {
        return this.unsafeBackwardSet.contains(c) || numeric && this.isDigit(c);
    }

    public boolean isCompressibleLeadByte(int b) {
        return this.compressibleBytes[b];
    }

    public boolean isCompressiblePrimary(long p) {
        return this.isCompressibleLeadByte((int)p >>> 24);
    }

    int getCE32FromContexts(int index) {
        return this.contexts.charAt(index) << 16 | this.contexts.charAt(index + 1);
    }

    int getIndirectCE32(int ce32) {
        assert (Collation.isSpecialCE32(ce32));
        int tag = Collation.tagFromCE32(ce32);
        if (tag == 10) {
            ce32 = this.ce32s[Collation.indexFromCE32(ce32)];
        } else if (tag == 13) {
            ce32 = -1;
        } else if (tag == 11) {
            ce32 = this.ce32s[0];
        }
        return ce32;
    }

    int getFinalCE32(int ce32) {
        if (Collation.isSpecialCE32(ce32)) {
            ce32 = this.getIndirectCE32(ce32);
        }
        return ce32;
    }

    long getCEFromOffsetCE32(int c, int ce32) {
        long dataCE = this.ces[Collation.indexFromCE32(ce32)];
        return Collation.makeCE(Collation.getThreeBytePrimaryForOffsetData(c, dataCE));
    }

    long getSingleCE(int c) {
        CollationData d;
        int ce32 = this.getCE32(c);
        if (ce32 == 192) {
            d = this.base;
            ce32 = this.base.getCE32(c);
        } else {
            d = this;
        }
        while (Collation.isSpecialCE32(ce32)) {
            switch (Collation.tagFromCE32(ce32)) {
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", c, ce32));
                }
                case 0: 
                case 3: {
                    throw new AssertionError((Object)String.format("unexpected CE32 tag for U+%04X (CE32 0x%08x)", c, ce32));
                }
                case 1: {
                    return Collation.ceFromLongPrimaryCE32(ce32);
                }
                case 2: {
                    return Collation.ceFromLongSecondaryCE32(ce32);
                }
                case 5: {
                    if (Collation.lengthFromCE32(ce32) == 1) {
                        ce32 = d.ce32s[Collation.indexFromCE32(ce32)];
                        break;
                    }
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", c, ce32));
                }
                case 6: {
                    if (Collation.lengthFromCE32(ce32) == 1) {
                        return d.ces[Collation.indexFromCE32(ce32)];
                    }
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", c, ce32));
                }
                case 10: {
                    ce32 = d.ce32s[Collation.indexFromCE32(ce32)];
                    break;
                }
                case 11: {
                    assert (c == 0);
                    ce32 = d.ce32s[0];
                    break;
                }
                case 14: {
                    return d.getCEFromOffsetCE32(c, ce32);
                }
                case 15: {
                    return Collation.unassignedCEFromCodePoint(c);
                }
            }
        }
        return Collation.ceFromSimpleCE32(ce32);
    }

    int getFCD16(int c) {
        return this.nfcImpl.getFCD16(c);
    }

    long getFirstPrimaryForGroup(int script) {
        int index = this.findScript(script);
        if (index < 0) {
            return 0L;
        }
        long head = this.scripts[index];
        return (head & 0xFF00L) << 16;
    }

    public long getLastPrimaryForGroup(int script) {
        int index = this.findScript(script);
        if (index < 0) {
            return 0L;
        }
        char head = this.scripts[index];
        long lastByte = head & 0xFF;
        return (lastByte + 1L << 24) - 1L;
    }

    public int getGroupForPrimary(long p) {
        p >>= 24;
        int i = 0;
        while (i < this.scripts.length) {
            int lastByte = this.scripts[i] & 0xFF;
            if (p <= (long)lastByte) {
                return this.scripts[i + 2];
            }
            i = i + 2 + this.scripts[i + 1];
        }
        return -1;
    }

    private int findScript(int script) {
        if (script < 0 || 65535 < script) {
            return -1;
        }
        int i = 0;
        while (i < this.scripts.length) {
            int limit = i + 2 + this.scripts[i + 1];
            for (int j = i + 2; j < limit; ++j) {
                if (script != this.scripts[j]) continue;
                return i;
            }
            i = limit;
        }
        return -1;
    }

    public int[] getEquivalentScripts(int script) {
        int i = this.findScript(script);
        if (i < 0) {
            return EMPTY_INT_ARRAY;
        }
        int length = this.scripts[i + 1];
        assert (length != 0);
        int[] dest = new int[length];
        i += 2;
        dest[0] = this.scripts[i++];
        for (int j = 1; j < length; ++j) {
            script = this.scripts[i++];
            int k = j;
            while (true) {
                if (k <= 0 || script >= dest[k - '\u0001']) break;
                dest[k] = dest[k - 1];
                --k;
            }
            dest[k] = script;
        }
        return dest;
    }

    public void makeReorderTable(int[] reorder, byte[] table) {
        int reorderCode;
        int i;
        int highByte;
        int lowByte;
        int length = reorder.length;
        for (lowByte = 0; lowByte <= 2; ++lowByte) {
            table[lowByte] = (byte)lowByte;
        }
        for (highByte = 255; highByte >= 255; --highByte) {
            table[highByte] = (byte)highByte;
        }
        for (int i2 = lowByte; i2 <= highByte; ++i2) {
            table[i2] = 0;
        }
        int specials = 0;
        for (i = 0; i < length; ++i) {
            reorderCode = reorder[i] - 4096;
            if (0 > reorderCode || reorderCode > 31) continue;
            specials |= 1 << reorderCode;
        }
        i = 0;
        while (this.scripts[i + 1] == '\u0001' && (reorderCode = this.scripts[i + 2] - 4096) >= 0) {
            if ((specials & 1 << reorderCode) == 0) {
                char head = this.scripts[i];
                int firstByte = head >> 8;
                int lastByte = head & 0xFF;
                do {
                    table[firstByte++] = (byte)lowByte++;
                } while (firstByte <= lastByte);
            }
            i += 3;
        }
        i = 0;
        while (i < length) {
            int lastByte;
            int firstByte;
            char head;
            int index;
            int script;
            if ((script = reorder[i++]) == 103) {
                while (i < length) {
                    if ((script = reorder[--length]) == 103) {
                        throw new IllegalArgumentException("setReorderCodes(): duplicate UScript.UNKNOWN");
                    }
                    if (script == -1) {
                        throw new IllegalArgumentException("setReorderCodes(): UScript.DEFAULT together with other scripts");
                    }
                    index = this.findScript(script);
                    if (index < 0) continue;
                    head = this.scripts[index];
                    firstByte = head >> 8;
                    lastByte = head & 0xFF;
                    if (table[firstByte] != 0) {
                        throw new IllegalArgumentException("setReorderCodes(): duplicate or equivalent script " + CollationData.scriptCodeString(script));
                    }
                    do {
                        table[lastByte--] = (byte)highByte--;
                    } while (firstByte <= lastByte);
                }
                break;
            }
            if (script == -1) {
                throw new IllegalArgumentException("setReorderCodes(): UScript.DEFAULT together with other scripts");
            }
            index = this.findScript(script);
            if (index < 0) continue;
            head = this.scripts[index];
            firstByte = head >> 8;
            lastByte = head & 0xFF;
            if (table[firstByte] != 0) {
                throw new IllegalArgumentException("setReorderCodes(): duplicate or equivalent script " + CollationData.scriptCodeString(script));
            }
            do {
                table[firstByte++] = (byte)lowByte++;
            } while (firstByte <= lastByte);
        }
        for (i = 1; i <= 255; ++i) {
            if (table[i] != 0) continue;
            table[i] = (byte)lowByte++;
        }
        assert (lowByte == highByte + 1);
    }

    private static String scriptCodeString(int script) {
        return script < 4096 ? Integer.toString(script) : "0x" + Integer.toHexString(script);
    }
}

