/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IDelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IRewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ISuffixEntry;
import org.eclipse.wst.xml.ui.internal.catalog.ImageFactory;
import org.eclipse.wst.xml.ui.internal.catalog.URIUtils;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;

public class XMLCatalogTreeViewerBuilder {
    protected static Image xmlCatalogImage = ImageFactory.INSTANCE.getImage("icons/obj16/xmlcatalog_obj.gif");
    protected static Image errorImage = ImageFactory.INSTANCE.getImage("icons/ovr16/error-overlay.gif");
    protected static Image entryImage = ImageFactory.INSTANCE.getImage("icons/obj16/entry_obj.png");
    protected static Image nextCatalogImage = ImageFactory.INSTANCE.getImage("icons/obj16/nextCatalog_obj.gif");
    protected static Image rewriteEntryImage = ImageFactory.INSTANCE.getImage("icons/obj16/rewrite_entry.gif");
    protected static Image suffixEntryImage = ImageFactory.INSTANCE.getImage("icons/obj16/suffix_entry.gif");
    protected static Image delegateCatalogImage = ImageFactory.INSTANCE.getImage("icons/obj16/delegate_catalog.gif");
    protected static String ERROR_STATE_KEY = "errorstatekey";
    protected ICatalog fWorkingUserCatalog;
    protected ICatalog fSystemCatalog;
    private Composite fParent = null;
    private FilteredTree fTree = null;
    private TreeViewer fTreeViewer = null;
    public static String USER_SPECIFIED_ENTRIES_OBJECT = XMLCatalogMessages.UI_LABEL_USER_SPECIFIED_ENTRIES;
    public static String PLUGIN_SPECIFIED_ENTRIES_OBJECT = XMLCatalogMessages.UI_LABEL_PLUGIN_SPECIFIED_ENTRIES;

    XMLCatalogTreeViewerBuilder(Composite parent, ICatalog workingUserCatalog, ICatalog systemCatalog) {
        this.fParent = parent;
        this.fWorkingUserCatalog = workingUserCatalog;
        this.fSystemCatalog = systemCatalog;
    }

    public TreeViewer create() {
        this.fTree = new FilteredTree(this.fParent, 2, new PatternFilter(), true, false);
        this.fTreeViewer = this.fTree.getViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new CatalogEntryContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new CatalogEntryLabelProvider());
        return this.fTreeViewer;
    }

    public void setFilterExtensions(String[] extensions) {
        this.fTreeViewer.resetFilters();
        this.fTreeViewer.addFilter((ViewerFilter)new XMLCatalogTableViewerFilter(extensions));
    }

    public class CatalogEntryContentProvider
    implements ITreeContentProvider {
        protected Object[] roots = new Object[2];

        public CatalogEntryContentProvider() {
            this.roots[0] = USER_SPECIFIED_ENTRIES_OBJECT;
            this.roots[1] = PLUGIN_SPECIFIED_ENTRIES_OBJECT;
        }

        public boolean isRoot(Object object) {
            return object instanceof String || object instanceof INextCatalog;
        }

        public Object[] getElements(Object element) {
            return this.roots;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = new Object[]{};
            if (parentElement == this.roots[0]) {
                result = this.getChildrenHelper(XMLCatalogTreeViewerBuilder.this.fWorkingUserCatalog);
            } else if (parentElement == this.roots[1]) {
                result = this.getChildrenHelper(XMLCatalogTreeViewerBuilder.this.fSystemCatalog);
            } else if (parentElement instanceof INextCatalog) {
                ICatalog nextCatalog = ((INextCatalog)parentElement).getReferencedCatalog();
                result = this.getChildrenHelper(nextCatalog);
            } else if (parentElement instanceof IDelegateCatalog) {
                ICatalog nextCatalog = ((IDelegateCatalog)parentElement).getReferencedCatalog();
                result = this.getChildrenHelper(nextCatalog);
            }
            return result;
        }

        protected Object[] getChildrenHelper(ICatalog catalog) {
            ICatalogEntry[] entries = catalog.getCatalogEntries();
            if (entries.length > 0) {
                Comparator comparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int result = 0;
                        if (o1 instanceof ICatalogEntry && o2 instanceof ICatalogEntry) {
                            ICatalogEntry entry1 = (ICatalogEntry)o1;
                            ICatalogEntry entry2 = (ICatalogEntry)o2;
                            result = Collator.getInstance().compare(entry1.getKey(), entry2.getKey());
                        }
                        return result;
                    }
                };
                Arrays.sort(entries, comparator);
            }
            Vector<Object> result = new Vector<Object>();
            result.addAll(Arrays.asList(entries));
            result.addAll(Arrays.asList(catalog.getRewriteEntries()));
            result.addAll(Arrays.asList(catalog.getSuffixEntries()));
            result.addAll(Arrays.asList(catalog.getDelegateCatalogs()));
            INextCatalog[] nextCatalogs = catalog.getNextCatalogs();
            List<INextCatalog> nextCatalogsList = Arrays.asList(nextCatalogs);
            result.addAll(nextCatalogsList);
            return result.toArray(new ICatalogElement[result.size()]);
        }

        public Object getParent(Object element) {
            return element instanceof String ? null : USER_SPECIFIED_ENTRIES_OBJECT;
        }

        public boolean hasChildren(Object element) {
            return this.isRoot(element) ? this.getChildren(element).length > 0 : false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }
    }

    public class CatalogEntryLabelProvider
    extends LabelProvider {
        protected HashMap imageTable = new HashMap();

        public String getText(Object object) {
            String result = null;
            if (object instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)object;
                result = catalogEntry.getKey();
            } else if (object instanceof ISuffixEntry) {
                ISuffixEntry entry = (ISuffixEntry)object;
                result = "[...]" + entry.getSuffix() + " " + XMLCatalogMessages.UI_LABEL_ARROW + " " + entry.getURI();
            } else if (object instanceof IRewriteEntry) {
                IRewriteEntry entry = (IRewriteEntry)object;
                result = String.valueOf(entry.getStartString()) + "[...] " + XMLCatalogMessages.UI_LABEL_ARROW + " " + entry.getRewritePrefix() + "[...]";
            } else if (object instanceof INextCatalog) {
                INextCatalog nextCatalog = (INextCatalog)object;
                result = URIUtils.convertURIToLocation(nextCatalog.getCatalogLocation());
                if (nextCatalog.getCatalogLocation().startsWith("file:")) {
                    result = String.valueOf(result) + " (" + XMLCatalogMessages.UI_LABEL_FILE_SYSTEM_RESOURCE + ")";
                } else if (nextCatalog.getCatalogLocation().startsWith("platform:")) {
                    result = String.valueOf(result) + " (" + XMLCatalogMessages.UI_LABEL_PLATFORM_RESOURCE + ")";
                }
            } else if (object instanceof IDelegateCatalog) {
                IDelegateCatalog nextCatalog = (IDelegateCatalog)object;
                result = String.valueOf(nextCatalog.getStartString()) + " " + XMLCatalogMessages.UI_LABEL_ARROW + " " + URIUtils.convertURIToLocation(nextCatalog.getCatalogLocation());
                if (nextCatalog.getCatalogLocation().startsWith("file:")) {
                    result = String.valueOf(result) + " (" + XMLCatalogMessages.UI_LABEL_FILE_SYSTEM_RESOURCE + ")";
                } else if (nextCatalog.getCatalogLocation().startsWith("platform:")) {
                    result = String.valueOf(result) + " (" + XMLCatalogMessages.UI_LABEL_PLATFORM_RESOURCE + ")";
                }
            }
            result = TextProcessor.process((String)result);
            return result != null ? result : object.toString();
        }

        public Image getImage(Object object) {
            Image result = null;
            if (object instanceof String) {
                result = xmlCatalogImage;
            } else if (object instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)object;
                String uri = catalogEntry.getURI();
                result = this.getResourceImage(uri);
            } else if (object instanceof INextCatalog) {
                result = nextCatalogImage;
            } else if (object instanceof IDelegateCatalog) {
                result = delegateCatalogImage;
            } else if (object instanceof ISuffixEntry) {
                result = suffixEntryImage;
            } else if (object instanceof IRewriteEntry) {
                result = rewriteEntryImage;
            }
            return result;
        }

        private Image getResourceImage(String uri) {
            Image result = null;
            Image base = null;
            IEditorRegistry er = PlatformUI.getWorkbench().getEditorRegistry();
            ImageDescriptor imageDescriptor = er.getImageDescriptor(uri);
            Image image = (Image)this.imageTable.get(imageDescriptor);
            if (image == null) {
                image = imageDescriptor.createImage();
                this.imageTable.put(imageDescriptor, image);
            }
            if ((base = image) != null) {
                result = URIHelper.isReadableURI((String)uri, (boolean)false) ? base : ImageFactory.INSTANCE.createCompositeImage(base, errorImage, 3);
            }
            return result;
        }

        public void dispose() {
            super.dispose();
            Iterator it = this.imageTable.values().iterator();
            while (it.hasNext()) {
                ((Image)it.next()).dispose();
            }
        }
    }

    class XMLCatalogTableViewerFilter
    extends ViewerFilter {
        protected String[] extensions;

        public XMLCatalogTableViewerFilter(String[] extensions1) {
            this.extensions = extensions1;
        }

        public boolean isFilterProperty(Object element, Object property) {
            return false;
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean result = false;
            if (element instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)element;
                int i = 0;
                while (i < this.extensions.length) {
                    if (catalogEntry.getURI().endsWith(this.extensions[i])) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            } else if (element.equals(PLUGIN_SPECIFIED_ENTRIES_OBJECT) || element.equals(USER_SPECIFIED_ENTRIES_OBJECT)) {
                return true;
            }
            return result;
        }
    }
}

