/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.views.xychart;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.Range;
import org.eclipse.tracecompass.internal.tmf.ui.views.xychart.Messages;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.AxisRange;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;

public class LockRangeDialog
extends Dialog {
    private Button fCheck;
    private Text fMinText;
    private Text fMaxText;
    private final TmfXYChartViewer fChartViewer;
    private ModifyListener fModifyListener = e -> this.validateInputs();

    private static boolean isValidDouble(String input) {
        try {
            Double.parseDouble(input);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public LockRangeDialog(Shell parentShell, TmfXYChartViewer chartViewer) {
        super(parentShell);
        this.fChartViewer = chartViewer;
    }

    protected Control createDialogArea(Composite p) {
        p.getShell().setText(Messages.TmfChartView_LockYAxis);
        Composite parent = (Composite)super.createDialogArea(p);
        GridLayout parentLayout = new GridLayout(2, false);
        parent.setLayout((Layout)parentLayout);
        Range range = this.fChartViewer.getSwtChart().getAxisSet().getYAxis(0).getRange();
        this.fCheck = new Button(parent, 32);
        this.fCheck.setText(Messages.TmfChartView_LockButton);
        this.fCheck.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.fCheck.setSelection(true);
        this.fCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LockRangeDialog.this.fMinText.setEnabled(LockRangeDialog.this.fCheck.getSelection());
                LockRangeDialog.this.fMaxText.setEnabled(LockRangeDialog.this.fCheck.getSelection());
                LockRangeDialog.this.validateInputs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label minLabel = new Label(parent, 16);
        minLabel.setText(Messages.TmfChartView_LowerYAxisRange);
        minLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fMinText = new Text(parent, 2052);
        this.fMinText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fMinText.setText(String.valueOf(range.lower));
        this.fMinText.addModifyListener(this.fModifyListener);
        Label maxLabel = new Label(parent, 16);
        maxLabel.setText(Messages.TmfChartView_UpperYAxisRange);
        maxLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fMaxText = new Text(parent, 2052);
        this.fMaxText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fMaxText.setText(String.valueOf(range.upper));
        this.fMaxText.addModifyListener(this.fModifyListener);
        return parent;
    }

    protected void okPressed() {
        if (this.fCheck.getSelection()) {
            this.lockAxis();
        } else {
            this.fChartViewer.setFixedYRange(null);
        }
        super.okPressed();
    }

    private void lockAxis() {
        double min = 0.0;
        double max = 0.0;
        try {
            min = Double.parseDouble(this.fMinText.getText());
            max = Double.parseDouble(this.fMaxText.getText());
            this.fChartViewer.setFixedYRange(new AxisRange(min, max));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void validateInputs() {
        boolean isValidInput = LockRangeDialog.isValidDouble(this.fMaxText.getText()) && LockRangeDialog.isValidDouble(this.fMinText.getText());
        this.getButton(0).setEnabled(isValidInput || !this.fCheck.getSelection());
    }
}

