/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.nfp.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.TimeUnitKind;
import org.polarsys.time4sys.marte.nfp.impl.DurationImpl;

public class LongDurationImpl
extends DurationImpl {
    public static final DurationImpl ZERO = new LongDurationImpl(0L, TimeUnitKind.PS);
    protected long picoseconds;

    public static long asLongPicoSecond(TimeUnitKind unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        switch (unit) {
            case PS: {
                return 1L;
            }
            case NS: {
                return 1000L;
            }
            case US: {
                return 1000000L;
            }
            case MS: {
                return 1000000000L;
            }
            case S: {
                return 1000000000000L;
            }
            case MN: {
                return 60000000000000L;
            }
            case H: {
                return 3600000000000000L;
            }
            case D: {
                return 86400000000000000L;
            }
        }
        throw new IllegalArgumentException("Unexpected TimeUnitKind: " + unit.getLiteral());
    }

    public LongDurationImpl() {
        this(0L, TimeUnitKind.PS);
    }

    public LongDurationImpl(long durationInPicoseconds, TimeUnitKind unit) {
        super((double)durationInPicoseconds / (double)LongDurationImpl.asLongPicoSecond(unit), unit);
        this.picoseconds = durationInPicoseconds;
    }

    public LongDurationImpl(double v, TimeUnitKind unit) {
        super(v, unit);
        this.picoseconds = (long)(v * (double)LongDurationImpl.asLongPicoSecond(unit));
    }

    private long lcm(long m, long n) {
        if (m == 0L && n == 0L) {
            return 0L;
        }
        BigInteger mi = BigInteger.valueOf(m);
        BigInteger ni = BigInteger.valueOf(n);
        BigInteger gcd = mi.gcd(ni);
        BigInteger r = mi.multiply(ni).divide(gcd);
        return r.longValue();
    }

    @Override
    public void setValue(double newValue) {
        this.picoseconds = (long)(newValue * (double)LongDurationImpl.asLongPicoSecond(this.unit));
        super.setValue(newValue);
    }

    @Override
    public Duration add(Duration v) {
        if (v instanceof LongDurationImpl) {
            TimeUnitKind targetUnit = this.d.findClosestUnitTo(this.getUnit(), v.getUnit());
            return new LongDurationImpl(this.picoseconds + ((LongDurationImpl)v).picoseconds, targetUnit);
        }
        return super.add(v);
    }

    @Override
    public Duration multiply(long v) {
        return new LongDurationImpl(this.picoseconds * v, this.unit);
    }

    @Override
    public double div(Duration v) {
        if (v instanceof LongDurationImpl) {
            return new BigDecimal(this.picoseconds).divide(new BigDecimal(((LongDurationImpl)v).picoseconds)).doubleValue();
        }
        return super.div(v);
    }

    @Override
    public double div(Duration v, MathContext mc) {
        if (v instanceof LongDurationImpl) {
            return new BigDecimal(this.picoseconds).divide(new BigDecimal(((LongDurationImpl)v).picoseconds), mc).doubleValue();
        }
        return super.div(v);
    }

    @Override
    public long divide(Duration v) {
        if (v instanceof LongDurationImpl) {
            return this.picoseconds / ((LongDurationImpl)v).picoseconds;
        }
        return super.divide(v);
    }

    @Override
    public Duration lcm(Duration v) {
        if (v instanceof LongDurationImpl) {
            TimeUnitKind targetUnit = this.d.findClosestUnitTo(this.getUnit(), v.getUnit());
            return new LongDurationImpl(this.lcm(this.picoseconds, ((LongDurationImpl)v).picoseconds), targetUnit);
        }
        return super.lcm(v);
    }

    @Override
    public Duration convertToUnit(TimeUnitKind target) {
        if (this.unit == target) {
            return this;
        }
        return new LongDurationImpl(this.picoseconds, target);
    }

    @Override
    public Duration sub(Duration v) {
        if (v instanceof LongDurationImpl) {
            TimeUnitKind targetUnit = this.d.findClosestUnitTo(this.getUnit(), v.getUnit());
            return new LongDurationImpl(this.picoseconds - ((LongDurationImpl)v).picoseconds, targetUnit);
        }
        return super.sub(v);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        if (obj instanceof LongDurationImpl) {
            return this.picoseconds == ((LongDurationImpl)obj).picoseconds;
        }
        return super.equals(obj);
    }

    public long getValueInPicoSeconds() {
        return this.picoseconds;
    }

    @Override
    public Duration simplify() {
        if (this.picoseconds == 0L) {
            return this;
        }
        TimeUnitKind best = TimeUnitKind.PS;
        TimeUnitKind[] timeUnitKindArray = TimeUnitKind.values();
        int n = timeUnitKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeUnitKind u = timeUnitKindArray[n2];
            if (this.picoseconds % LongDurationImpl.asLongPicoSecond(u) != 0L) break;
            best = u;
            ++n2;
        }
        return this.convertToUnit(best);
    }

    @Override
    public int compareTo(Duration anotherDuration) {
        if (anotherDuration instanceof LongDurationImpl) {
            return Long.compare(this.picoseconds, ((LongDurationImpl)anotherDuration).picoseconds);
        }
        return super.compareTo(anotherDuration);
    }

    @Override
    public boolean isZero() {
        return this.picoseconds == 0L;
    }

    @Override
    public Duration max(Duration other) {
        if (other == null) {
            return this;
        }
        if (other instanceof LongDurationImpl) {
            LongDurationImpl o = (LongDurationImpl)other;
            if (this.picoseconds >= o.picoseconds) {
                return this;
            }
            return other;
        }
        return super.max(other);
    }

    @Override
    public Duration min(Duration other) {
        if (other == null) {
            return this;
        }
        if (other instanceof LongDurationImpl) {
            LongDurationImpl o = (LongDurationImpl)other;
            if (this.picoseconds <= o.picoseconds) {
                return this;
            }
            return other;
        }
        return super.min(other);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        if (this.isSimpleDuration()) {
            Duration s = this.simplify();
            if (s == this) {
                StringBuilder sb = new StringBuilder();
                sb.append(Long.toString(((LongDurationImpl)s).picoseconds / LongDurationImpl.asLongPicoSecond(this.unit)));
                sb.append(s.getUnit().getName());
                return sb.toString();
            }
            return s.toString();
        }
        return super.toString();
    }
}

