/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.nfp.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpPackage;
import org.polarsys.time4sys.marte.nfp.TimeUnitKind;
import org.polarsys.time4sys.marte.nfp.impl.AbstractRealWithUnitValueImpl;
import org.polarsys.time4sys.marte.nfp.impl.NfpFactoryImpl;
import org.polarsys.time4sys.marte.nfp.impl.TimeDimension;

public class DurationImpl
extends AbstractRealWithUnitValueImpl<TimeUnitKind, Duration>
implements Duration {
    protected static final DurationImpl ZERO = new DurationImpl(0.0, TimeUnitKind.MS);
    protected static final double VALUE_EDEFAULT = 0.0;
    protected double value = 0.0;
    protected static final TimeUnitKind UNIT_EDEFAULT = TimeUnitKind.MS;
    protected TimeUnitKind unit = UNIT_EDEFAULT;
    protected static final double BEST_EDEFAULT = 0.0;
    protected double best = 0.0;
    protected static final double WORST_EDEFAULT = 0.0;
    protected double worst = 0.0;
    protected static final String CLOCK_EDEFAULT = null;
    protected String clock = CLOCK_EDEFAULT;
    protected static final double PRECISION_EDEFAULT = 0.0;
    protected double precision = 0.0;

    protected DurationImpl() {
        this(0.0, TimeUnitKind.MS);
    }

    protected DurationImpl(double v, TimeUnitKind unit) {
        super(TimeDimension.timeDimension);
        this.value = v;
        this.unit = unit;
    }

    protected EClass eStaticClass() {
        return NfpPackage.Literals.DURATION;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double newValue) {
        double oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldValue, this.value));
        }
    }

    @Override
    public TimeUnitKind getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(TimeUnitKind newUnit) {
        TimeUnitKind oldUnit = this.unit;
        TimeUnitKind timeUnitKind = this.unit = newUnit == null ? UNIT_EDEFAULT : newUnit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldUnit, (Object)this.unit));
        }
    }

    @Override
    public double getBest() {
        return this.best;
    }

    @Override
    public void setBest(double newBest) {
        double oldBest = this.best;
        this.best = newBest;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldBest, this.best));
        }
    }

    @Override
    public double getWorst() {
        return this.worst;
    }

    @Override
    public void setWorst(double newWorst) {
        double oldWorst = this.worst;
        this.worst = newWorst;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldWorst, this.worst));
        }
    }

    @Override
    public String getClock() {
        return this.clock;
    }

    @Override
    public void setClock(String newClock) {
        String oldClock = this.clock;
        this.clock = newClock;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldClock, (Object)this.clock));
        }
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(double newPrecision) {
        double oldPrecision = this.precision;
        this.precision = newPrecision;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldPrecision, this.precision));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getValue();
            }
            case 1: {
                return this.getUnit();
            }
            case 2: {
                return this.getBest();
            }
            case 3: {
                return this.getWorst();
            }
            case 4: {
                return this.getClock();
            }
            case 5: {
                return this.getPrecision();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setValue((Double)newValue);
                return;
            }
            case 1: {
                this.setUnit((TimeUnitKind)((Object)newValue));
                return;
            }
            case 2: {
                this.setBest((Double)newValue);
                return;
            }
            case 3: {
                this.setWorst((Double)newValue);
                return;
            }
            case 4: {
                this.setClock((String)newValue);
                return;
            }
            case 5: {
                this.setPrecision((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setValue(0.0);
                return;
            }
            case 1: {
                this.setUnit(UNIT_EDEFAULT);
                return;
            }
            case 2: {
                this.setBest(0.0);
                return;
            }
            case 3: {
                this.setWorst(0.0);
                return;
            }
            case 4: {
                this.setClock(CLOCK_EDEFAULT);
                return;
            }
            case 5: {
                this.setPrecision(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.value != 0.0;
            }
            case 1: {
                return this.unit != UNIT_EDEFAULT;
            }
            case 2: {
                return this.best != 0.0;
            }
            case 3: {
                return this.worst != 0.0;
            }
            case 4: {
                return CLOCK_EDEFAULT == null ? this.clock != null : !CLOCK_EDEFAULT.equals(this.clock);
            }
            case 5: {
                return this.precision != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.add((Duration)arguments.get(0));
            }
            case 1: {
                return this.compareTo((Duration)arguments.get(0));
            }
            case 2: {
                return this.convertToUnit((TimeUnitKind)((Object)arguments.get(0)));
            }
            case 3: {
                return this.div((Duration)arguments.get(0));
            }
            case 5: {
                return this.divide((Duration)arguments.get(0));
            }
            case 6: {
                return this.isZero();
            }
            case 7: {
                return this.lcm((Duration)arguments.get(0));
            }
            case 8: {
                return this.max((Duration)arguments.get(0));
            }
            case 9: {
                return this.min((Duration)arguments.get(0));
            }
            case 10: {
                return this.multiply((Long)arguments.get(0));
            }
            case 11: {
                return this.notZero();
            }
            case 12: {
                return this.simplify();
            }
            case 13: {
                return this.sub((Duration)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public boolean isSimpleDuration() {
        return !this.eIsSet(3) && !this.eIsSet(2) && !this.eIsSet(4) && !this.eIsSet(5);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        if (this.isSimpleDuration()) {
            Duration s = (Duration)this.simplify();
            if (s == this) {
                StringBuilder sb = new StringBuilder();
                sb.append(NfpFactoryImpl.convertDoubleToString(s.getValue()));
                sb.append(s.getUnit().getName());
                return sb.toString();
            }
            return s.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(", unit: ");
        result.append((Object)this.unit);
        result.append(", best: ");
        result.append(this.best);
        result.append(", worst: ");
        result.append(this.worst);
        result.append(", clock: ");
        result.append(this.clock);
        result.append(", precision: ");
        result.append(this.precision);
        result.append(')');
        return result.toString();
    }

    @Override
    public int hashCode() {
        if (this.isSimpleDuration()) {
            int result = 1;
            result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
            long temp = Double.doubleToLongBits(this.value);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)obj;
        if (this.unit == other.getUnit()) {
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.getValue());
        }
        if (this.isZero() && other.isZero()) {
            return true;
        }
        TimeUnitKind target = this.d.findClosestUnitTo(this.unit, other.getUnit());
        return ((Duration)this.convertToUnit(target)).equals(other.convertToUnit(target));
    }

    @Override
    protected Duration create(double e, TimeUnitKind targetUnit) {
        return new DurationImpl(e, targetUnit);
    }
}

