/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.codeassist.DOMCodeSelector;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngine;
import org.eclipse.jdt.internal.codeassist.DOMCompletionUtils;
import org.eclipse.jdt.internal.codeassist.ExpectedTypes;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;

class DOMCompletionContext
extends CompletionContext {
    private final CompilationUnit domUnit;
    private final ITypeRoot modelUnit;
    private final int offset;
    private final char[] token;
    private final String tokenStr;
    private IJavaElement enclosingElement;
    private boolean enclosingElementComputed;
    private final Supplier<Stream<IBinding>> bindingsAcquirer;
    final ExpectedTypes expectedTypes;
    private boolean inJavadoc = false;
    final ASTNode node;
    private String textContent;
    private boolean isJustAfterStringLiteral;
    private transient Optional<ITypeBinding> currentTypeBinding = null;

    DOMCompletionContext(CompilationUnit domUnit, ITypeRoot modelUnit, String textContent, int offset, AssistOptions assistOptions, DOMCompletionEngine.Bindings bindings) {
        this.domUnit = domUnit;
        this.modelUnit = modelUnit;
        this.textContent = textContent;
        boolean isGenerated = DOMCompletionContext.isGenerated((ASTNode)domUnit);
        if (!isGenerated) {
            if (adjustedOffset > 0 && Character.isJavaIdentifierPart(textContent.charAt(adjustedOffset - 1))) {
                --adjustedOffset;
            }
            ASTNode currentNode = NodeFinder.perform((ASTNode)domUnit, (int)adjustedOffset, (int)0);
            adjustedOffset = this.offset;
            if (adjustedOffset >= textContent.length()) {
                adjustedOffset = textContent.length() - 1;
            }
            if (adjustedOffset > 0 && Character.isJavaIdentifierPart(textContent.charAt(adjustedOffset - 1))) {
                --adjustedOffset;
            }
            if (adjustedOffset + 1 >= textContent.length() || !Character.isJavaIdentifierStart(textContent.charAt(adjustedOffset))) {
                while (adjustedOffset > 0 && Character.isWhitespace(textContent.charAt(adjustedOffset - 1))) {
                    --adjustedOffset;
                }
            }
            ASTNode previousNodeBeforeWhitespaces = NodeFinder.perform((ASTNode)domUnit, (int)adjustedOffset, (int)0);
            adjustedOffset = this.offset;
            if (adjustedOffset < textContent.length() - 1 && Character.isWhitespace(textContent.charAt(adjustedOffset))) {
                ++adjustedOffset;
            }
            ASTNode nextNodeAfterWhitespaces = NodeFinder.perform((ASTNode)domUnit, (int)adjustedOffset, (int)0);
            ASTNode commentNode = null;
            for (Comment comment : domUnit.getCommentList()) {
                ASTNode candidateNode;
                if (comment.getParent() != null || comment.getStartPosition() >= this.offset || this.offset >= comment.getStartPosition() + comment.getLength() || (candidateNode = NodeFinder.perform((ASTNode)comment, (int)this.offset, (int)0)) == null) continue;
                commentNode = candidateNode;
                break;
            }
            this.node = commentNode != null ? commentNode : (nextNodeAfterWhitespaces.getLength() == 0 && nextNodeAfterWhitespaces.getParent() == currentNode ? nextNodeAfterWhitespaces : (previousNodeBeforeWhitespaces instanceof SimpleName || previousNodeBeforeWhitespaces instanceof StringLiteral || previousNodeBeforeWhitespaces instanceof CharacterLiteral || previousNodeBeforeWhitespaces instanceof NumberLiteral ? currentNode : previousNodeBeforeWhitespaces));
        } else {
            if (adjustedOffset + 1 <= textContent.length() || !Character.isJavaIdentifierStart(textContent.charAt(adjustedOffset))) {
                for (adjustedOffset = this.offset = offset; adjustedOffset > 0 && Character.isJavaIdentifierStart(textContent.charAt(adjustedOffset - 1)); --adjustedOffset) {
                }
            }
            int length = 0;
            while (adjustedOffset + length <= textContent.length() && Character.isJavaIdentifierStart(textContent.charAt(adjustedOffset + length))) {
                ++length;
            }
            this.node = NodeFinder.perform((ASTNode)domUnit, (int)adjustedOffset, (int)length);
        }
        this.expectedTypes = new ExpectedTypes(assistOptions, this.node, offset);
        this.inJavadoc = DOMCompletionUtils.findParent(this.node, new int[]{29}) != null;
        this.tokenStr = this.tokenBefore(this.textContent);
        this.token = this.tokenStr.toCharArray();
        this.bindingsAcquirer = bindings::all;
        this.isJustAfterStringLiteral = this.node instanceof StringLiteral && this.node.getLength() > 1 && this.offset >= this.node.getStartPosition() + this.node.getLength() && textContent.charAt(this.offset - 1) == '\"';
    }

    private String tokenBefore(String str) {
        StringBuilder builder = new StringBuilder();
        for (int position = Math.min(this.offset, str.length()) - 1; position >= 0 && (Character.isJavaIdentifierPart(str.charAt(position)) || this.inJavadoc && str.charAt(position) == '@'); --position) {
            builder.append(str.charAt(position));
        }
        builder.reverse();
        return builder.toString();
    }

    private IJavaElement computeEnclosingElement(CompilationUnit domUnit, ITypeRoot modelUnit) {
        if (modelUnit == null) {
            return null;
        }
        ITypeRoot enclosingElement1 = modelUnit;
        try {
            enclosingElement1 = modelUnit.getElementAt(this.offset);
        }
        catch (JavaModelException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
        if (enclosingElement1 == null) {
            return modelUnit;
        }
        for (ASTNode node2 = NodeFinder.perform((ASTNode)domUnit, (int)this.offset, (int)0); node2 != null; node2 = node2.getParent()) {
            IJavaElement bindingBasedJavaElement;
            IBinding binding = this.resolveBindingForContext(node2);
            if (binding == null || !enclosingElement1.equals((Object)(bindingBasedJavaElement = binding.getJavaElement()))) continue;
            return bindingBasedJavaElement;
        }
        return enclosingElement1;
    }

    private IBinding resolveBindingForContext(ASTNode nodep) {
        IBinding res = DOMCodeSelector.resolveBinding((ASTNode)nodep);
        if (res != null) {
            return res;
        }
        if (nodep instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)nodep;
            return typeDecl.resolveBinding();
        }
        if (nodep instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration anonymousClassDeclaration = (AnonymousClassDeclaration)nodep;
            return anonymousClassDeclaration.resolveBinding();
        }
        if (nodep instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)nodep;
            return methodDecl.resolveBinding();
        }
        if (nodep instanceof VariableDeclaration) {
            VariableDeclaration varDecl = (VariableDeclaration)nodep;
            return varDecl.resolveBinding();
        }
        return null;
    }

    public int getOffset() {
        return this.offset;
    }

    public char[] getToken() {
        return this.isJustAfterStringLiteral ? null : this.token;
    }

    public String getTokenString() {
        return this.isJustAfterStringLiteral ? null : this.tokenStr;
    }

    public boolean isInJavadoc() {
        return this.inJavadoc;
    }

    public IJavaElement getEnclosingElement() {
        if (!this.enclosingElementComputed) {
            this.enclosingElement = this.computeEnclosingElement(this.domUnit, this.modelUnit);
            this.enclosingElementComputed = true;
        }
        return this.enclosingElement;
    }

    public IJavaElement[] getVisibleElements(String typeSignature) {
        return (IJavaElement[])this.bindingsAcquirer.get().filter(binding -> DOMCompletionContext.matchesSignature(binding, typeSignature)).map(binding -> binding.getJavaElement()).filter(obj -> obj != null).toArray(IJavaElement[]::new);
    }

    public static boolean matchesSignature(IBinding binding, String typeSignature) {
        if (typeSignature == null) {
            return binding instanceof IVariableBinding || binding instanceof IMethodBinding;
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            return DOMCompletionContext.castCompatable(variableBinding.getType(), typeSignature);
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)binding;
            return DOMCompletionContext.castCompatable(methodBinding.getReturnType(), typeSignature);
        }
        return false;
    }

    public char[][] getExpectedTypesKeys() {
        if (this.isJustAfterStringLiteral) {
            return null;
        }
        char[][] res = (char[][])this.expectedTypes.getExpectedTypes().stream().map(IBinding::getKey).map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
        return res.length == 0 ? null : res;
    }

    public char[][] getExpectedTypesSignatures() {
        if (this.isJustAfterStringLiteral) {
            return null;
        }
        char[][] res = (char[][])this.expectedTypes.getExpectedTypes().stream().map(binding -> binding.isTypeVariable() ? "T" + binding.getQualifiedName() + ";" : (binding.isLocal() ? Signature.createTypeSignature((String)binding.getName(), (boolean)true) : Signature.createTypeSignature((String)binding.getQualifiedName(), (boolean)true))).map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
        return res.length == 0 ? null : res;
    }

    public boolean isExtended() {
        return true;
    }

    public int getTokenLocation() {
        for (ASTNode wrappingNode = this.node; wrappingNode != null; wrappingNode = wrappingNode.getParent()) {
            if (wrappingNode instanceof ImportDeclaration) {
                return 8;
            }
            if (wrappingNode instanceof ClassInstanceCreation) {
                ClassInstanceCreation newObj = (ClassInstanceCreation)wrappingNode;
                return this.getTokenStart() <= newObj.getType().getStartPosition() ? 4 : 0;
            }
            if (wrappingNode instanceof Statement) {
                Statement stmt = (Statement)wrappingNode;
                if (this.getTokenStart() == stmt.getStartPosition()) {
                    return this.getTokenStart() == stmt.getStartPosition() ? 2 : 0;
                }
            }
            if (wrappingNode instanceof BodyDeclaration) {
                boolean wrapperNodeIsTypeDecl;
                boolean wrapperParentIsTypeDecl;
                BodyDeclaration member = (BodyDeclaration)wrappingNode;
                boolean bl = wrapperParentIsTypeDecl = member.getParent() instanceof AbstractTypeDeclaration || member.getParent() instanceof AnonymousClassDeclaration;
                if (wrapperParentIsTypeDecl && this.getTokenStart() == member.getStartPosition()) {
                    return 1;
                }
                boolean bl2 = wrapperNodeIsTypeDecl = wrappingNode instanceof AbstractTypeDeclaration || wrappingNode instanceof AnonymousClassDeclaration;
                if (wrapperNodeIsTypeDecl && this.isWithinTypeDeclarationBody(wrappingNode, this.textContent, this.offset)) {
                    return 1;
                }
                return 0;
            }
            if (wrappingNode instanceof Block) {
                Block block = (Block)wrappingNode;
                return block.statements().isEmpty() ? 2 : 0;
            }
            if (!(wrappingNode instanceof AnonymousClassDeclaration)) continue;
            AnonymousClassDeclaration anon = (AnonymousClassDeclaration)wrappingNode;
            if (!this.isWithinTypeDeclarationBody(wrappingNode, this.textContent, this.offset)) continue;
            return 1;
        }
        return 0;
    }

    private boolean isWithinTypeDeclarationBody(ASTNode n, String str, int offset2) {
        if (str != null) {
            if (n instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration atd = (AbstractTypeDeclaration)n;
                int nameEndOffset = atd.getName().getStartPosition() + atd.getName().getLength();
                int bodyStart = this.findFirstOpenBracketFromIndex(str, nameEndOffset);
                int bodyEnd = atd.getStartPosition() + atd.getLength() - 1;
                return bodyEnd > bodyStart && offset2 > bodyStart && offset2 < bodyEnd;
            }
            if (n instanceof AnonymousClassDeclaration) {
                AnonymousClassDeclaration acd = (AnonymousClassDeclaration)n;
                int bodyStart = this.findFirstOpenBracketFromIndex(str, acd.getStartPosition());
                int bodyEnd = acd.getStartPosition() + acd.getLength() - 1;
                return bodyEnd > bodyStart && offset2 > bodyStart && offset2 < bodyEnd;
            }
        }
        return false;
    }

    private int findFirstOpenBracketFromIndex(String str, int start) {
        int bodyStart;
        for (bodyStart = start; bodyStart < str.length() && str.charAt(bodyStart) != '{'; ++bodyStart) {
        }
        return bodyStart;
    }

    public int getTokenStart() {
        SimpleName name;
        if (this.isJustAfterStringLiteral) {
            return -1;
        }
        if (this.node instanceof StringLiteral) {
            return this.node.getStartPosition();
        }
        ASTNode aSTNode = this.node;
        if (aSTNode instanceof SimpleName && !Arrays.equals((name = (SimpleName)aSTNode).getIdentifier().toCharArray(), RecoveryScanner.FAKE_IDENTIFIER)) {
            return this.node.getStartPosition();
        }
        return this.offset - this.getToken().length;
    }

    public int getTokenEnd() {
        int position;
        if (this.isJustAfterStringLiteral) {
            return -1;
        }
        if (this.node.getLength() == 0) {
            return this.offset - 1;
        }
        if (this.node instanceof SimpleName || this.node instanceof StringLiteral) {
            return this.node.getStartPosition() + this.node.getLength() - 1;
        }
        for (position = this.offset; position < this.textContent.length() && Character.isJavaIdentifierPart(this.textContent.charAt(position)); ++position) {
        }
        return position - 1;
    }

    public int getTokenKind() {
        if (this.isJustAfterStringLiteral) {
            return 0;
        }
        return this.node instanceof StringLiteral ? 2 : 1;
    }

    public boolean canUseDiamond(String[] parameterTypes, char[][] typeVariables) {
        char[][] expectedTypekeys = this.getExpectedTypesKeys();
        if (expectedTypekeys == null || expectedTypekeys.length == 0) {
            return true;
        }
        if (typeVariables != null) {
            for (String parameterType : parameterTypes) {
                for (char[] typeVariable : typeVariables) {
                    if (!CharOperation.equals((char[])parameterType.toCharArray(), (char[])typeVariable)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canUseDiamond(String[] parameterTypes, char[] fullyQualifiedTypeName) {
        String[] stringArray;
        ITypeBinding guessedType = null;
        char[][] expectedTypekeys = this.getExpectedTypesKeys();
        if (expectedTypekeys == null || expectedTypekeys.length == 0) {
            return true;
        }
        Optional<IBinding> potentialMatch = this.bindingsAcquirer.get().filter(binding -> {
            for (char[] expectedTypekey : expectedTypekeys) {
                if (!CharOperation.equals((char[])expectedTypekey, (char[])binding.getKey().toCharArray())) continue;
                return true;
            }
            return false;
        }).findFirst();
        if (potentialMatch.isPresent() && (stringArray = potentialMatch.get()) instanceof ITypeBinding) {
            ITypeBinding match;
            guessedType = match = (ITypeBinding)stringArray;
        }
        if (guessedType != null && !guessedType.isRecovered()) {
            guessedType = guessedType.getErasure();
            ITypeBinding[] typeVars = guessedType.getTypeParameters();
            for (String parameterType : parameterTypes) {
                for (ITypeBinding typeVar : typeVars) {
                    if (!CharOperation.equals((char[])parameterType.toCharArray(), (char[])typeVar.getName().toCharArray())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ITypeBinding getCurrentTypeBinding() {
        if (this.currentTypeBinding == null) {
            ASTNode parentType = DOMCompletionUtils.findParent(this.node, new int[]{55, 71, 103, 81, 1});
            if (parentType instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration abstractTypeDecl = (AbstractTypeDeclaration)parentType;
                this.currentTypeBinding = Optional.of(abstractTypeDecl.resolveBinding());
            } else if (parentType instanceof AnonymousClassDeclaration) {
                AnonymousClassDeclaration anonTypeDecl = (AnonymousClassDeclaration)parentType;
                this.currentTypeBinding = Optional.of(anonTypeDecl.resolveBinding());
            } else {
                this.currentTypeBinding = Optional.empty();
            }
        }
        return this.currentTypeBinding.orElse(null);
    }

    private static boolean castCompatable(ITypeBinding typeBinding, String sig2) {
        ITypeBinding[] sig1 = typeBinding.getKey().replace('/', '.');
        String sig1Raw = new String(Signature.getTypeErasure((char[])sig1.toCharArray()));
        switch (sig1) {
            case "J": {
                return sig2.equals("J") || sig2.equals("D") || sig2.equals("F");
            }
            case "I": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("D") || sig2.equals("F");
            }
            case "S": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("S") || sig2.equals("D") || sig2.equals("F");
            }
            case "B": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("B") || sig2.equals("D") || sig2.equals("F");
            }
            case "D": 
            case "F": {
                return sig2.equals("D") || sig2.equals("F");
            }
        }
        if (sig1.equals(sig2) || sig1Raw.equals(sig2)) {
            return true;
        }
        if (typeBinding.getSuperclass() != null && DOMCompletionContext.castCompatable(typeBinding.getSuperclass(), sig2)) {
            return true;
        }
        for (ITypeBinding superInterface : typeBinding.getInterfaces()) {
            if (!DOMCompletionContext.castCompatable(superInterface, sig2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGenerated(ASTNode node) {
        if (node != null) {
            final boolean[] isGenerated = new boolean[]{false};
            node.accept(new ASTVisitor(){

                public void endVisit(MarkerAnnotation markerAnnotation) {
                    if (!isGenerated[0]) {
                        isGenerated[0] = "lombok.Generated".equals(markerAnnotation.getTypeName().getFullyQualifiedName());
                        super.endVisit(markerAnnotation);
                    }
                }
            });
            return isGenerated[0];
        }
        return false;
    }
}

