/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.filesystem;

import java.net.URI;
import java.nio.file.Paths;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ls.core.internal.filesystem.JLSFile;
import org.eclipse.jdt.ls.core.internal.filesystem.JLSFsUtils;

public class JLSFileSystem
extends LocalFileSystem {
    public IFileStore getStore(IPath path) {
        if (JLSFsUtils.shouldStoreInMetadataArea(path)) {
            IPath containerPath = JLSFsUtils.getContainerPath(path);
            String projectName = JLSFsUtils.getProjectNameIfLocationIsProjectRoot(containerPath);
            if (projectName == null) {
                return new JLSFile(path.toFile());
            }
            IPath redirectedPath = JLSFsUtils.getMetaDataFilePath(projectName, path);
            if (redirectedPath != null) {
                return new JLSFile(redirectedPath.toFile());
            }
        }
        return new JLSFile(path.toFile());
    }

    public IFileStore getStore(URI uri) {
        IPath path = JLSFileSystem.filePathFromURI(uri.toString());
        return path == null ? super.getStore(uri) : this.getStore(path);
    }

    public static IPath filePathFromURI(String uriStr) {
        URI uri = URI.create(uriStr);
        return "file".equals(uri.getScheme()) ? Path.fromOSString((String)Paths.get(uri).toString()) : null;
    }
}

