/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.event.ListenerNotificationException;
import org.gradle.internal.operations.BuildOperationInvocationException;

public abstract class AbstractBroadcastDispatch<T>
implements Dispatch<MethodInvocation> {
    protected final Class<T> type;

    public AbstractBroadcastDispatch(Class<T> type) {
        this.type = type;
    }

    private String getErrorMessage() {
        String typeDescription = this.type.getSimpleName().replaceAll("(\\p{Upper})", " $1").trim().toLowerCase();
        return "Failed to notify " + typeDescription + ".";
    }

    protected void dispatch(MethodInvocation invocation, Dispatch<MethodInvocation> handler) {
        try {
            handler.dispatch(invocation);
        }
        catch (UncheckedException e) {
            throw new ListenerNotificationException(invocation, this.getErrorMessage(), Collections.singletonList(e.getCause()));
        }
        catch (BuildOperationInvocationException e) {
            throw new ListenerNotificationException(invocation, this.getErrorMessage(), Collections.singletonList(e.getCause()));
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new ListenerNotificationException(invocation, this.getErrorMessage(), Collections.singletonList(t));
        }
    }

    protected void dispatch(MethodInvocation invocation, List<? extends Dispatch<MethodInvocation>> dispatchers) {
        switch (dispatchers.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.dispatch(invocation, dispatchers.get(0));
                break;
            }
            default: {
                this.dispatch(invocation, dispatchers.iterator());
            }
        }
    }

    private void dispatch(MethodInvocation invocation, Iterator<? extends Dispatch<MethodInvocation>> handlers) {
        ArrayList<Throwable> failures = null;
        while (handlers.hasNext()) {
            Dispatch<MethodInvocation> handler = handlers.next();
            try {
                handler.dispatch(invocation);
            }
            catch (ListenerNotificationException e) {
                if (failures == null) {
                    failures = new ArrayList<Throwable>();
                }
                if (e.getEvent() == invocation) {
                    failures.addAll(e.getCauses());
                    continue;
                }
                failures.add(e);
            }
            catch (UncheckedException e) {
                if (failures == null) {
                    failures = new ArrayList();
                }
                failures.add(e.getCause());
            }
            catch (Throwable t) {
                if (failures == null) {
                    failures = new ArrayList();
                }
                failures.add(t);
            }
        }
        if (failures == null) {
            return;
        }
        if (failures.size() == 1 && failures.get(0) instanceof RuntimeException) {
            throw (RuntimeException)failures.get(0);
        }
        throw new ListenerNotificationException(invocation, this.getErrorMessage(), failures);
    }
}

