/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.m2e.core.internal.embedder.FilterRepositorySystemSession;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ProjectCachePlunger<Key> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final Map<File, Set<Key>> projectKeys = new HashMap<File, Set<Key>>();
    final Map<Key, Set<File>> keyProjects = new HashMap<Key, Set<File>>();

    ProjectCachePlunger() {
    }

    public void register(MavenProject project, Key cacheKey) {
        File file = project.getFile();
        if (file != null) {
            this.projectKeys.computeIfAbsent(file, f -> new HashSet()).add(cacheKey);
            this.keyProjects.computeIfAbsent(cacheKey, f -> new HashSet()).add(file);
        }
    }

    public Set<File> removeProject(File pom, boolean forceDependencyUpdate) {
        FilterRepositorySystemSession session;
        MavenExecutionContext context = MavenExecutionContext.getThreadContext();
        FilterRepositorySystemSession filterRepositorySystemSession = session = context != null ? context.getRepositorySession() : null;
        if (forceDependencyUpdate && session == null) {
            throw new IllegalArgumentException();
        }
        HashSet<File> affectedProjects = new HashSet<File>();
        for (Key cacheKey : ProjectCachePlunger.removeAll(this.projectKeys, pom)) {
            ProjectCachePlunger.remove(this.keyProjects, cacheKey, pom);
            if (forceDependencyUpdate && "always".equals(session.getUpdatePolicy()) && session.getCache().get((RepositorySystemSession)session, cacheKey) == null) {
                session.getCache().put((RepositorySystemSession)session, cacheKey, (Object)Boolean.TRUE);
                for (File affectedPom : ProjectCachePlunger.removeAll(this.keyProjects, cacheKey)) {
                    affectedProjects.add(affectedPom);
                    ProjectCachePlunger.remove(this.projectKeys, affectedPom, cacheKey);
                }
            }
            if (this.keyProjects.containsKey(cacheKey)) continue;
            this.flush(cacheKey);
            this.log.debug("Flushed cache entry for {}", cacheKey);
        }
        return affectedProjects;
    }

    private static <K, V> Set<V> removeAll(Map<K, Set<V>> map, K key) {
        Set<V> removed = map.remove(key);
        return removed != null ? removed : Collections.emptySet();
    }

    private static <K, V> void remove(Map<K, Set<V>> map, K key, V value) {
        map.computeIfPresent(key, (k, values) -> {
            values.remove(value);
            return values.isEmpty() ? null : values;
        });
    }

    protected void disposeClassRealm(ClassRealm realm) {
        try {
            realm.getWorld().disposeRealm(realm.getId());
        }
        catch (NoSuchRealmException noSuchRealmException) {
            // empty catch block
        }
    }

    protected abstract void flush(Key var1);

    public void flush() {
        this.projectKeys.clear();
        this.keyProjects.clear();
    }
}

