/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class NavigateToTypeDefinitionHandler {
    public List<? extends Location> typeDefinition(TextDocumentPositionParams position, IProgressMonitor monitor) {
        List<Location> list;
        ITypeRoot unit = null;
        try {
            PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
            boolean returnCompilationUnit = preferenceManager == null ? false : preferenceManager.isClientSupportsClassFileContent() && preferenceManager.getPreferences().isIncludeDecompiledSources();
            unit = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri(), returnCompilationUnit, monitor);
            Location location = null;
            if (unit != null && !monitor.isCanceled()) {
                location = this.computeTypeDefinitionNavigation(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
            }
            list = location == null ? null : Arrays.asList(location);
        }
        catch (Throwable throwable) {
            JDTUtils.discardClassFileWorkingCopy(unit);
            throw throwable;
        }
        JDTUtils.discardClassFileWorkingCopy(unit);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Location computeTypeDefinitionNavigation(ITypeRoot unit, int line, int column, IProgressMonitor monitor) {
        try {
            CompilationUnit ast = CoreASTProvider.getInstance().getAST(unit, CoreASTProvider.WAIT_YES, monitor);
            int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), line, column);
            if (ast == null) return null;
            if (offset < 0) {
                return null;
            }
            NodeFinder finder = new NodeFinder((ASTNode)ast, offset, 0);
            ASTNode coveringNode = finder.getCoveringNode();
            if (!(coveringNode instanceof SimpleName)) return null;
            SimpleName name = (SimpleName)coveringNode;
            IBinding resolvedBinding = name.resolveBinding();
            if (resolvedBinding == null) return null;
            ITypeBinding typeBinding = null;
            if (resolvedBinding instanceof IVariableBinding) {
                IVariableBinding variableBinding = (IVariableBinding)resolvedBinding;
                typeBinding = variableBinding.getType();
            } else if (resolvedBinding instanceof ITypeBinding) {
                ITypeBinding resolvedTypeBinding;
                typeBinding = resolvedTypeBinding = (ITypeBinding)resolvedBinding;
            }
            if (typeBinding == null) return null;
            if (typeBinding.getJavaElement() == null) return null;
            IJavaElement element = typeBinding.getJavaElement();
            ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
            IClassFile cf = (IClassFile)element.getAncestor(6);
            if (compilationUnit != null || cf != null && cf.getSourceRange() != null) {
                if (compilationUnit == null) return JDTUtils.toLocation(element);
                if (compilationUnit.getResource() == null) return JDTUtils.toLocation(element);
                if (compilationUnit.getResource().exists()) return JDTUtils.toLocation(element);
                String fqn = compilationUnit.findPrimaryType().getFullyQualifiedName();
                IType type = compilationUnit.getJavaProject().findType(fqn);
                if (type.getClassFile() == null) return null;
                String uriString = JDTUtils.toUri((IClassFile)type.getClassFile());
                Location location = JDTUtils.toLocation(element);
                location.setUri(uriString);
                return location;
            }
            if (!(element instanceof IMember)) return null;
            IMember member = (IMember)element;
            if (member.getClassFile() == null) return null;
            List<Location> locations = JDTUtils.searchDecompiledSources(element, cf, true, true, (IProgressMonitor)new NullProgressMonitor());
            if (locations.isEmpty()) return JDTUtils.toLocation(member.getClassFile());
            return locations.get(0);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem computing typeDefinition for" + unit.getElementName(), e);
        }
        return null;
    }
}

