"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_dev-container_lib_electron-browser_dev-container-frontend-module_js"],{

/***/ "../../node_modules/@theia/dev-container/lib/electron-browser/container-connection-contribution.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/dev-container/lib/electron-browser/container-connection-contribution.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContainerConnectionContribution = exports.RemoteContainerCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const remote_registry_contribution_1 = __webpack_require__(/*! @theia/remote/lib/electron-browser/remote-registry-contribution */ "../../node_modules/@theia/remote/lib/electron-browser/remote-registry-contribution.js");
const remote_container_connection_provider_1 = __webpack_require__(/*! ../electron-common/remote-container-connection-provider */ "../../node_modules/@theia/dev-container/lib/electron-common/remote-container-connection-provider.js");
const remote_preferences_1 = __webpack_require__(/*! @theia/remote/lib/electron-browser/remote-preferences */ "../../node_modules/@theia/remote/lib/electron-browser/remote-preferences.js");
const workspace_storage_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-storage-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-storage-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const container_output_provider_1 = __webpack_require__(/*! ./container-output-provider */ "../../node_modules/@theia/dev-container/lib/electron-browser/container-output-provider.js");
const common_1 = __webpack_require__(/*! @theia/workspace/lib/common */ "../../node_modules/@theia/workspace/lib/common/index.js");
const dev_container_workspaces_1 = __webpack_require__(/*! ../electron-common/dev-container-workspaces */ "../../node_modules/@theia/dev-container/lib/electron-common/dev-container-workspaces.js");
var RemoteContainerCommands;
(function (RemoteContainerCommands) {
    RemoteContainerCommands.REOPEN_IN_CONTAINER = core_1.Command.toLocalizedCommand({
        id: 'dev-container:reopen-in-container',
        label: 'Reopen in Container',
        category: 'Dev Container'
    }, 'theia/dev-container/connect');
})(RemoteContainerCommands || (exports.RemoteContainerCommands = RemoteContainerCommands = {}));
const LAST_USED_CONTAINER = 'lastUsedContainer';
let ContainerConnectionContribution = class ContainerConnectionContribution extends remote_registry_contribution_1.AbstractRemoteRegistryContribution {
    registerRemoteCommands(registry) {
        registry.registerCommand(RemoteContainerCommands.REOPEN_IN_CONTAINER, {
            execute: () => this.openInContainer()
        });
    }
    canHandle(uri) {
        return uri.scheme === dev_container_workspaces_1.DEV_CONTAINER_WORKSPACE_SCHEME;
    }
    async openWorkspace(uri, options) {
        const filePath = new URLSearchParams(uri.query).get(dev_container_workspaces_1.DEV_CONTAINER_PATH_QUERY);
        if (!filePath) {
            throw new Error('No devcontainer file specified for workspace');
        }
        const devcontainerFiles = await this.connectionProvider.getDevContainerFiles(uri.path.toString());
        const devcontainerFile = devcontainerFiles.find(file => file.path === filePath);
        if (!devcontainerFile) {
            throw new Error(`Devcontainer file at ${filePath} not found in workspace`);
        }
        return this.doOpenInContainer(devcontainerFile, uri.path.toString());
    }
    async getWorkspaceLabel(uri) {
        const containerFilePath = new URLSearchParams(uri.query).get(dev_container_workspaces_1.DEV_CONTAINER_PATH_QUERY);
        if (!containerFilePath) {
            return;
        }
        ;
        const files = await this.connectionProvider.getDevContainerFiles(uri.path.toString());
        const devcontainerFile = files.find(file => file.path === containerFilePath);
        return `${uri.path.base} [Dev Container: ${devcontainerFile === null || devcontainerFile === void 0 ? void 0 : devcontainerFile.name}]`;
    }
    async openInContainer() {
        const devcontainerFile = await this.getOrSelectDevcontainerFile();
        if (!devcontainerFile) {
            return;
        }
        this.doOpenInContainer(devcontainerFile);
    }
    async doOpenInContainer(devcontainerFile, workspacePath) {
        var _a;
        const lastContainerInfoKey = `${LAST_USED_CONTAINER}:${devcontainerFile.path}`;
        const lastContainerInfo = await this.workspaceStorageService.getData(lastContainerInfoKey);
        this.containerOutputProvider.openChannel();
        const connectionResult = await this.connectionProvider.connectToContainer({
            nodeDownloadTemplate: this.remotePreferences['remote.nodeDownloadTemplate'],
            lastContainerInfo,
            devcontainerFile: devcontainerFile.path,
            workspacePath: workspacePath
        });
        this.workspaceStorageService.setData(lastContainerInfoKey, {
            id: connectionResult.containerId,
            lastUsed: Date.now()
        });
        this.workspaceServer.setMostRecentlyUsedWorkspace(`${dev_container_workspaces_1.DEV_CONTAINER_WORKSPACE_SCHEME}:${workspacePath !== null && workspacePath !== void 0 ? workspacePath : (_a = this.workspaceService.workspace) === null || _a === void 0 ? void 0 : _a.resource.path}?${dev_container_workspaces_1.DEV_CONTAINER_PATH_QUERY}=${devcontainerFile.path}`);
        this.openRemote(connectionResult.port, false, connectionResult.workspacePath);
    }
    async getOrSelectDevcontainerFile() {
        var _a;
        const workspace = this.workspaceService.workspace;
        if (!workspace) {
            return;
        }
        const devcontainerFiles = await this.connectionProvider.getDevContainerFiles(workspace.resource.path.toString());
        if (devcontainerFiles.length === 1) {
            return devcontainerFiles[0];
        }
        return (_a = (await this.quickInputService.pick(devcontainerFiles.map(file => ({
            type: 'item',
            label: file.name,
            description: file.path,
            file: file,
        })), {
            title: 'Select a devcontainer.json file'
        }))) === null || _a === void 0 ? void 0 : _a.file;
    }
};
exports.ContainerConnectionContribution = ContainerConnectionContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_container_connection_provider_1.RemoteContainerConnectionProvider),
    tslib_1.__metadata("design:type", Object)
], ContainerConnectionContribution.prototype, "connectionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_preferences_1.RemotePreferences),
    tslib_1.__metadata("design:type", Object)
], ContainerConnectionContribution.prototype, "remotePreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_storage_service_1.WorkspaceStorageService),
    tslib_1.__metadata("design:type", workspace_storage_service_1.WorkspaceStorageService)
], ContainerConnectionContribution.prototype, "workspaceStorageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], ContainerConnectionContribution.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.WorkspaceServer),
    tslib_1.__metadata("design:type", Object)
], ContainerConnectionContribution.prototype, "workspaceServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], ContainerConnectionContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(container_output_provider_1.ContainerOutputProvider),
    tslib_1.__metadata("design:type", container_output_provider_1.ContainerOutputProvider)
], ContainerConnectionContribution.prototype, "containerOutputProvider", void 0);
exports.ContainerConnectionContribution = ContainerConnectionContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContainerConnectionContribution);


/***/ }),

/***/ "../../node_modules/@theia/dev-container/lib/electron-browser/container-info-contribution.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/dev-container/lib/electron-browser/container-info-contribution.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContainerInfoContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const remote_status_service_1 = __webpack_require__(/*! @theia/remote/lib/electron-common/remote-status-service */ "../../node_modules/@theia/remote/lib/electron-common/remote-status-service.js");
const remote_container_connection_provider_1 = __webpack_require__(/*! ../electron-common/remote-container-connection-provider */ "../../node_modules/@theia/dev-container/lib/electron-common/remote-container-connection-provider.js");
const port_forwarding_service_1 = __webpack_require__(/*! @theia/remote/lib/electron-browser/port-forwarding/port-forwarding-service */ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-service.js");
const dev_container_workspaces_1 = __webpack_require__(/*! ../electron-common/dev-container-workspaces */ "../../node_modules/@theia/dev-container/lib/electron-common/dev-container-workspaces.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let ContainerInfoContribution = class ContainerInfoContribution {
    async onStart() {
        var _a, _b;
        const containerPort = parseInt((_a = new URLSearchParams(location.search).get('port')) !== null && _a !== void 0 ? _a : '0');
        const containerInfo = await this.connectionProvider.getCurrentContainerInfo(containerPort);
        this.status = await this.remoteStatusService.getStatus(containerPort);
        this.portForwardingService.forwardedPorts = Object.entries((_b = containerInfo === null || containerInfo === void 0 ? void 0 : containerInfo.NetworkSettings.Ports) !== null && _b !== void 0 ? _b : {}).flatMap(([_, ports]) => (ports.map(port => {
            var _a, _b;
            return ({
                editing: false,
                address: (_a = port.HostIp) !== null && _a !== void 0 ? _a : '',
                localPort: parseInt((_b = port.HostPort) !== null && _b !== void 0 ? _b : '0'),
                origin: 'container'
            });
        })));
    }
    enhanceTitle(title, parts) {
        if (this.status && this.status.alive) {
            const devcontainerName = this.status.name;
            title = `${title} [Dev Container${devcontainerName ? ': ' + devcontainerName : ''}]`;
        }
        return title;
    }
    canHandle(element) {
        if ('query' in element) {
            let containerFilePath = new URLSearchParams(element.query).get(dev_container_workspaces_1.DEV_CONTAINER_PATH_QUERY);
            if (containerFilePath) {
                if (containerFilePath.startsWith(element.path.toString())) {
                    containerFilePath = containerFilePath.replace(element.path.toString(), '');
                }
                this.containerFilePath = containerFilePath;
                return 100;
            }
            ;
            return 0;
        }
        return 0;
    }
    getName(element) {
        const dir = new core_1.URI(this.containerFilePath).path.dir.base;
        return `${element.path.base} [Dev Container${dir && dir !== '.devcontainer' ? `: ${dir}` : ''}]`;
    }
};
exports.ContainerInfoContribution = ContainerInfoContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_container_connection_provider_1.RemoteContainerConnectionProvider),
    tslib_1.__metadata("design:type", Object)
], ContainerInfoContribution.prototype, "connectionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(port_forwarding_service_1.PortForwardingService),
    tslib_1.__metadata("design:type", port_forwarding_service_1.PortForwardingService)
], ContainerInfoContribution.prototype, "portForwardingService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_status_service_1.RemoteStatusService),
    tslib_1.__metadata("design:type", Object)
], ContainerInfoContribution.prototype, "remoteStatusService", void 0);
exports.ContainerInfoContribution = ContainerInfoContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContainerInfoContribution);


/***/ }),

/***/ "../../node_modules/@theia/dev-container/lib/electron-browser/container-output-provider.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/dev-container/lib/electron-browser/container-output-provider.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContainerOutputProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const output_channel_1 = __webpack_require__(/*! @theia/output/lib/browser/output-channel */ "../../node_modules/@theia/output/lib/browser/output-channel.js");
let ContainerOutputProvider = class ContainerOutputProvider {
    openChannel() {
        this.currentChannel = this.outputChannelManager.getChannel('Container');
        this.currentChannel.show();
    }
    ;
    onRemoteOutput(output) {
        var _a;
        (_a = this.currentChannel) === null || _a === void 0 ? void 0 : _a.appendLine(output);
    }
};
exports.ContainerOutputProvider = ContainerOutputProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(output_channel_1.OutputChannelManager),
    tslib_1.__metadata("design:type", output_channel_1.OutputChannelManager)
], ContainerOutputProvider.prototype, "outputChannelManager", void 0);
exports.ContainerOutputProvider = ContainerOutputProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContainerOutputProvider);


/***/ }),

/***/ "../../node_modules/@theia/dev-container/lib/electron-browser/dev-container-frontend-module.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/dev-container/lib/electron-browser/dev-container-frontend-module.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const remote_registry_contribution_1 = __webpack_require__(/*! @theia/remote/lib/electron-browser/remote-registry-contribution */ "../../node_modules/@theia/remote/lib/electron-browser/remote-registry-contribution.js");
const remote_container_connection_provider_1 = __webpack_require__(/*! ../electron-common/remote-container-connection-provider */ "../../node_modules/@theia/dev-container/lib/electron-common/remote-container-connection-provider.js");
const container_connection_contribution_1 = __webpack_require__(/*! ./container-connection-contribution */ "../../node_modules/@theia/dev-container/lib/electron-browser/container-connection-contribution.js");
const service_connection_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/messaging/service-connection-provider */ "../../node_modules/@theia/core/lib/browser/messaging/service-connection-provider.js");
const container_output_provider_1 = __webpack_require__(/*! ./container-output-provider */ "../../node_modules/@theia/dev-container/lib/electron-browser/container-output-provider.js");
const container_info_contribution_1 = __webpack_require__(/*! ./container-info-contribution */ "../../node_modules/@theia/dev-container/lib/electron-browser/container-info-contribution.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const window_title_service_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-title-service */ "../../node_modules/@theia/core/lib/browser/window/window-title-service.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(container_connection_contribution_1.ContainerConnectionContribution).toSelf().inSingletonScope();
    bind(remote_registry_contribution_1.RemoteRegistryContribution).toService(container_connection_contribution_1.ContainerConnectionContribution);
    bind(workspace_service_1.WorkspaceOpenHandlerContribution).toService(container_connection_contribution_1.ContainerConnectionContribution);
    bind(container_output_provider_1.ContainerOutputProvider).toSelf().inSingletonScope();
    bind(remote_container_connection_provider_1.RemoteContainerConnectionProvider).toDynamicValue(ctx => {
        const outputProvider = ctx.container.get(container_output_provider_1.ContainerOutputProvider);
        return service_connection_provider_1.ServiceConnectionProvider.createLocalProxy(ctx.container, remote_container_connection_provider_1.RemoteContainerConnectionProviderPath, outputProvider);
    }).inSingletonScope();
    bind(container_info_contribution_1.ContainerInfoContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(container_info_contribution_1.ContainerInfoContribution);
    bind(window_title_service_1.WindowTitleContribution).toService(container_info_contribution_1.ContainerInfoContribution);
    bind(browser_1.LabelProviderContribution).toService(container_info_contribution_1.ContainerInfoContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/dev-container/lib/electron-common/dev-container-workspaces.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@theia/dev-container/lib/electron-common/dev-container-workspaces.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DEV_CONTAINER_PATH_QUERY = exports.DEV_CONTAINER_WORKSPACE_SCHEME = void 0;
exports.DEV_CONTAINER_WORKSPACE_SCHEME = 'devcontainer';
exports.DEV_CONTAINER_PATH_QUERY = 'containerfile';


/***/ }),

/***/ "../../node_modules/@theia/dev-container/lib/electron-common/remote-container-connection-provider.js":
/*!***********************************************************************************************************!*\
  !*** ../../node_modules/@theia/dev-container/lib/electron-common/remote-container-connection-provider.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteContainerConnectionProvider = exports.RemoteContainerConnectionProviderPath = void 0;
// *****************************************************************************
exports.RemoteContainerConnectionProviderPath = '/remote/container';
exports.RemoteContainerConnectionProvider = Symbol('RemoteContainerConnectionProvider');


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-storage-service.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-storage-service.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceStorageService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const storage_service_1 = __webpack_require__(/*! @theia/core/lib/browser/storage-service */ "../../node_modules/@theia/core/lib/browser/storage-service.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
/*
 * Prefixes any stored data with the current workspace path.
 */
let WorkspaceStorageService = class WorkspaceStorageService {
    init() {
        this.initialized = this.workspaceService.roots.then(() => {
            this.updatePrefix();
            this.workspaceService.onWorkspaceLocationChanged(() => this.updatePrefix());
        });
    }
    async setData(key, data) {
        if (!this.prefix) {
            await this.initialized;
        }
        const fullKey = this.prefixWorkspaceURI(key);
        return this.storageService.setData(fullKey, data);
    }
    async getData(key, defaultValue) {
        await this.initialized;
        const fullKey = this.prefixWorkspaceURI(key);
        return this.storageService.getData(fullKey, defaultValue);
    }
    prefixWorkspaceURI(originalKey) {
        return `${this.prefix}:${originalKey}`;
    }
    getPrefix(workspaceStat) {
        return workspaceStat ? workspaceStat.resource.toString() : '_global_';
    }
    updatePrefix() {
        this.prefix = this.getPrefix(this.workspaceService.workspace);
    }
};
exports.WorkspaceStorageService = WorkspaceStorageService;
tslib_1.__decorate([
    (0, inversify_1.inject)(storage_service_1.LocalStorageService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceStorageService.prototype, "storageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceStorageService.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], WorkspaceStorageService.prototype, "init", null);
exports.WorkspaceStorageService = WorkspaceStorageService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceStorageService);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_dev-container_lib_electron-browser_dev-container-frontend-module_js.js.map