/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class CipherSpi {
    protected abstract void engineSetMode(String var1) throws NoSuchAlgorithmException;

    protected abstract void engineSetPadding(String var1) throws NoSuchPaddingException;

    protected abstract int engineGetBlockSize();

    protected abstract int engineGetOutputSize(int var1);

    protected abstract byte[] engineGetIV();

    protected abstract AlgorithmParameters engineGetParameters();

    protected abstract void engineInit(int var1, Key var2, SecureRandom var3) throws InvalidKeyException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameters var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract byte[] engineUpdate(byte[] var1, int var2, int var3);

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        try {
            return this.bufferCrypt(byteBuffer, byteBuffer2, true);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new ProviderException("Internal error in update()");
        }
        catch (BadPaddingException badPaddingException) {
            throw new ProviderException("Internal error in update()");
        }
    }

    protected abstract byte[] engineDoFinal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException;

    protected abstract int engineDoFinal(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException;

    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.bufferCrypt(byteBuffer, byteBuffer2, false);
    }

    static int getTempArraySize(int n) {
        return Math.min(4096, n);
    }

    private int bufferCrypt(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException("Input and output buffers must not be null");
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        int n3 = n2 - n;
        if (bl && n3 == 0) {
            return 0;
        }
        int n4 = this.engineGetOutputSize(n3);
        if (byteBuffer2.remaining() < n4) {
            throw new ShortBufferException("Need at least " + n4 + " bytes of space in output buffer");
        }
        boolean bl2 = byteBuffer.hasArray();
        boolean bl3 = byteBuffer2.hasArray();
        int n5 = 0;
        if (bl3) {
            byte[] byArray = byteBuffer2.array();
            int n6 = byteBuffer2.position();
            int n7 = byteBuffer2.arrayOffset() + n6;
            if (bl2) {
                byte[] byArray2 = byteBuffer.array();
                int n8 = byteBuffer.arrayOffset() + n;
                n5 = bl ? this.engineUpdate(byArray2, n8, n3, byArray, n7) : this.engineDoFinal(byArray2, n8, n3, byArray, n7);
                byteBuffer.position(n2);
            } else {
                int n9;
                byte[] byArray3 = new byte[CipherSpi.getTempArraySize(n3)];
                do {
                    if ((n9 = Math.min(n3, byArray3.length)) > 0) {
                        byteBuffer.get(byArray3, 0, n9);
                    }
                    int n10 = bl || n3 > n9 ? this.engineUpdate(byArray3, 0, n9, byArray, n7) : this.engineDoFinal(byArray3, 0, n9, byArray, n7);
                    n5 += n10;
                    n7 += n10;
                } while ((n3 -= n9) > 0);
            }
            byteBuffer2.position(n6 + n5);
        } else if (bl2) {
            byte[] byArray = byteBuffer.array();
            int n11 = byteBuffer.arrayOffset() + n;
            byte[] byArray4 = bl ? this.engineUpdate(byArray, n11, n3) : this.engineDoFinal(byArray, n11, n3);
            byteBuffer.position(n2);
            if (byArray4 != null && byArray4.length != 0) {
                byteBuffer2.put(byArray4);
                n5 = byArray4.length;
            }
        } else {
            int n12;
            byte[] byArray = new byte[CipherSpi.getTempArraySize(n3)];
            do {
                byte[] byArray5;
                if ((n12 = Math.min(n3, byArray.length)) > 0) {
                    byteBuffer.get(byArray, 0, n12);
                }
                if ((byArray5 = bl || n3 > n12 ? this.engineUpdate(byArray, 0, n12) : this.engineDoFinal(byArray, 0, n12)) == null || byArray5.length == 0) continue;
                byteBuffer2.put(byArray5);
                n5 += byArray5.length;
            } while ((n3 -= n12) > 0);
        }
        return n5;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException("The underlying Cipher implementation does not support this method");
    }

    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("The underlying Cipher implementation does not support this method");
    }
}

