/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.BasicTypeSize;
import sun.jvm.hotspot.runtime.SignatureIterator;

public abstract class SignatureInfo
extends SignatureIterator {
    protected boolean hasIterated;
    protected int size;
    protected int type = BasicType.getTIllegal();

    protected void lazyIterate() {
        if (!this.hasIterated) {
            this.iterate();
            this.hasIterated = true;
        }
    }

    protected abstract void set(int var1, int var2);

    @Override
    public void doBool() {
        this.set(BasicTypeSize.getTBooleanSize(), BasicType.getTBoolean());
    }

    @Override
    public void doChar() {
        this.set(BasicTypeSize.getTCharSize(), BasicType.getTChar());
    }

    @Override
    public void doFloat() {
        this.set(BasicTypeSize.getTFloatSize(), BasicType.getTFloat());
    }

    @Override
    public void doDouble() {
        this.set(BasicTypeSize.getTDoubleSize(), BasicType.getTDouble());
    }

    @Override
    public void doByte() {
        this.set(BasicTypeSize.getTByteSize(), BasicType.getTByte());
    }

    @Override
    public void doShort() {
        this.set(BasicTypeSize.getTShortSize(), BasicType.getTShort());
    }

    @Override
    public void doInt() {
        this.set(BasicTypeSize.getTIntSize(), BasicType.getTInt());
    }

    @Override
    public void doLong() {
        this.set(BasicTypeSize.getTLongSize(), BasicType.getTLong());
    }

    @Override
    public void doVoid() {
        this.set(BasicTypeSize.getTVoidSize(), BasicType.getTVoid());
    }

    @Override
    public void doObject(int begin, int end) {
        this.set(BasicTypeSize.getTObjectSize(), BasicType.getTObject());
    }

    @Override
    public void doArray(int begin, int end) {
        this.set(BasicTypeSize.getTArraySize(), BasicType.getTArray());
    }

    public SignatureInfo(Symbol signature) {
        super(signature);
    }

    public int size() {
        this.lazyIterate();
        return this.size;
    }

    public int type() {
        this.lazyIterate();
        return this.type;
    }
}

