/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VirtualBaseConstructor;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Node
extends VMObject {
    private static CIntField outmaxField;
    private static CIntField outcntField;
    private static CIntField maxField;
    private static CIntField cntField;
    private static CIntField idxField;
    private static AddressField outField;
    private static AddressField inField;
    private static VirtualBaseConstructor virtualConstructor;
    private static Type nodeType;
    static HashMap nodes;
    static HashMap constructors;
    private Node[] _out;
    private Node[] _in;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("Node");
        outmaxField = new CIntField(type.getCIntegerField("_outmax"), 0L);
        outcntField = new CIntField(type.getCIntegerField("_outcnt"), 0L);
        maxField = new CIntField(type.getCIntegerField("_max"), 0L);
        cntField = new CIntField(type.getCIntegerField("_cnt"), 0L);
        idxField = new CIntField(type.getCIntegerField("_idx"), 0L);
        outField = type.getAddressField("_out");
        inField = type.getAddressField("_in");
        nodeType = db.lookupType("Node");
        virtualConstructor = new VirtualBaseConstructor(db, nodeType, "sun.jvm.hotspot.opto", Node.class);
    }

    public static Node create(Address addr) {
        if (addr == null) {
            return null;
        }
        Node result = (Node)nodes.get(addr);
        if (result == null) {
            result = (Node)virtualConstructor.instantiateWrapperFor(addr);
            nodes.put(addr, result);
        }
        return result;
    }

    public Node(Address addr) {
        super(addr);
    }

    public int outcnt() {
        return (int)outcntField.getValue(this.getAddress());
    }

    public int req() {
        return (int)cntField.getValue(this.getAddress());
    }

    public int len() {
        return (int)maxField.getValue(this.getAddress());
    }

    public int idx() {
        return (int)idxField.getValue(this.getAddress());
    }

    public Node rawOut(int i) {
        if (this._out == null) {
            int addressSize = (int)VM.getVM().getAddressSize();
            this._out = new Node[this.outcnt()];
            Address ptr = outField.getValue(this.getAddress());
            for (int j = 0; j < this.outcnt(); ++j) {
                this._out[j] = Node.create(ptr.getAddressAt(j * addressSize));
            }
        }
        return this._out[i];
    }

    public Node in(int i) {
        if (this._in == null) {
            int addressSize = (int)VM.getVM().getAddressSize();
            this._in = new Node[this.len()];
            Address ptr = inField.getValue(this.getAddress());
            for (int j = 0; j < this.len(); ++j) {
                this._in[j] = Node.create(ptr.getAddressAt(j * addressSize));
            }
        }
        return this._in[i];
    }

    public ArrayList collect(int d, boolean onlyCtrl) {
        int depth = Math.abs(d);
        ArrayList<Node> nstack = new ArrayList<Node>();
        BitSet set = new BitSet();
        nstack.add(this);
        set.set(this.idx());
        int begin = 0;
        int end = 0;
        for (int i = 0; i < depth; ++i) {
            end = nstack.size();
            for (int j = begin; j < end; ++j) {
                Node tp = (Node)nstack.get(j);
                int limit = d > 0 ? tp.len() : tp.outcnt();
                for (int k = 0; k < limit; ++k) {
                    Node n;
                    Node node = n = d > 0 ? tp.in(k) : tp.rawOut(k);
                    if (n == null || set.get(n.idx())) continue;
                    nstack.add(n);
                    set.set(n.idx());
                }
            }
            begin = end;
        }
        return nstack;
    }

    protected void dumpNodes(Node s, int d, boolean onlyCtrl, PrintStream out) {
        if (s == null) {
            return;
        }
        ArrayList nstack = s.collect(d, onlyCtrl);
        int end = nstack.size();
        if (d > 0) {
            for (int j = end - 1; j >= 0; --j) {
                ((Node)nstack.get(j)).dump(out);
            }
        } else {
            for (int j = 0; j < end; ++j) {
                ((Node)nstack.get(j)).dump(out);
            }
        }
    }

    public void dump(int depth, PrintStream out) {
        this.dumpNodes(this, depth, false, out);
    }

    public String Name() {
        Type t = VM.getVM().getTypeDataBase().findDynamicTypeForAddress(this.getAddress(), nodeType);
        String name = null;
        if (t != null) {
            name = t.toString();
        } else {
            Class<?> c = this.getClass();
            if (c == Node.class) {
                return "UnknownNode<" + this.getAddress().getAddressAt(0L) + ">";
            }
            name = this.getClass().getName();
            if (name.startsWith("sun.jvm.hotspot.opto.")) {
                name = name.substring("sun.jvm.hotspot.opto.".length());
            }
        }
        if (name.endsWith("Node")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    public void dump(PrintStream out) {
        out.print(" ");
        out.print(this.idx());
        out.print("\t");
        out.print(this.Name());
        out.print("\t=== ");
        int i = 0;
        for (i = 0; i < this.req(); ++i) {
            Node n = this.in(i);
            if (n != null) {
                out.print(' ');
                out.print(this.in(i).idx());
            } else {
                out.print("_");
            }
            out.print(" ");
        }
        if (this.len() != this.req()) {
            int prec = 0;
            while (i < this.len()) {
                Node n = this.in(i);
                if (n != null) {
                    if (prec++ == 0) {
                        out.print("| ");
                    }
                    out.print(this.in(i).idx());
                }
                out.print(" ");
                ++i;
            }
        }
        this.dumpOut(out);
        this.dumpSpec(out);
        out.println();
    }

    void dumpOut(PrintStream out) {
        out.print(" [[");
        for (int i = 0; i < this.outcnt(); ++i) {
            Node u = this.rawOut(i);
            if (u == null) {
                out.print("_ ");
                continue;
            }
            out.print(' ');
            out.print(u.idx());
            out.print(' ');
        }
        out.print("]] ");
    }

    public void dumpSpec(PrintStream out) {
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Node.initialize(VM.getVM().getTypeDataBase());
            }
        });
        nodes = new HashMap();
        constructors = new HashMap();
    }

    static abstract class Instantiator {
        Instantiator() {
        }

        abstract Node create(Address var1);
    }
}

